/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet;

import java.io.Serializable;
import java.util.Locale;
import org.apache.comet.ConfigBuilder;
import org.apache.comet.ConfigEntry;
import org.apache.comet.ConfigEntryWithDefault;
import org.apache.comet.OptionalConfigEntry;
import org.apache.comet.shims.ShimCometConf;
import org.apache.spark.network.util.ByteUnit;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

public final class CometConf$
implements ShimCometConf {
    public static final CometConf$ MODULE$ = new CometConf$();
    private static final String TUNING_GUIDE;
    private static final ListBuffer<ConfigEntry<?>> allConfs;
    private static final String COMET_EXEC_CONFIG_PREFIX;
    private static final ConfigEntry<Object> COMET_ENABLED;
    private static final ConfigEntry<Object> COMET_NATIVE_SCAN_ENABLED;
    private static final ConfigEntry<Object> COMET_PARQUET_PARALLEL_IO_ENABLED;
    private static final ConfigEntry<Object> COMET_PARQUET_PARALLEL_IO_THREADS;
    private static final ConfigEntry<Object> COMET_IO_MERGE_RANGES;
    private static final ConfigEntry<Object> COMET_IO_MERGE_RANGES_DELTA;
    private static final ConfigEntry<Object> COMET_IO_ADJUST_READRANGE_SKEW;
    private static final ConfigEntry<Object> COMET_CONVERT_FROM_PARQUET_ENABLED;
    private static final ConfigEntry<Object> COMET_CONVERT_FROM_JSON_ENABLED;
    private static final ConfigEntry<Object> COMET_CONVERT_FROM_CSV_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_PROJECT_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_FILTER_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_SORT_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_LOCAL_LIMIT_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_GLOBAL_LIMIT_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_BROADCAST_HASH_JOIN_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_BROADCAST_EXCHANGE_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_HASH_JOIN_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_SORT_MERGE_JOIN_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_AGGREGATE_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_COLLECT_LIMIT_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_COALESCE_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_UNION_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_EXPAND_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_WINDOW_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_TAKE_ORDERED_AND_PROJECT_ENABLED;
    private static final ConfigEntry<Object> COMET_EXEC_SORT_MERGE_JOIN_WITH_JOIN_FILTER_ENABLED;
    private static final ConfigEntry<Object> COMET_EXPR_STDDEV_ENABLED;
    private static final OptionalConfigEntry<Object> COMET_MEMORY_OVERHEAD;
    private static final ConfigEntry<Object> COMET_MEMORY_OVERHEAD_FACTOR;
    private static final ConfigEntry<Object> COMET_MEMORY_OVERHEAD_MIN_MIB;
    private static final ConfigEntry<Object> COMET_EXEC_SHUFFLE_ENABLED;
    private static final ConfigEntry<String> COMET_SHUFFLE_MODE;
    private static final ConfigEntry<Object> COMET_EXEC_BROADCAST_FORCE_ENABLED;
    private static final ConfigEntry<Object> COMET_REPLACE_SMJ;
    private static final ConfigEntry<String> COMET_EXEC_SHUFFLE_CODEC;
    private static final ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_ASYNC_ENABLED;
    private static final ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_ASYNC_THREAD_NUM;
    private static final ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_ASYNC_MAX_THREAD_NUM;
    private static final ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_SPILL_THRESHOLD;
    private static final OptionalConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_MEMORY_SIZE;
    private static final ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_MEMORY_FACTOR;
    private static final ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_UNIFIED_MEMORY_ALLOCATOR_IN_TEST;
    private static final ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_BATCH_SIZE;
    private static final ConfigEntry<Object> COMET_SHUFFLE_PREFER_DICTIONARY_RATIO;
    private static final ConfigEntry<Object> COMET_DPP_FALLBACK_ENABLED;
    private static final ConfigEntry<Object> COMET_DEBUG_ENABLED;
    private static final ConfigEntry<Object> COMET_EXPLAIN_VERBOSE_ENABLED;
    private static final ConfigEntry<Object> COMET_EXPLAIN_NATIVE_ENABLED;
    private static final ConfigEntry<Object> COMET_EXPLAIN_FALLBACK_ENABLED;
    private static final ConfigEntry<Object> COMET_WORKER_THREADS;
    private static final ConfigEntry<Object> COMET_BLOCKING_THREADS;
    private static final ConfigEntry<Object> COMET_BATCH_SIZE;
    private static final ConfigEntry<Object> COMET_EXEC_MEMORY_FRACTION;
    private static final ConfigEntry<Object> COMET_PARQUET_ENABLE_DIRECT_BUFFER;
    private static final ConfigEntry<Object> COMET_SCAN_PREFETCH_ENABLED;
    private static final ConfigEntry<Object> COMET_SCAN_PREFETCH_THREAD_NUM;
    private static final ConfigEntry<Object> COMET_NATIVE_LOAD_REQUIRED;
    private static final ConfigEntry<Object> COMET_EXCEPTION_ON_LEGACY_DATE_TIMESTAMP;
    private static final ConfigEntry<Object> COMET_USE_DECIMAL_128;
    private static final ConfigEntry<Object> COMET_USE_LAZY_MATERIALIZATION;
    private static final ConfigEntry<Object> COMET_SCHEMA_EVOLUTION_ENABLED;
    private static final ConfigEntry<Object> COMET_SPARK_TO_ARROW_ENABLED;
    private static final ConfigEntry<Seq<String>> COMET_SPARK_TO_ARROW_SUPPORTED_OPERATOR_LIST;
    private static final ConfigEntry<Object> COMET_ANSI_MODE_ENABLED;
    private static final ConfigEntry<Object> COMET_CASE_CONVERSION_ENABLED;
    private static final ConfigEntry<Object> COMET_CAST_ALLOW_INCOMPATIBLE;
    private static final ConfigEntry<Object> COMET_REGEXP_ALLOW_INCOMPATIBLE;
    private static boolean COMET_SCHEMA_EVOLUTION_ENABLED_DEFAULT;
    private static boolean COMET_ANSI_MODE_ENABLED_DEFAULT;

    static {
        ShimCometConf.$init$(MODULE$);
        TUNING_GUIDE = "For more information, refer to the Comet Tuning Guide (https://datafusion.apache.org/comet/user-guide/tuning.html)";
        allConfs = new ListBuffer();
        COMET_EXEC_CONFIG_PREFIX = "spark.comet.exec";
        COMET_ENABLED = MODULE$.conf("spark.comet.enabled").doc("Whether to enable Comet extension for Spark. When this is turned on, Spark will use Comet to read Parquet data source. Note that to enable native vectorized execution, both this config and 'spark.comet.exec.enabled' need to be enabled. By default, this config is the value of the env var `ENABLE_COMET` if set, or true otherwise.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)package$.MODULE$.env().getOrElse((Object)"ENABLE_COMET", (Function0 & Serializable)() -> "true")))));
        COMET_NATIVE_SCAN_ENABLED = MODULE$.conf("spark.comet.scan.enabled").doc("Whether to enable native scans. When this is turned on, Spark will use Comet to read supported data sources (currently only Parquet is supported natively). Note that to enable native vectorized execution, both this config and 'spark.comet.exec.enabled' need to be enabled.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        COMET_PARQUET_PARALLEL_IO_ENABLED = MODULE$.conf("spark.comet.parquet.read.parallel.io.enabled").doc("Whether to enable Comet's parallel reader for Parquet files. The parallel reader reads ranges of consecutive data in a  file in parallel. It is faster for large files and row groups but uses more resources.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        COMET_PARQUET_PARALLEL_IO_THREADS = MODULE$.conf("spark.comet.parquet.read.parallel.io.thread-pool.size").doc("The maximum number of parallel threads the parallel reader will use in a single executor. For executors configured with a smaller number of cores, use a smaller number.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)16));
        COMET_IO_MERGE_RANGES = MODULE$.conf("spark.comet.parquet.read.io.mergeRanges").doc("When enabled the parallel reader will try to merge ranges of data that are separated by less than 'comet.parquet.read.io.mergeRanges.delta' bytes. Longer continuous reads are faster on cloud storage.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        COMET_IO_MERGE_RANGES_DELTA = MODULE$.conf("spark.comet.parquet.read.io.mergeRanges.delta").doc("The delta in bytes between consecutive read ranges below which the parallel reader will try to merge the ranges. The default is 8MB.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)0x800000));
        COMET_IO_ADJUST_READRANGE_SKEW = MODULE$.conf("spark.comet.parquet.read.io.adjust.readRange.skew").doc("In the parallel reader, if the read ranges submitted are skewed in sizes, this option will cause the reader to break up larger read ranges into smaller ranges to reduce the skew. This will result in a slightly larger number of connections opened to the file system but may give improved performance.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_CONVERT_FROM_PARQUET_ENABLED = MODULE$.conf("spark.comet.convert.parquet.enabled").doc("When enabled, data from Spark (non-native) Parquet v1 and v2 scans will be converted to Arrow format. Note that to enable native vectorized execution, both this config and 'spark.comet.exec.enabled' need to be enabled.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_CONVERT_FROM_JSON_ENABLED = MODULE$.conf("spark.comet.convert.json.enabled").doc("When enabled, data from Spark (non-native) JSON v1 and v2 scans will be converted to Arrow format. Note that to enable native vectorized execution, both this config and 'spark.comet.exec.enabled' need to be enabled.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_CONVERT_FROM_CSV_ENABLED = MODULE$.conf("spark.comet.convert.csv.enabled").doc("When enabled, data from Spark (non-native) CSV v1 and v2 scans will be converted to Arrow format. Note that to enable native vectorized execution, both this config and 'spark.comet.exec.enabled' need to be enabled.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_EXEC_ENABLED = MODULE$.conf(MODULE$.COMET_EXEC_CONFIG_PREFIX() + ".enabled").doc("Whether to enable Comet native vectorized execution for Spark. This controls whether Spark should convert operators into their Comet counterparts and execute them in native space. Note: each operator is associated with a separate config in the format of 'spark.comet.exec.<operator_name>.enabled' at the moment, and both the config and this need to be turned on, in order for the operator to be executed in native.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        COMET_EXEC_PROJECT_ENABLED = MODULE$.createExecEnabledConfig("project", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_FILTER_ENABLED = MODULE$.createExecEnabledConfig("filter", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_SORT_ENABLED = MODULE$.createExecEnabledConfig("sort", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_LOCAL_LIMIT_ENABLED = MODULE$.createExecEnabledConfig("localLimit", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_GLOBAL_LIMIT_ENABLED = MODULE$.createExecEnabledConfig("globalLimit", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_BROADCAST_HASH_JOIN_ENABLED = MODULE$.createExecEnabledConfig("broadcastHashJoin", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_BROADCAST_EXCHANGE_ENABLED = MODULE$.createExecEnabledConfig("broadcastExchange", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_HASH_JOIN_ENABLED = MODULE$.createExecEnabledConfig("hashJoin", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_SORT_MERGE_JOIN_ENABLED = MODULE$.createExecEnabledConfig("sortMergeJoin", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_AGGREGATE_ENABLED = MODULE$.createExecEnabledConfig("aggregate", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_COLLECT_LIMIT_ENABLED = MODULE$.createExecEnabledConfig("collectLimit", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_COALESCE_ENABLED = MODULE$.createExecEnabledConfig("coalesce", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_UNION_ENABLED = MODULE$.createExecEnabledConfig("union", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_EXPAND_ENABLED = MODULE$.createExecEnabledConfig("expand", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_WINDOW_ENABLED = MODULE$.createExecEnabledConfig("window", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_TAKE_ORDERED_AND_PROJECT_ENABLED = MODULE$.createExecEnabledConfig("takeOrderedAndProject", true, MODULE$.createExecEnabledConfig$default$3());
        COMET_EXEC_SORT_MERGE_JOIN_WITH_JOIN_FILTER_ENABLED = MODULE$.conf("spark.comet.exec.sortMergeJoinWithJoinFilter.enabled").doc("Experimental support for Sort Merge Join with filter").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_EXPR_STDDEV_ENABLED = MODULE$.createExecEnabledConfig("stddev", true, (Option<String>)new Some((Object)"stddev is slower than Spark's implementation"));
        COMET_MEMORY_OVERHEAD = MODULE$.conf("spark.comet.memoryOverhead").doc("The amount of additional memory to be allocated per executor process for Comet, in MiB. This config is optional. If this is not specified, it will be set to `spark.comet.memory.overhead.factor` * `spark.executor.memory`. This is memory that accounts for things like Comet native execution, Comet shuffle, etc.").bytesConf(ByteUnit.MiB).createOptional();
        COMET_MEMORY_OVERHEAD_FACTOR = MODULE$.conf("spark.comet.memory.overhead.factor").doc("Fraction of executor memory to be allocated as additional non-heap memory per executor process for Comet.").doubleConf().checkValue((Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable)factor -> factor > 0.0, "Ensure that Comet memory overhead factor is a double greater than 0").createWithDefault(BoxesRunTime.boxToDouble((double)0.2));
        COMET_MEMORY_OVERHEAD_MIN_MIB = MODULE$.conf("spark.comet.memory.overhead.min").doc("Minimum amount of additional memory to be allocated per executor process for Comet, in MiB.").bytesConf(ByteUnit.MiB).checkValue((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable)x$1 -> x$1 >= 0L, "Ensure that Comet memory overhead min is a long greater than or equal to 0").createWithDefault(BoxesRunTime.boxToLong((long)384L));
        COMET_EXEC_SHUFFLE_ENABLED = MODULE$.conf(MODULE$.COMET_EXEC_CONFIG_PREFIX() + ".shuffle.enabled").doc("Whether to enable Comet native shuffle. Note that this requires setting 'spark.shuffle.manager' to 'org.apache.spark.sql.comet.execution.shuffle.CometShuffleManager'. 'spark.shuffle.manager' must be set before starting the Spark application and cannot be changed during the application.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        COMET_SHUFFLE_MODE = MODULE$.conf(MODULE$.COMET_EXEC_CONFIG_PREFIX() + ".shuffle.mode").doc("The mode of Comet shuffle. This config is only effective if Comet shuffle is enabled. Available modes are 'native', 'jvm', and 'auto'. 'native' is for native shuffle which has best performance in general. 'jvm' is for jvm-based columnar shuffle which has higher coverage than native shuffle. 'auto' is for Comet to choose the best shuffle mode based on the query plan.").internal().stringConf().transform((Function1<String, String>)(Function1 & Serializable)x$2 -> x$2.toLowerCase(Locale.ROOT)).checkValues((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"native", "jvm", "auto"})))).createWithDefault("auto");
        COMET_EXEC_BROADCAST_FORCE_ENABLED = MODULE$.conf(MODULE$.COMET_EXEC_CONFIG_PREFIX() + ".broadcast.enabled").doc("Whether to force enabling broadcasting for Comet native operators. Comet broadcast feature will be enabled automatically by Comet extension. But for unit tests, we need this feature to force enabling it for invalid cases. So this config is only used for unit test.").internal().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_REPLACE_SMJ = MODULE$.conf(MODULE$.COMET_EXEC_CONFIG_PREFIX() + ".replaceSortMergeJoin").doc("Experimental feature to force Spark to replace SortMergeJoin with ShuffledHashJoin for improved performance. This feature is not stable yet. " + MODULE$.TUNING_GUIDE() + ".").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_EXEC_SHUFFLE_CODEC = MODULE$.conf(MODULE$.COMET_EXEC_CONFIG_PREFIX() + ".shuffle.codec").doc("The codec of Comet native shuffle used to compress shuffle data. Only zstd is supported.").stringConf().createWithDefault("zstd");
        COMET_COLUMNAR_SHUFFLE_ASYNC_ENABLED = MODULE$.conf("spark.comet.columnar.shuffle.async.enabled").doc("Whether to enable asynchronous shuffle for Arrow-based shuffle.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_COLUMNAR_SHUFFLE_ASYNC_THREAD_NUM = MODULE$.conf("spark.comet.columnar.shuffle.async.thread.num").doc("Number of threads used for Comet async columnar shuffle per shuffle task. Note that more threads means more memory requirement to buffer shuffle data before flushing to disk. Also, more threads may not always improve performance, and should be set based on the number of cores available.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)3));
        COMET_COLUMNAR_SHUFFLE_ASYNC_MAX_THREAD_NUM = MODULE$.conf("spark.comet.columnar.shuffle.async.max.thread.num").doc("Maximum number of threads on an executor used for Comet async columnar shuffle. This is the upper bound of total number of shuffle threads per executor. In other words, if the number of cores * the number of shuffle threads per task `spark.comet.columnar.shuffle.async.thread.num` is larger than this config. Comet will use this config as the number of shuffle threads per executor instead.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)100));
        COMET_COLUMNAR_SHUFFLE_SPILL_THRESHOLD = MODULE$.conf("spark.comet.columnar.shuffle.spill.threshold").doc("Number of rows to be spilled used for Comet columnar shuffle. For every configured number of rows, a new spill file will be created. Higher value means more memory requirement to buffer shuffle data before flushing to disk. As Comet uses columnar shuffle which is columnar format, higher value usually helps to improve shuffle data compression ratio. This is internal config for testing purpose or advanced tuning.").internal().intConf().createWithDefault(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        COMET_COLUMNAR_SHUFFLE_MEMORY_SIZE = MODULE$.conf("spark.comet.columnar.shuffle.memorySize").internal().doc("Test-only config. This is only used to test Comet shuffle with Spark tests. The optional maximum size of the memory used for Comet columnar shuffle, in MiB. Note that this config is only used when `spark.comet.exec.shuffle.mode` is `jvm`. Once allocated memory size reaches this config, the current batch will be flushed to disk immediately. If this is not configured, Comet will use `spark.comet.shuffle.memory.factor` * `spark.comet.memoryOverhead` as shuffle memory size. If final calculated value is larger than Comet memory overhead, Comet will use Comet memory overhead as shuffle memory size.").bytesConf(ByteUnit.MiB).createOptional();
        COMET_COLUMNAR_SHUFFLE_MEMORY_FACTOR = MODULE$.conf("spark.comet.columnar.shuffle.memory.factor").internal().doc("Test-only config. This is only used to test Comet shuffle with Spark tests. Fraction of Comet memory to be allocated per executor process for Comet shuffle. Comet memory size is specified by `spark.comet.memoryOverhead` or calculated by `spark.comet.memory.overhead.factor` * `spark.executor.memory`.").doubleConf().checkValue((Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable)factor -> factor > 0.0, "Ensure that Comet shuffle memory overhead factor is a double greater than 0").createWithDefault(BoxesRunTime.boxToDouble((double)1.0));
        COMET_COLUMNAR_SHUFFLE_UNIFIED_MEMORY_ALLOCATOR_IN_TEST = MODULE$.conf("spark.comet.columnar.shuffle.unifiedMemoryAllocatorTest").doc("Whether to use Spark unified memory allocator for Comet columnar shuffle in tests.If not configured, Comet will use a test-only memory allocator for Comet columnar shuffle when Spark test env detected. The test-ony allocator is proposed to run with Spark tests as these tests require on-heap memory configuration. By default, this config is false.").internal().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_COLUMNAR_SHUFFLE_BATCH_SIZE = MODULE$.conf("spark.comet.columnar.shuffle.batch.size").internal().doc("Batch size when writing out sorted spill files on the native side. Note that this should not be larger than batch size (i.e., `spark.comet.batchSize`). Otherwise it will produce larger batches than expected in the native operator after shuffle.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)8192));
        COMET_SHUFFLE_PREFER_DICTIONARY_RATIO = MODULE$.conf("spark.comet.shuffle.preferDictionary.ratio").doc("The ratio of total values to distinct values in a string column to decide whether to prefer dictionary encoding when shuffling the column. If the ratio is higher than this config, dictionary encoding will be used on shuffling string column. This config is effective if it is higher than 1.0. Note that this config is only used when `spark.comet.exec.shuffle.mode` is `jvm`.").doubleConf().createWithDefault(BoxesRunTime.boxToDouble((double)10.0));
        COMET_DPP_FALLBACK_ENABLED = MODULE$.conf("spark.comet.dppFallback.enabled").doc("Whether to fall back to Spark for queries that use DPP.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        COMET_DEBUG_ENABLED = MODULE$.conf("spark.comet.debug.enabled").doc("Whether to enable debug mode for Comet. When enabled, Comet will do additional checks for debugging purpose. For example, validating array when importing arrays from JVM at native side. Note that these checks may be expensive in performance and should only be enabled for debugging purpose.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_EXPLAIN_VERBOSE_ENABLED = MODULE$.conf("spark.comet.explain.verbose.enabled").doc("When this setting is enabled, Comet will provide a verbose tree representation of the extended information.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_EXPLAIN_NATIVE_ENABLED = MODULE$.conf("spark.comet.explain.native.enabled").doc("When this setting is enabled, Comet will provide a tree representation of the native query plan before execution and again after execution, with metrics.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_EXPLAIN_FALLBACK_ENABLED = MODULE$.conf("spark.comet.explainFallback.enabled").doc("When this setting is enabled, Comet will provide logging explaining the reason(s) why a query stage cannot be executed natively. Set this to false to reduce the amount of logging.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_WORKER_THREADS = MODULE$.conf("spark.comet.workerThreads").internal().doc("The number of worker threads used for Comet native execution. By default, this config is 4.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)4));
        COMET_BLOCKING_THREADS = MODULE$.conf("spark.comet.blockingThreads").internal().doc("The number of blocking threads used for Comet native execution. By default, this config is 10.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)10));
        COMET_BATCH_SIZE = MODULE$.conf("spark.comet.batchSize").doc("The columnar batch size, i.e., the maximum number of rows that a batch can contain.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)8192));
        COMET_EXEC_MEMORY_FRACTION = MODULE$.conf("spark.comet.exec.memoryFraction").doc("The fraction of memory from Comet memory overhead that the native memory manager can use for execution. The purpose of this config is to set aside memory for untracked data structures, as well as imprecise size estimation during memory acquisition.").doubleConf().createWithDefault(BoxesRunTime.boxToDouble((double)0.7));
        COMET_PARQUET_ENABLE_DIRECT_BUFFER = MODULE$.conf("spark.comet.parquet.enable.directBuffer").doc("Whether to use Java direct byte buffer when reading Parquet.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_SCAN_PREFETCH_ENABLED = MODULE$.conf("spark.comet.scan.preFetch.enabled").doc("Whether to enable pre-fetching feature of CometScan.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_SCAN_PREFETCH_THREAD_NUM = MODULE$.conf("spark.comet.scan.preFetch.threadNum").doc("The number of threads running pre-fetching for CometScan. Effective if " + MODULE$.COMET_SCAN_PREFETCH_ENABLED().key() + " is enabled. Note that more pre-fetching threads means more memory requirement to store pre-fetched row groups.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)2));
        COMET_NATIVE_LOAD_REQUIRED = MODULE$.conf("spark.comet.nativeLoadRequired").doc("Whether to require Comet native library to load successfully when Comet is enabled. If not, Comet will silently fallback to Spark when it fails to load the native lib. Otherwise, an error will be thrown and the Spark job will be aborted.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_EXCEPTION_ON_LEGACY_DATE_TIMESTAMP = MODULE$.conf("spark.comet.exceptionOnDatetimeRebase").doc("Whether to throw exception when seeing dates/timestamps from the legacy hybrid (Julian + Gregorian) calendar. Since Spark 3, dates/timestamps were written according to the Proleptic Gregorian calendar. When this is true, Comet will throw exceptions when seeing these dates/timestamps that were written by Spark version before 3.0. If this is false, these dates/timestamps will be read as if they were written to the Proleptic Gregorian calendar and will not be rebased.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_USE_DECIMAL_128 = MODULE$.conf("spark.comet.use.decimal128").internal().doc("If true, Comet will always use 128 bits to represent a decimal value, regardless of its precision. If false, Comet will use 32, 64 and 128 bits respectively depending on the precision. N.B. this is NOT a user-facing config but should be inferred and set by Comet itself.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_USE_LAZY_MATERIALIZATION = MODULE$.conf("spark.comet.use.lazyMaterialization").internal().doc("Whether to enable lazy materialization for Comet. When this is turned on, Comet will read Parquet data source lazily for string and binary columns. For filter operations, lazy materialization will improve read performance by skipping unused pages.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        COMET_SCHEMA_EVOLUTION_ENABLED = MODULE$.conf("spark.comet.schemaEvolution.enabled").internal().doc("Whether to enable schema evolution in Comet. For instance, promoting a integer column to a long column, a float column to a double column, etc. This is automaticallyenabled when reading from Iceberg tables.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)MODULE$.COMET_SCHEMA_EVOLUTION_ENABLED_DEFAULT()));
        COMET_SPARK_TO_ARROW_ENABLED = MODULE$.conf("spark.comet.sparkToColumnar.enabled").internal().doc("Whether to enable Spark to Arrow columnar conversion. When this is turned on, Comet will convert operators in `spark.comet.sparkToColumnar.supportedOperatorList` into Arrow columnar format before processing.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_SPARK_TO_ARROW_SUPPORTED_OPERATOR_LIST = MODULE$.conf("spark.comet.sparkToColumnar.supportedOperatorList").doc("A comma-separated list of operators that will be converted to Arrow columnar format when 'spark.comet.sparkToColumnar.enabled' is true").stringConf().toSequence().createWithDefault((Seq<String>)new .colon.colon((Object)"Range,InMemoryTableScan", (List)Nil$.MODULE$));
        COMET_ANSI_MODE_ENABLED = MODULE$.conf("spark.comet.ansi.enabled").internal().doc("Comet does not respect ANSI mode in most cases and by default will not accelerate queries when ansi mode is enabled. Enable this setting to test Comet's experimental support for ANSI mode. This should not be used in production.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)MODULE$.COMET_ANSI_MODE_ENABLED_DEFAULT()));
        COMET_CASE_CONVERSION_ENABLED = MODULE$.conf("spark.comet.caseConversion.enabled").doc("Java uses locale-specific rules when converting strings to upper or lower case and Rust does not, so we disable upper and lower by default.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_CAST_ALLOW_INCOMPATIBLE = MODULE$.conf("spark.comet.cast.allowIncompatible").doc("Comet is not currently fully compatible with Spark for all cast operations. Set this config to true to allow them anyway. See compatibility guide for more information.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        COMET_REGEXP_ALLOW_INCOMPATIBLE = MODULE$.conf("spark.comet.regexp.allowIncompatible").doc("Comet is not currently fully compatible with Spark for all regular expressions. Set this config to true to allow them anyway using Rust's regular expression engine. See compatibility guide for more information.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public boolean COMET_SCHEMA_EVOLUTION_ENABLED_DEFAULT() {
        return COMET_SCHEMA_EVOLUTION_ENABLED_DEFAULT;
    }

    @Override
    public boolean COMET_ANSI_MODE_ENABLED_DEFAULT() {
        return COMET_ANSI_MODE_ENABLED_DEFAULT;
    }

    @Override
    public void org$apache$comet$shims$ShimCometConf$_setter_$COMET_SCHEMA_EVOLUTION_ENABLED_DEFAULT_$eq(boolean x$1) {
        COMET_SCHEMA_EVOLUTION_ENABLED_DEFAULT = x$1;
    }

    @Override
    public void org$apache$comet$shims$ShimCometConf$_setter_$COMET_ANSI_MODE_ENABLED_DEFAULT_$eq(boolean x$1) {
        COMET_ANSI_MODE_ENABLED_DEFAULT = x$1;
    }

    private String TUNING_GUIDE() {
        return TUNING_GUIDE;
    }

    public ListBuffer<ConfigEntry<?>> allConfs() {
        return allConfs;
    }

    public void register(ConfigEntryWithDefault<?> conf) {
        this.allConfs().append(conf);
    }

    public ConfigBuilder conf(String key) {
        return new ConfigBuilder(key);
    }

    public String COMET_EXEC_CONFIG_PREFIX() {
        return COMET_EXEC_CONFIG_PREFIX;
    }

    public ConfigEntry<Object> COMET_ENABLED() {
        return COMET_ENABLED;
    }

    public ConfigEntry<Object> COMET_NATIVE_SCAN_ENABLED() {
        return COMET_NATIVE_SCAN_ENABLED;
    }

    public ConfigEntry<Object> COMET_PARQUET_PARALLEL_IO_ENABLED() {
        return COMET_PARQUET_PARALLEL_IO_ENABLED;
    }

    public ConfigEntry<Object> COMET_PARQUET_PARALLEL_IO_THREADS() {
        return COMET_PARQUET_PARALLEL_IO_THREADS;
    }

    public ConfigEntry<Object> COMET_IO_MERGE_RANGES() {
        return COMET_IO_MERGE_RANGES;
    }

    public ConfigEntry<Object> COMET_IO_MERGE_RANGES_DELTA() {
        return COMET_IO_MERGE_RANGES_DELTA;
    }

    public ConfigEntry<Object> COMET_IO_ADJUST_READRANGE_SKEW() {
        return COMET_IO_ADJUST_READRANGE_SKEW;
    }

    public ConfigEntry<Object> COMET_CONVERT_FROM_PARQUET_ENABLED() {
        return COMET_CONVERT_FROM_PARQUET_ENABLED;
    }

    public ConfigEntry<Object> COMET_CONVERT_FROM_JSON_ENABLED() {
        return COMET_CONVERT_FROM_JSON_ENABLED;
    }

    public ConfigEntry<Object> COMET_CONVERT_FROM_CSV_ENABLED() {
        return COMET_CONVERT_FROM_CSV_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_ENABLED() {
        return COMET_EXEC_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_PROJECT_ENABLED() {
        return COMET_EXEC_PROJECT_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_FILTER_ENABLED() {
        return COMET_EXEC_FILTER_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_SORT_ENABLED() {
        return COMET_EXEC_SORT_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_LOCAL_LIMIT_ENABLED() {
        return COMET_EXEC_LOCAL_LIMIT_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_GLOBAL_LIMIT_ENABLED() {
        return COMET_EXEC_GLOBAL_LIMIT_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_BROADCAST_HASH_JOIN_ENABLED() {
        return COMET_EXEC_BROADCAST_HASH_JOIN_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_BROADCAST_EXCHANGE_ENABLED() {
        return COMET_EXEC_BROADCAST_EXCHANGE_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_HASH_JOIN_ENABLED() {
        return COMET_EXEC_HASH_JOIN_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_SORT_MERGE_JOIN_ENABLED() {
        return COMET_EXEC_SORT_MERGE_JOIN_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_AGGREGATE_ENABLED() {
        return COMET_EXEC_AGGREGATE_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_COLLECT_LIMIT_ENABLED() {
        return COMET_EXEC_COLLECT_LIMIT_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_COALESCE_ENABLED() {
        return COMET_EXEC_COALESCE_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_UNION_ENABLED() {
        return COMET_EXEC_UNION_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_EXPAND_ENABLED() {
        return COMET_EXEC_EXPAND_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_WINDOW_ENABLED() {
        return COMET_EXEC_WINDOW_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_TAKE_ORDERED_AND_PROJECT_ENABLED() {
        return COMET_EXEC_TAKE_ORDERED_AND_PROJECT_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_SORT_MERGE_JOIN_WITH_JOIN_FILTER_ENABLED() {
        return COMET_EXEC_SORT_MERGE_JOIN_WITH_JOIN_FILTER_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXPR_STDDEV_ENABLED() {
        return COMET_EXPR_STDDEV_ENABLED;
    }

    public OptionalConfigEntry<Object> COMET_MEMORY_OVERHEAD() {
        return COMET_MEMORY_OVERHEAD;
    }

    public ConfigEntry<Object> COMET_MEMORY_OVERHEAD_FACTOR() {
        return COMET_MEMORY_OVERHEAD_FACTOR;
    }

    public ConfigEntry<Object> COMET_MEMORY_OVERHEAD_MIN_MIB() {
        return COMET_MEMORY_OVERHEAD_MIN_MIB;
    }

    public ConfigEntry<Object> COMET_EXEC_SHUFFLE_ENABLED() {
        return COMET_EXEC_SHUFFLE_ENABLED;
    }

    public ConfigEntry<String> COMET_SHUFFLE_MODE() {
        return COMET_SHUFFLE_MODE;
    }

    public ConfigEntry<Object> COMET_EXEC_BROADCAST_FORCE_ENABLED() {
        return COMET_EXEC_BROADCAST_FORCE_ENABLED;
    }

    public ConfigEntry<Object> COMET_REPLACE_SMJ() {
        return COMET_REPLACE_SMJ;
    }

    public ConfigEntry<String> COMET_EXEC_SHUFFLE_CODEC() {
        return COMET_EXEC_SHUFFLE_CODEC;
    }

    public ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_ASYNC_ENABLED() {
        return COMET_COLUMNAR_SHUFFLE_ASYNC_ENABLED;
    }

    public ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_ASYNC_THREAD_NUM() {
        return COMET_COLUMNAR_SHUFFLE_ASYNC_THREAD_NUM;
    }

    public ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_ASYNC_MAX_THREAD_NUM() {
        return COMET_COLUMNAR_SHUFFLE_ASYNC_MAX_THREAD_NUM;
    }

    public ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_SPILL_THRESHOLD() {
        return COMET_COLUMNAR_SHUFFLE_SPILL_THRESHOLD;
    }

    public OptionalConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_MEMORY_SIZE() {
        return COMET_COLUMNAR_SHUFFLE_MEMORY_SIZE;
    }

    public ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_MEMORY_FACTOR() {
        return COMET_COLUMNAR_SHUFFLE_MEMORY_FACTOR;
    }

    public ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_UNIFIED_MEMORY_ALLOCATOR_IN_TEST() {
        return COMET_COLUMNAR_SHUFFLE_UNIFIED_MEMORY_ALLOCATOR_IN_TEST;
    }

    public ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_BATCH_SIZE() {
        return COMET_COLUMNAR_SHUFFLE_BATCH_SIZE;
    }

    public ConfigEntry<Object> COMET_SHUFFLE_PREFER_DICTIONARY_RATIO() {
        return COMET_SHUFFLE_PREFER_DICTIONARY_RATIO;
    }

    public ConfigEntry<Object> COMET_DPP_FALLBACK_ENABLED() {
        return COMET_DPP_FALLBACK_ENABLED;
    }

    public ConfigEntry<Object> COMET_DEBUG_ENABLED() {
        return COMET_DEBUG_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXPLAIN_VERBOSE_ENABLED() {
        return COMET_EXPLAIN_VERBOSE_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXPLAIN_NATIVE_ENABLED() {
        return COMET_EXPLAIN_NATIVE_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXPLAIN_FALLBACK_ENABLED() {
        return COMET_EXPLAIN_FALLBACK_ENABLED;
    }

    public ConfigEntry<Object> COMET_WORKER_THREADS() {
        return COMET_WORKER_THREADS;
    }

    public ConfigEntry<Object> COMET_BLOCKING_THREADS() {
        return COMET_BLOCKING_THREADS;
    }

    public ConfigEntry<Object> COMET_BATCH_SIZE() {
        return COMET_BATCH_SIZE;
    }

    public ConfigEntry<Object> COMET_EXEC_MEMORY_FRACTION() {
        return COMET_EXEC_MEMORY_FRACTION;
    }

    public ConfigEntry<Object> COMET_PARQUET_ENABLE_DIRECT_BUFFER() {
        return COMET_PARQUET_ENABLE_DIRECT_BUFFER;
    }

    public ConfigEntry<Object> COMET_SCAN_PREFETCH_ENABLED() {
        return COMET_SCAN_PREFETCH_ENABLED;
    }

    public ConfigEntry<Object> COMET_SCAN_PREFETCH_THREAD_NUM() {
        return COMET_SCAN_PREFETCH_THREAD_NUM;
    }

    public ConfigEntry<Object> COMET_NATIVE_LOAD_REQUIRED() {
        return COMET_NATIVE_LOAD_REQUIRED;
    }

    public ConfigEntry<Object> COMET_EXCEPTION_ON_LEGACY_DATE_TIMESTAMP() {
        return COMET_EXCEPTION_ON_LEGACY_DATE_TIMESTAMP;
    }

    public ConfigEntry<Object> COMET_USE_DECIMAL_128() {
        return COMET_USE_DECIMAL_128;
    }

    public ConfigEntry<Object> COMET_USE_LAZY_MATERIALIZATION() {
        return COMET_USE_LAZY_MATERIALIZATION;
    }

    public ConfigEntry<Object> COMET_SCHEMA_EVOLUTION_ENABLED() {
        return COMET_SCHEMA_EVOLUTION_ENABLED;
    }

    public ConfigEntry<Object> COMET_SPARK_TO_ARROW_ENABLED() {
        return COMET_SPARK_TO_ARROW_ENABLED;
    }

    public ConfigEntry<Seq<String>> COMET_SPARK_TO_ARROW_SUPPORTED_OPERATOR_LIST() {
        return COMET_SPARK_TO_ARROW_SUPPORTED_OPERATOR_LIST;
    }

    public ConfigEntry<Object> COMET_ANSI_MODE_ENABLED() {
        return COMET_ANSI_MODE_ENABLED;
    }

    public ConfigEntry<Object> COMET_CASE_CONVERSION_ENABLED() {
        return COMET_CASE_CONVERSION_ENABLED;
    }

    public ConfigEntry<Object> COMET_CAST_ALLOW_INCOMPATIBLE() {
        return COMET_CAST_ALLOW_INCOMPATIBLE;
    }

    public ConfigEntry<Object> COMET_REGEXP_ALLOW_INCOMPATIBLE() {
        return COMET_REGEXP_ALLOW_INCOMPATIBLE;
    }

    private ConfigEntry<Object> createExecEnabledConfig(String exec, boolean defaultValue, Option<String> notes) {
        return this.conf(this.COMET_EXEC_CONFIG_PREFIX() + "." + exec + ".enabled").doc("Whether to enable " + exec + " by default." + notes.map((Function1 & Serializable)s -> " " + s + ".").getOrElse((Function0 & Serializable)() -> "")).booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)defaultValue));
    }

    private Option<String> createExecEnabledConfig$default$3() {
        return None$.MODULE$;
    }

    private CometConf$() {
    }
}

