/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.spark.comet.shims

import org.apache.spark.SparkConf

trait ShimCometDriverPlugin {
  // `org.apache.spark.internal.config.EXECUTOR_MEMORY_OVERHEAD_FACTOR` was added since Spark 3.3.0
  private val EXECUTOR_MEMORY_OVERHEAD_FACTOR = "spark.executor.memoryOverheadFactor"
  private val EXECUTOR_MEMORY_OVERHEAD_FACTOR_DEFAULT = 0.1
  // `org.apache.spark.internal.config.EXECUTOR_MIN_MEMORY_OVERHEAD` was added since Spark 4.0.0
  private val EXECUTOR_MIN_MEMORY_OVERHEAD = "spark.executor.minMemoryOverhead"
  private val EXECUTOR_MIN_MEMORY_OVERHEAD_DEFAULT = 384L

  def getMemoryOverheadFactor(sc: SparkConf): Double =
    sc.getDouble(
      EXECUTOR_MEMORY_OVERHEAD_FACTOR,
      EXECUTOR_MEMORY_OVERHEAD_FACTOR_DEFAULT)
  def getMemoryOverheadMinMib(sc: SparkConf): Long =
    sc.getLong(EXECUTOR_MIN_MEMORY_OVERHEAD, EXECUTOR_MIN_MEMORY_OVERHEAD_DEFAULT)
}
