/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains generic collection interfaces and implementations, and
 * other utilities for working with collections. It is a part of the open-source
 * <a href="http://guava-libraries.googlecode.com">Guava libraries</a>.
 *
 * <h2>Collection Types</h2>
 *
 * <dl>
 * <dt>{@link org.apache.comet.shaded.guava.collect.BiMap}
 * <dd>An extension of {@link java.util.Map} that guarantees the uniqueness of
 *     its values as well as that of its keys. This is sometimes called an
 *     "invertible map," since the restriction on values enables it to support
 *     an {@linkplain org.apache.comet.shaded.guava.collect.BiMap#inverse inverse view} --
 *     which is another instance of {@code BiMap}.
 *
 * <dt>{@link org.apache.comet.shaded.guava.collect.Multiset}
 * <dd>An extension of {@link java.util.Collection} that may contain duplicate
 *     values like a {@link java.util.List}, yet has order-independent equality
 *     like a {@link java.util.Set}.  One typical use for a multiset is to
 *     represent a histogram.
 *
 * <dt>{@link org.apache.comet.shaded.guava.collect.Multimap}
 * <dd>A new type, which is similar to {@link java.util.Map}, but may contain
 *     multiple entries with the same key. Some behaviors of
 *     {@link org.apache.comet.shaded.guava.collect.Multimap} are left unspecified and are
 *     provided only by the subtypes mentioned below.
 *
 * <dt>{@link org.apache.comet.shaded.guava.collect.ListMultimap}
 * <dd>An extension of {@link org.apache.comet.shaded.guava.collect.Multimap} which permits
 *     duplicate entries, supports random access of values for a particular key,
 *     and has <i>partially order-dependent equality</i> as defined by
 *     {@link org.apache.comet.shaded.guava.collect.ListMultimap#equals(Object)}. {@code
 *     ListMultimap} takes its name from the fact that the {@linkplain
 *     org.apache.comet.shaded.guava.collect.ListMultimap#get collection of values}
 *     associated with a given key fulfills the {@link java.util.List} contract.
 *
 * <dt>{@link org.apache.comet.shaded.guava.collect.SetMultimap}
 * <dd>An extension of {@link org.apache.comet.shaded.guava.collect.Multimap} which has
 *     order-independent equality and does not allow duplicate entries; that is,
 *     while a key may appear twice in a {@code SetMultimap}, each must map to a
 *     different value.  {@code SetMultimap} takes its name from the fact that
 *     the {@linkplain org.apache.comet.shaded.guava.collect.SetMultimap#get collection of
 *     values} associated with a given key fulfills the {@link java.util.Set}
 *     contract.
 *
 * <dt>{@link org.apache.comet.shaded.guava.collect.SortedSetMultimap}
 * <dd>An extension of {@link org.apache.comet.shaded.guava.collect.SetMultimap} for which
 *     the {@linkplain org.apache.comet.shaded.guava.collect.SortedSetMultimap#get
 *     collection values} associated with a given key is a
 *     {@link java.util.SortedSet}.
 *
 * <dt>{@link org.apache.comet.shaded.guava.collect.Table}
 * <dd>A new type, which is similar to {@link java.util.Map}, but which indexes
 *     its values by an ordered pair of keys, a row key and column key.
 *
 * <dt>{@link org.apache.comet.shaded.guava.collect.ClassToInstanceMap}
 * <dd>An extension of {@link java.util.Map} that associates a raw type with an
 *     instance of that type.
 * </dl>
 *
 * <h2>Collection Implementations</h2>
 *
 * <h3>of {@link java.util.List}</h3>
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.ImmutableList}
 * </ul>
 *
 * <h3>of {@link java.util.Set}</h3>
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.ImmutableSet}
 * <li>{@link org.apache.comet.shaded.guava.collect.ImmutableSortedSet}
 * <li>{@link org.apache.comet.shaded.guava.collect.ContiguousSet} (see {@code Range})
 * </ul>
 *
 * <h3>of {@link java.util.Map}</h3>
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.ImmutableMap}
 * <li>{@link org.apache.comet.shaded.guava.collect.ImmutableSortedMap}
 * <li>{@link org.apache.comet.shaded.guava.collect.MapMaker}
 * </ul>
 *
 * <h3>of {@link org.apache.comet.shaded.guava.collect.BiMap}</h3>
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.ImmutableBiMap}
 * <li>{@link org.apache.comet.shaded.guava.collect.HashBiMap}
 * <li>{@link org.apache.comet.shaded.guava.collect.EnumBiMap}
 * <li>{@link org.apache.comet.shaded.guava.collect.EnumHashBiMap}
 * </ul>
 *
 * <h3>of {@link org.apache.comet.shaded.guava.collect.Multiset}</h3>
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.ImmutableMultiset}
 * <li>{@link org.apache.comet.shaded.guava.collect.HashMultiset}
 * <li>{@link org.apache.comet.shaded.guava.collect.LinkedHashMultiset}
 * <li>{@link org.apache.comet.shaded.guava.collect.TreeMultiset}
 * <li>{@link org.apache.comet.shaded.guava.collect.EnumMultiset}
 * <li>{@link org.apache.comet.shaded.guava.collect.ConcurrentHashMultiset}
 * </ul>
 *
 * <h3>of {@link org.apache.comet.shaded.guava.collect.Multimap}</h3>
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.ImmutableMultimap}
 * <li>{@link org.apache.comet.shaded.guava.collect.ImmutableListMultimap}
 * <li>{@link org.apache.comet.shaded.guava.collect.ImmutableSetMultimap}
 * <li>{@link org.apache.comet.shaded.guava.collect.ArrayListMultimap}
 * <li>{@link org.apache.comet.shaded.guava.collect.HashMultimap}
 * <li>{@link org.apache.comet.shaded.guava.collect.TreeMultimap}
 * <li>{@link org.apache.comet.shaded.guava.collect.LinkedHashMultimap}
 * <li>{@link org.apache.comet.shaded.guava.collect.LinkedListMultimap}
 * </ul>
 *
 * <h3>of {@link org.apache.comet.shaded.guava.collect.Table}</h3>
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.ImmutableTable}
 * <li>{@link org.apache.comet.shaded.guava.collect.ArrayTable}
 * <li>{@link org.apache.comet.shaded.guava.collect.HashBasedTable}
 * <li>{@link org.apache.comet.shaded.guava.collect.TreeBasedTable}
 * </ul>
 *
 * <h3>of {@link org.apache.comet.shaded.guava.collect.ClassToInstanceMap}</h3>
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.ImmutableClassToInstanceMap}
 * <li>{@link org.apache.comet.shaded.guava.collect.MutableClassToInstanceMap}
 * </ul>
 *
 * <h2>Classes of static utility methods</h2>
 *
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.Collections2}
 * <li>{@link org.apache.comet.shaded.guava.collect.Iterators}
 * <li>{@link org.apache.comet.shaded.guava.collect.Iterables}
 * <li>{@link org.apache.comet.shaded.guava.collect.Lists}
 * <li>{@link org.apache.comet.shaded.guava.collect.Maps}
 * <li>{@link org.apache.comet.shaded.guava.collect.Queues}
 * <li>{@link org.apache.comet.shaded.guava.collect.Sets}
 * <li>{@link org.apache.comet.shaded.guava.collect.Multisets}
 * <li>{@link org.apache.comet.shaded.guava.collect.Multimaps}
 * <li>{@link org.apache.comet.shaded.guava.collect.Tables}
 * <li>{@link org.apache.comet.shaded.guava.collect.ObjectArrays}
 * </ul>
 *
 * <h2>Comparison</h2>
 *
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.Ordering}
 * <li>{@link org.apache.comet.shaded.guava.collect.ComparisonChain}
 * </ul>
 *
 * <h2>Abstract implementations</h2>
 *
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.AbstractIterator}
 * <li>{@link org.apache.comet.shaded.guava.collect.AbstractSequentialIterator}
 * <li>{@link org.apache.comet.shaded.guava.collect.ImmutableCollection}
 * <li>{@link org.apache.comet.shaded.guava.collect.UnmodifiableIterator}
 * <li>{@link org.apache.comet.shaded.guava.collect.UnmodifiableListIterator}
 * </ul>
 *
 * <h2>Ranges</h2>
 *
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.Range}
 * <li>{@link org.apache.comet.shaded.guava.collect.DiscreteDomain}
 * <li>{@link org.apache.comet.shaded.guava.collect.DiscreteDomains}
 * <li>{@link org.apache.comet.shaded.guava.collect.ContiguousSet}
 * </ul>
 *
 * <h2>Other</h2>
 *
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.Interner},
 *     {@link org.apache.comet.shaded.guava.collect.Interners}
 * <li>{@link org.apache.comet.shaded.guava.collect.Constraint},
 *     {@link org.apache.comet.shaded.guava.collect.Constraints}
 * <li>{@link org.apache.comet.shaded.guava.collect.MapConstraint},
 *     {@link org.apache.comet.shaded.guava.collect.MapConstraints}
 * <li>{@link org.apache.comet.shaded.guava.collect.MapDifference},
 *     {@link org.apache.comet.shaded.guava.collect.SortedMapDifference}
 * <li>{@link org.apache.comet.shaded.guava.collect.MinMaxPriorityQueue}
 * <li>{@link org.apache.comet.shaded.guava.collect.PeekingIterator}
 * </ul>
 *
 * <h2>Forwarding collections</h2>
 *
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingCollection}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingConcurrentMap}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingIterator}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingList}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingListIterator}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingListMultimap}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingMap}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingMapEntry}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingMultimap}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingMultiset}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingNavigableMap}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingNavigableSet}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingObject}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingQueue}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingSet}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingSetMultimap}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingSortedMap}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingSortedSet}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingSortedSetMultimap}
 * <li>{@link org.apache.comet.shaded.guava.collect.ForwardingTable}
 * </ul>
 */
@javax.annotation.ParametersAreNonnullByDefault
package org.apache.comet.shaded.guava.collect;
