/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.vector;

import org.apache.comet.shaded.arrow.vector.ValueVector;
import org.apache.comet.shaded.arrow.vector.complex.ListVector;
import org.apache.comet.shaded.arrow.vector.dictionary.DictionaryProvider;
import org.apache.comet.shaded.arrow.vector.util.TransferPair;
import org.apache.comet.vector.CometDecodedVector;
import org.apache.comet.vector.CometVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;

public class CometListVector
extends CometDecodedVector {
    final ListVector listVector;
    final ValueVector dataVector;
    final ColumnVector dataColumnVector;
    final DictionaryProvider dictionaryProvider;

    public CometListVector(ValueVector vector, boolean useDecimal128, DictionaryProvider dictionaryProvider) {
        super(vector, vector.getField(), useDecimal128);
        this.listVector = (ListVector)vector;
        this.dataVector = this.listVector.getDataVector();
        this.dictionaryProvider = dictionaryProvider;
        this.dataColumnVector = CometListVector.getVector(this.dataVector, useDecimal128, dictionaryProvider);
    }

    @Override
    public ColumnarArray getArray(int i) {
        int start = this.listVector.getOffsetBuffer().getInt(i * 4);
        int end = this.listVector.getOffsetBuffer().getInt((i + 1) * 4);
        return new ColumnarArray(this.dataColumnVector, start, end - start);
    }

    @Override
    public CometVector slice(int offset, int length) {
        TransferPair tp = this.valueVector.getTransferPair(this.valueVector.getAllocator());
        tp.splitAndTransfer(offset, length);
        return new CometListVector(tp.getTo(), this.useDecimal128, this.dictionaryProvider);
    }
}

