/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.vector.ipc;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.comet.shaded.arrow.memory.ArrowBuf;
import org.apache.comet.shaded.arrow.util.Preconditions;
import org.apache.comet.shaded.arrow.vector.BaseVariableWidthVector;
import org.apache.comet.shaded.arrow.vector.BigIntVector;
import org.apache.comet.shaded.arrow.vector.BitVectorHelper;
import org.apache.comet.shaded.arrow.vector.BufferLayout;
import org.apache.comet.shaded.arrow.vector.DateDayVector;
import org.apache.comet.shaded.arrow.vector.DateMilliVector;
import org.apache.comet.shaded.arrow.vector.Decimal256Vector;
import org.apache.comet.shaded.arrow.vector.DecimalVector;
import org.apache.comet.shaded.arrow.vector.DurationVector;
import org.apache.comet.shaded.arrow.vector.FieldVector;
import org.apache.comet.shaded.arrow.vector.FixedSizeBinaryVector;
import org.apache.comet.shaded.arrow.vector.Float4Vector;
import org.apache.comet.shaded.arrow.vector.Float8Vector;
import org.apache.comet.shaded.arrow.vector.IntVector;
import org.apache.comet.shaded.arrow.vector.IntervalDayVector;
import org.apache.comet.shaded.arrow.vector.IntervalMonthDayNanoVector;
import org.apache.comet.shaded.arrow.vector.IntervalYearVector;
import org.apache.comet.shaded.arrow.vector.SmallIntVector;
import org.apache.comet.shaded.arrow.vector.TimeMicroVector;
import org.apache.comet.shaded.arrow.vector.TimeMilliVector;
import org.apache.comet.shaded.arrow.vector.TimeNanoVector;
import org.apache.comet.shaded.arrow.vector.TimeSecVector;
import org.apache.comet.shaded.arrow.vector.TimeStampMicroTZVector;
import org.apache.comet.shaded.arrow.vector.TimeStampMicroVector;
import org.apache.comet.shaded.arrow.vector.TimeStampMilliTZVector;
import org.apache.comet.shaded.arrow.vector.TimeStampMilliVector;
import org.apache.comet.shaded.arrow.vector.TimeStampNanoTZVector;
import org.apache.comet.shaded.arrow.vector.TimeStampNanoVector;
import org.apache.comet.shaded.arrow.vector.TimeStampSecTZVector;
import org.apache.comet.shaded.arrow.vector.TimeStampSecVector;
import org.apache.comet.shaded.arrow.vector.TinyIntVector;
import org.apache.comet.shaded.arrow.vector.TypeLayout;
import org.apache.comet.shaded.arrow.vector.UInt1Vector;
import org.apache.comet.shaded.arrow.vector.UInt2Vector;
import org.apache.comet.shaded.arrow.vector.UInt4Vector;
import org.apache.comet.shaded.arrow.vector.UInt8Vector;
import org.apache.comet.shaded.arrow.vector.VectorSchemaRoot;
import org.apache.comet.shaded.arrow.vector.dictionary.Dictionary;
import org.apache.comet.shaded.arrow.vector.dictionary.DictionaryProvider;
import org.apache.comet.shaded.arrow.vector.types.Types;
import org.apache.comet.shaded.arrow.vector.types.pojo.Field;
import org.apache.comet.shaded.arrow.vector.types.pojo.Schema;
import org.apache.comet.shaded.arrow.vector.util.DecimalUtility;
import org.apache.comet.shaded.arrow.vector.util.DictionaryUtility;
import org.apache.commons.codec.binary.Hex;

public class JsonFileWriter
implements AutoCloseable {
    private final JsonGenerator generator;
    private Schema schema;

    public static JSONWriteConfig config() {
        return new JSONWriteConfig();
    }

    public JsonFileWriter(File outputFile) throws IOException {
        this(outputFile, JsonFileWriter.config());
    }

    public JsonFileWriter(File outputFile, JSONWriteConfig config) throws IOException {
        MappingJsonFactory jsonFactory = new MappingJsonFactory();
        this.generator = jsonFactory.createGenerator(outputFile, JsonEncoding.UTF8);
        if (config.pretty) {
            DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
            prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultPrettyPrinter.NopIndenter.instance);
            this.generator.setPrettyPrinter((PrettyPrinter)prettyPrinter);
        }
        this.generator.configure(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS, false);
    }

    public void start(Schema schema, DictionaryProvider provider) throws IOException {
        ArrayList<Field> fields = new ArrayList<Field>(schema.getFields().size());
        HashSet<Long> dictionaryIdsUsed = new HashSet<Long>();
        this.schema = schema;
        for (Field field : schema.getFields()) {
            fields.add(DictionaryUtility.toMessageFormat(field, provider, dictionaryIdsUsed));
        }
        Schema updatedSchema = new Schema(fields, schema.getCustomMetadata());
        this.generator.writeStartObject();
        this.generator.writeObjectField("schema", (Object)updatedSchema);
        if (!dictionaryIdsUsed.isEmpty()) {
            this.writeDictionaryBatches(this.generator, dictionaryIdsUsed, provider);
        }
        this.generator.writeArrayFieldStart("batches");
    }

    private void writeDictionaryBatches(JsonGenerator generator, Set<Long> dictionaryIdsUsed, DictionaryProvider provider) throws IOException {
        generator.writeArrayFieldStart("dictionaries");
        for (Long id : dictionaryIdsUsed) {
            generator.writeStartObject();
            generator.writeObjectField("id", (Object)id);
            generator.writeFieldName("data");
            Dictionary dictionary = provider.lookup(id);
            FieldVector vector = dictionary.getVector();
            List<Field> fields = Collections.singletonList(vector.getField());
            List<FieldVector> vectors = Collections.singletonList(vector);
            VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, vector.getValueCount());
            this.writeBatch(root);
            generator.writeEndObject();
        }
        generator.writeEndArray();
    }

    public void write(VectorSchemaRoot recordBatch) throws IOException {
        if (!recordBatch.getSchema().equals(this.schema)) {
            throw new IllegalArgumentException("record batches must have the same schema: " + this.schema);
        }
        this.writeBatch(recordBatch);
    }

    private void writeBatch(VectorSchemaRoot recordBatch) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeObjectField("count", (Object)recordBatch.getRowCount());
        this.generator.writeArrayFieldStart("columns");
        for (Field field : recordBatch.getSchema().getFields()) {
            FieldVector vector = recordBatch.getVector(field);
            this.writeFromVectorIntoJson(field, vector);
        }
        this.generator.writeEndArray();
        this.generator.writeEndObject();
    }

    private void writeFromVectorIntoJson(Field field, FieldVector vector) throws IOException {
        List<BufferLayout.BufferType> vectorTypes = TypeLayout.getTypeLayout(field.getType()).getBufferTypes();
        List<ArrowBuf> vectorBuffers = vector.getFieldBuffers();
        if (vectorTypes.size() != vectorBuffers.size()) {
            throw new IllegalArgumentException("vector types and inner vector buffers are not the same size: " + vectorTypes.size() + " != " + vectorBuffers.size());
        }
        this.generator.writeStartObject();
        this.generator.writeObjectField("name", (Object)field.getName());
        int valueCount = vector.getValueCount();
        this.generator.writeObjectField("count", (Object)valueCount);
        for (int v = 0; v < vectorTypes.size(); ++v) {
            BufferLayout.BufferType bufferType = vectorTypes.get(v);
            ArrowBuf vectorBuffer = vectorBuffers.get(v);
            this.generator.writeArrayFieldStart(bufferType.getName());
            int bufferValueCount = bufferType.equals((Object)BufferLayout.BufferType.OFFSET) && vector.getMinorType() != Types.MinorType.DENSEUNION ? valueCount + 1 : valueCount;
            for (int i = 0; i < bufferValueCount; ++i) {
                Throwable throwable;
                ArrowBuf vectorBufferTmp;
                if (bufferType.equals((Object)BufferLayout.BufferType.DATA) && (vector.getMinorType() == Types.MinorType.VARCHAR || vector.getMinorType() == Types.MinorType.VARBINARY)) {
                    this.writeValueToGenerator(bufferType, vectorBuffer, vectorBuffers.get(v - 1), vector, i);
                    continue;
                }
                if (bufferType.equals((Object)BufferLayout.BufferType.OFFSET) && vector.getValueCount() == 0 && (vector.getMinorType() == Types.MinorType.LIST || vector.getMinorType() == Types.MinorType.MAP || vector.getMinorType() == Types.MinorType.VARBINARY || vector.getMinorType() == Types.MinorType.VARCHAR)) {
                    vectorBufferTmp = vector.getAllocator().buffer(4L);
                    throwable = null;
                    try {
                        vectorBufferTmp.setInt(0L, 0);
                        this.writeValueToGenerator(bufferType, vectorBufferTmp, null, vector, i);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (vectorBufferTmp != null) {
                            JsonFileWriter.$closeResource(throwable, vectorBufferTmp);
                        }
                    }
                }
                if (bufferType.equals((Object)BufferLayout.BufferType.OFFSET) && vector.getValueCount() == 0 && (vector.getMinorType() == Types.MinorType.LARGELIST || vector.getMinorType() == Types.MinorType.LARGEVARBINARY || vector.getMinorType() == Types.MinorType.LARGEVARCHAR)) {
                    vectorBufferTmp = vector.getAllocator().buffer(8L);
                    throwable = null;
                    try {
                        vectorBufferTmp.setLong(0L, 0L);
                        this.writeValueToGenerator(bufferType, vectorBufferTmp, null, vector, i);
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (vectorBufferTmp != null) {
                            JsonFileWriter.$closeResource(throwable, vectorBufferTmp);
                        }
                    }
                }
                this.writeValueToGenerator(bufferType, vectorBuffer, null, vector, i);
            }
            this.generator.writeEndArray();
        }
        List<Field> fields = field.getChildren();
        List<FieldVector> children = vector.getChildrenFromFields();
        if (fields.size() != children.size()) {
            throw new IllegalArgumentException("fields and children are not the same size: " + fields.size() + " != " + children.size());
        }
        if (fields.size() > 0) {
            this.generator.writeArrayFieldStart("children");
            for (int i = 0; i < fields.size(); ++i) {
                Field childField = fields.get(i);
                FieldVector childVector = children.get(i);
                this.writeFromVectorIntoJson(childField, childVector);
            }
            this.generator.writeEndArray();
        }
        this.generator.writeEndObject();
    }

    private void writeValueToGenerator(BufferLayout.BufferType bufferType, ArrowBuf buffer, ArrowBuf offsetBuffer, FieldVector vector, int index) throws IOException {
        block44: {
            block45: {
                block43: {
                    if (!bufferType.equals((Object)BufferLayout.BufferType.TYPE)) break block43;
                    this.generator.writeNumber((short)buffer.getByte(index * 1));
                    break block44;
                }
                if (!bufferType.equals((Object)BufferLayout.BufferType.OFFSET)) break block45;
                switch (vector.getMinorType()) {
                    case VARCHAR: 
                    case VARBINARY: 
                    case LIST: 
                    case MAP: {
                        this.generator.writeNumber(buffer.getInt((long)index * 4L));
                        break block44;
                    }
                    case LARGELIST: 
                    case LARGEVARBINARY: 
                    case LARGEVARCHAR: {
                        this.generator.writeNumber(buffer.getLong((long)index * 8L));
                        break block44;
                    }
                    default: {
                        throw new IllegalArgumentException("Type has no offset buffer: " + vector.getField());
                    }
                }
            }
            if (bufferType.equals((Object)BufferLayout.BufferType.VALIDITY)) {
                this.generator.writeNumber(vector.isNull(index) ? 0 : 1);
            } else if (bufferType.equals((Object)BufferLayout.BufferType.DATA)) {
                switch (vector.getMinorType()) {
                    case TINYINT: {
                        this.generator.writeNumber((short)TinyIntVector.get(buffer, index));
                        break;
                    }
                    case SMALLINT: {
                        this.generator.writeNumber(SmallIntVector.get(buffer, index));
                        break;
                    }
                    case INT: {
                        this.generator.writeNumber(IntVector.get(buffer, index));
                        break;
                    }
                    case BIGINT: {
                        this.generator.writeString(String.valueOf(BigIntVector.get(buffer, index)));
                        break;
                    }
                    case UINT1: {
                        this.generator.writeNumber(UInt1Vector.getNoOverflow(buffer, index));
                        break;
                    }
                    case UINT2: {
                        this.generator.writeNumber((int)UInt2Vector.get(buffer, index));
                        break;
                    }
                    case UINT4: {
                        this.generator.writeNumber(UInt4Vector.getNoOverflow(buffer, index));
                        break;
                    }
                    case UINT8: {
                        this.generator.writeString(UInt8Vector.getNoOverflow(buffer, index).toString());
                        break;
                    }
                    case FLOAT4: {
                        this.generator.writeNumber(Float4Vector.get(buffer, index));
                        break;
                    }
                    case FLOAT8: {
                        this.generator.writeNumber(Float8Vector.get(buffer, index));
                        break;
                    }
                    case DATEDAY: {
                        this.generator.writeNumber(DateDayVector.get(buffer, index));
                        break;
                    }
                    case DATEMILLI: {
                        this.generator.writeNumber(DateMilliVector.get(buffer, index));
                        break;
                    }
                    case TIMESEC: {
                        this.generator.writeNumber(TimeSecVector.get(buffer, index));
                        break;
                    }
                    case TIMEMILLI: {
                        this.generator.writeNumber(TimeMilliVector.get(buffer, index));
                        break;
                    }
                    case TIMEMICRO: {
                        this.generator.writeNumber(TimeMicroVector.get(buffer, index));
                        break;
                    }
                    case TIMENANO: {
                        this.generator.writeNumber(TimeNanoVector.get(buffer, index));
                        break;
                    }
                    case TIMESTAMPSEC: {
                        this.generator.writeNumber(TimeStampSecVector.get(buffer, index));
                        break;
                    }
                    case TIMESTAMPMILLI: {
                        this.generator.writeNumber(TimeStampMilliVector.get(buffer, index));
                        break;
                    }
                    case TIMESTAMPMICRO: {
                        this.generator.writeNumber(TimeStampMicroVector.get(buffer, index));
                        break;
                    }
                    case TIMESTAMPNANO: {
                        this.generator.writeNumber(TimeStampNanoVector.get(buffer, index));
                        break;
                    }
                    case TIMESTAMPSECTZ: {
                        this.generator.writeNumber(TimeStampSecTZVector.get(buffer, index));
                        break;
                    }
                    case TIMESTAMPMILLITZ: {
                        this.generator.writeNumber(TimeStampMilliTZVector.get(buffer, index));
                        break;
                    }
                    case TIMESTAMPMICROTZ: {
                        this.generator.writeNumber(TimeStampMicroTZVector.get(buffer, index));
                        break;
                    }
                    case TIMESTAMPNANOTZ: {
                        this.generator.writeNumber(TimeStampNanoTZVector.get(buffer, index));
                        break;
                    }
                    case DURATION: {
                        this.generator.writeNumber(DurationVector.get(buffer, index));
                        break;
                    }
                    case INTERVALYEAR: {
                        this.generator.writeNumber(IntervalYearVector.getTotalMonths(buffer, index));
                        break;
                    }
                    case INTERVALDAY: {
                        this.generator.writeStartObject();
                        this.generator.writeObjectField("days", (Object)IntervalDayVector.getDays(buffer, index));
                        this.generator.writeObjectField("milliseconds", (Object)IntervalDayVector.getMilliseconds(buffer, index));
                        this.generator.writeEndObject();
                        break;
                    }
                    case INTERVALMONTHDAYNANO: {
                        this.generator.writeStartObject();
                        this.generator.writeObjectField("months", (Object)IntervalMonthDayNanoVector.getMonths(buffer, index));
                        this.generator.writeObjectField("days", (Object)IntervalMonthDayNanoVector.getDays(buffer, index));
                        this.generator.writeObjectField("nanoseconds", (Object)IntervalMonthDayNanoVector.getNanoseconds(buffer, index));
                        this.generator.writeEndObject();
                        break;
                    }
                    case BIT: {
                        this.generator.writeNumber(BitVectorHelper.get(buffer, index));
                        break;
                    }
                    case VARBINARY: {
                        Preconditions.checkNotNull(offsetBuffer);
                        String hexString = Hex.encodeHexString((byte[])BaseVariableWidthVector.get(buffer, offsetBuffer, index));
                        this.generator.writeObject((Object)hexString);
                        break;
                    }
                    case FIXEDSIZEBINARY: {
                        int byteWidth = ((FixedSizeBinaryVector)vector).getByteWidth();
                        String fixedSizeHexString = Hex.encodeHexString((byte[])FixedSizeBinaryVector.get(buffer, index, byteWidth));
                        this.generator.writeObject((Object)fixedSizeHexString);
                        break;
                    }
                    case VARCHAR: {
                        Preconditions.checkNotNull(offsetBuffer);
                        byte[] b = BaseVariableWidthVector.get(buffer, offsetBuffer, index);
                        this.generator.writeString(new String(b, "UTF-8"));
                        break;
                    }
                    case DECIMAL: {
                        int scale = ((DecimalVector)vector).getScale();
                        BigDecimal decimalValue = DecimalUtility.getBigDecimalFromArrowBuf(buffer, index, scale, 16);
                        this.generator.writeString(decimalValue.unscaledValue().toString());
                        break;
                    }
                    case DECIMAL256: {
                        int scale = ((Decimal256Vector)vector).getScale();
                        BigDecimal decimalValue = DecimalUtility.getBigDecimalFromArrowBuf(buffer, index, scale, 32);
                        this.generator.writeString(decimalValue.unscaledValue().toString());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("minor type: " + (Object)((Object)vector.getMinorType()));
                    }
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.generator.writeEndArray();
        this.generator.writeEndObject();
        this.generator.close();
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public static final class JSONWriteConfig {
        private final boolean pretty;

        private JSONWriteConfig(boolean pretty) {
            this.pretty = pretty;
        }

        private JSONWriteConfig() {
            this.pretty = false;
        }

        public JSONWriteConfig pretty(boolean pretty) {
            return new JSONWriteConfig(pretty);
        }
    }
}

