/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.vector;

import java.time.Period;
import org.apache.comet.shaded.arrow.memory.ArrowBuf;
import org.apache.comet.shaded.arrow.memory.BufferAllocator;
import org.apache.comet.shaded.arrow.vector.BaseFixedWidthVector;
import org.apache.comet.shaded.arrow.vector.BitVectorHelper;
import org.apache.comet.shaded.arrow.vector.NullCheckingForGet;
import org.apache.comet.shaded.arrow.vector.ValueVector;
import org.apache.comet.shaded.arrow.vector.complex.impl.IntervalYearReaderImpl;
import org.apache.comet.shaded.arrow.vector.complex.reader.FieldReader;
import org.apache.comet.shaded.arrow.vector.holders.IntervalYearHolder;
import org.apache.comet.shaded.arrow.vector.holders.NullableIntervalYearHolder;
import org.apache.comet.shaded.arrow.vector.types.Types;
import org.apache.comet.shaded.arrow.vector.types.pojo.Field;
import org.apache.comet.shaded.arrow.vector.types.pojo.FieldType;
import org.apache.comet.shaded.arrow.vector.util.TransferPair;

public final class IntervalYearVector
extends BaseFixedWidthVector {
    public static final byte TYPE_WIDTH = 4;

    public IntervalYearVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.INTERVALYEAR.getType()), allocator);
    }

    public IntervalYearVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public IntervalYearVector(Field field, BufferAllocator allocator) {
        super(field, allocator, 4);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new IntervalYearReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.INTERVALYEAR;
    }

    public static int getTotalMonths(ArrowBuf buffer, int index) {
        return buffer.getInt((long)index * 4L);
    }

    public int get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getInt((long)index * 4L);
    }

    public void get(int index, NullableIntervalYearHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getInt((long)index * 4L);
    }

    @Override
    public Period getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        int interval = this.valueBuffer.getInt((long)index * 4L);
        return Period.ofMonths(interval);
    }

    public StringBuilder getAsStringBuilder(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.getAsStringBuilderHelper(index);
    }

    private StringBuilder getAsStringBuilderHelper(int index) {
        int value = this.valueBuffer.getInt((long)index * 4L);
        int years = value / 12;
        int months = value % 12;
        String yearString = Math.abs(years) == 1 ? " year " : " years ";
        String monthString = Math.abs(months) == 1 ? " month " : " months ";
        return new StringBuilder().append(years).append(yearString).append(months).append(monthString);
    }

    private void setValue(int index, int value) {
        this.valueBuffer.setInt((long)index * 4L, value);
    }

    public void set(int index, int value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableIntervalYearHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, IntervalYearHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, int value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableIntervalYearHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, IntervalYearHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, int isSet, int value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, int value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((IntervalYearVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        IntervalYearVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new IntervalYearVector(ref, IntervalYearVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new IntervalYearVector(field, allocator);
        }

        public TransferImpl(IntervalYearVector to) {
            this.to = to;
        }

        @Override
        public IntervalYearVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            IntervalYearVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            IntervalYearVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, IntervalYearVector.this);
        }
    }
}

