/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.comet.CometConf;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.package$;
import org.apache.spark.sql.execution.datasources.SchemaColumnConvertNotSupportedException;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.YearMonthIntervalType;

public class TypeUtil {
    public static ColumnDescriptor convertToParquet(StructField field) {
        int maxDefinitionLevel;
        Type.Repetition repetition;
        if (field.nullable()) {
            repetition = Type.Repetition.OPTIONAL;
            maxDefinitionLevel = 1;
        } else {
            repetition = Type.Repetition.REQUIRED;
            maxDefinitionLevel = 0;
        }
        String[] path = new String[]{field.name()};
        DataType type = field.dataType();
        Types.PrimitiveBuilder builder = null;
        if (type == DataTypes.BooleanType || type == DataTypes.NullType) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition);
        } else if (type == DataTypes.IntegerType || type instanceof YearMonthIntervalType) {
            builder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)32, (boolean)true));
        } else if (type == DataTypes.DateType) {
            builder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType());
        } else if (type == DataTypes.ByteType) {
            builder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true));
        } else if (type == DataTypes.ShortType) {
            builder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true));
        } else if (type == DataTypes.LongType) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition);
        } else if (type == DataTypes.BinaryType) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition);
        } else if (type == DataTypes.StringType) {
            builder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
        } else if (type == DataTypes.FloatType) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition);
        } else if (type == DataTypes.DoubleType) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition);
        } else if (type == DataTypes.TimestampType) {
            builder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
        } else if (type == TimestampNTZType$.MODULE$) {
            builder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
        } else if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            builder = (Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).length(16)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)decimalType.scale(), (int)decimalType.precision()));
        }
        if (builder == null) {
            throw new UnsupportedOperationException("Unsupported input Spark type: " + type);
        }
        return new ColumnDescriptor(path, (PrimitiveType)builder.named(field.name()), 0, maxDefinitionLevel);
    }

    public static void checkParquetType(ColumnDescriptor descriptor, DataType sparkType) {
        PrimitiveType.PrimitiveTypeName typeName = descriptor.getPrimitiveType().getPrimitiveTypeName();
        LogicalTypeAnnotation logicalTypeAnnotation = descriptor.getPrimitiveType().getLogicalTypeAnnotation();
        boolean allowTypePromotion = (Boolean)CometConf.COMET_SCHEMA_EVOLUTION_ENABLED().get();
        if (sparkType instanceof NullType) {
            return;
        }
        switch (typeName) {
            case BOOLEAN: {
                if (sparkType != DataTypes.BooleanType) break;
                return;
            }
            case INT32: {
                if (sparkType == DataTypes.IntegerType || TypeUtil.canReadAsIntDecimal(descriptor, sparkType)) {
                    return;
                }
                if (sparkType == DataTypes.LongType && TypeUtil.isUnsignedIntTypeMatched(logicalTypeAnnotation, 32)) {
                    return;
                }
                if (sparkType == DataTypes.LongType && allowTypePromotion) {
                    return;
                }
                if (sparkType == DataTypes.ByteType || sparkType == DataTypes.ShortType) {
                    return;
                }
                if (sparkType == DataTypes.DateType) {
                    return;
                }
                if (sparkType instanceof YearMonthIntervalType) {
                    return;
                }
                if (sparkType == DataTypes.DoubleType && TypeUtil.isSpark40Plus()) {
                    return;
                }
                if (sparkType != TimestampNTZType$.MODULE$ || !TypeUtil.isSpark40Plus() || !(logicalTypeAnnotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation)) break;
                return;
            }
            case INT64: {
                if (sparkType == DataTypes.LongType || TypeUtil.canReadAsLongDecimal(descriptor, sparkType)) {
                    return;
                }
                if (TypeUtil.isLongDecimal(sparkType) && TypeUtil.isUnsignedIntTypeMatched(logicalTypeAnnotation, 64)) {
                    return;
                }
                if (TypeUtil.isTimestampTypeMatched(logicalTypeAnnotation, LogicalTypeAnnotation.TimeUnit.MICROS) && (sparkType == TimestampNTZType$.MODULE$ || sparkType == DataTypes.TimestampType)) {
                    TypeUtil.validateTimestampType(logicalTypeAnnotation, sparkType);
                    return;
                }
                if (!TypeUtil.isTimestampTypeMatched(logicalTypeAnnotation, LogicalTypeAnnotation.TimeUnit.MILLIS) || sparkType != TimestampNTZType$.MODULE$ && sparkType != DataTypes.TimestampType) break;
                TypeUtil.validateTimestampType(logicalTypeAnnotation, sparkType);
                return;
            }
            case INT96: {
                if (sparkType == TimestampNTZType$.MODULE$) {
                    if (TypeUtil.isSpark40Plus()) {
                        return;
                    }
                    TypeUtil.convertErrorForTimestampNTZ(typeName.name());
                    break;
                }
                if (sparkType != DataTypes.TimestampType) break;
                return;
            }
            case FLOAT: {
                if (sparkType == DataTypes.FloatType) {
                    return;
                }
                if (sparkType != DataTypes.DoubleType || !allowTypePromotion) break;
                return;
            }
            case DOUBLE: {
                if (sparkType != DataTypes.DoubleType) break;
                return;
            }
            case BINARY: {
                if (sparkType != DataTypes.StringType && sparkType != DataTypes.BinaryType && !TypeUtil.canReadAsBinaryDecimal(descriptor, sparkType)) break;
                return;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                if (!TypeUtil.canReadAsIntDecimal(descriptor, sparkType) && !TypeUtil.canReadAsLongDecimal(descriptor, sparkType) && !TypeUtil.canReadAsBinaryDecimal(descriptor, sparkType) && sparkType != DataTypes.BinaryType && (sparkType != DataTypes.StringType || !(logicalTypeAnnotation instanceof LogicalTypeAnnotation.UUIDLogicalTypeAnnotation))) break;
                return;
            }
        }
        throw new SchemaColumnConvertNotSupportedException(Arrays.toString(descriptor.getPath()), descriptor.getPrimitiveType().getPrimitiveTypeName().toString(), sparkType.catalogString());
    }

    private static void validateTimestampType(LogicalTypeAnnotation logicalTypeAnnotation, DataType sparkType) {
        assert (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation);
        if (((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation).isAdjustedToUTC() && sparkType == TimestampNTZType$.MODULE$ && !TypeUtil.isSpark40Plus()) {
            TypeUtil.convertErrorForTimestampNTZ("int64 time(" + logicalTypeAnnotation + ")");
        }
    }

    private static void convertErrorForTimestampNTZ(String parquetType) {
        throw new RuntimeException("Unable to create Parquet converter for data type " + TimestampNTZType$.MODULE$.json() + " whose Parquet type is " + parquetType);
    }

    private static boolean canReadAsIntDecimal(ColumnDescriptor descriptor, DataType dt) {
        if (!(DecimalType.is32BitDecimalType((DataType)dt) || TypeUtil.isSpark40Plus() && dt instanceof DecimalType)) {
            return false;
        }
        return TypeUtil.isDecimalTypeMatched(descriptor, dt);
    }

    private static boolean canReadAsLongDecimal(ColumnDescriptor descriptor, DataType dt) {
        if (!(DecimalType.is64BitDecimalType((DataType)dt) || TypeUtil.isSpark40Plus() && dt instanceof DecimalType)) {
            return false;
        }
        return TypeUtil.isDecimalTypeMatched(descriptor, dt);
    }

    private static boolean canReadAsBinaryDecimal(ColumnDescriptor descriptor, DataType dt) {
        if (!DecimalType.isByteArrayDecimalType((DataType)dt)) {
            return false;
        }
        return TypeUtil.isDecimalTypeMatched(descriptor, dt);
    }

    private static boolean isLongDecimal(DataType dt) {
        if (dt instanceof DecimalType) {
            DecimalType d = (DecimalType)dt;
            return d.precision() == 20 && d.scale() == 0;
        }
        return false;
    }

    private static boolean isDecimalTypeMatched(ColumnDescriptor descriptor, DataType dt) {
        DecimalType d = (DecimalType)dt;
        LogicalTypeAnnotation typeAnnotation = descriptor.getPrimitiveType().getLogicalTypeAnnotation();
        if (typeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation;
            return decimalType.getPrecision() <= d.precision() && decimalType.getScale() == d.scale() || TypeUtil.isSpark40Plus() && (!SQLConf.get().parquetVectorizedReaderEnabled() || decimalType.getScale() <= d.scale() && decimalType.getPrecision() - decimalType.getScale() <= d.precision() - d.scale());
        }
        if (TypeUtil.isSpark40Plus()) {
            boolean isNullTypeAnnotation = typeAnnotation == null;
            boolean isIntTypeAnnotation = typeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation;
            if (!SQLConf.get().parquetVectorizedReaderEnabled()) {
                return isNullTypeAnnotation || isIntTypeAnnotation;
            }
            if (isNullTypeAnnotation || isIntTypeAnnotation && ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)typeAnnotation).isSigned()) {
                PrimitiveType.PrimitiveTypeName typeName = descriptor.getPrimitiveType().getPrimitiveTypeName();
                int integerPrecision = d.precision() - d.scale();
                switch (typeName) {
                    case INT32: {
                        return integerPrecision >= DecimalType$.MODULE$.IntDecimal().precision();
                    }
                    case INT64: {
                        return integerPrecision >= DecimalType$.MODULE$.LongDecimal().precision();
                    }
                }
            }
        }
        return false;
    }

    private static boolean isTimestampTypeMatched(LogicalTypeAnnotation logicalTypeAnnotation, LogicalTypeAnnotation.TimeUnit unit) {
        return logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation && ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation).getUnit() == unit;
    }

    private static boolean isUnsignedIntTypeMatched(LogicalTypeAnnotation logicalTypeAnnotation, int bitWidth) {
        return logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation && !((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation).isSigned() && ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation).getBitWidth() == bitWidth;
    }

    private static boolean isSpark40Plus() {
        return package$.MODULE$.SPARK_VERSION().compareTo("4.0") >= 0;
    }

    public static boolean isComplexType(Type t) {
        return !t.isPrimitive() || t.isRepetition(Type.Repetition.REPEATED);
    }

    public static boolean eqOrBothNull(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public static boolean equals(Type one, Type other) {
        return one.getName().equals(other.getName()) && one.getRepetition() == other.getRepetition() && TypeUtil.eqOrBothNull(one.getRepetition(), other.getRepetition()) && TypeUtil.eqOrBothNull(one.getId(), other.getId()) && TypeUtil.eqOrBothNull(one.getLogicalTypeAnnotation(), other.getLogicalTypeAnnotation());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEqual(Type requested, Type actual) {
        if (requested == null && actual == null) {
            return true;
        }
        if (requested == null || actual == null) {
            return false;
        }
        if (requested.isPrimitive() && actual.isPrimitive()) {
            return requested.asPrimitiveType().equals((Object)actual.asPrimitiveType());
        }
        if (requested.isPrimitive() || actual.isPrimitive()) return false;
        if (!TypeUtil.equals(requested, actual)) return false;
        List requestedFields = requested.asGroupType().getFields();
        List actualFields = requested.asGroupType().getFields();
        for (Type field : requestedFields) {
            Optional<Type> optActualField = actualFields.stream().filter(f -> f.getName().equals(field.getName())).findFirst();
            if (!optActualField.isPresent() || TypeUtil.isEqual(field, optActualField.get())) continue;
            return false;
        }
        return true;
    }
}

