/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import org.apache.comet.parquet.AbstractColumnReader;
import org.apache.comet.parquet.Native;
import org.apache.comet.shaded.arrow.c.ArrowArray;
import org.apache.comet.shaded.arrow.c.ArrowSchema;
import org.apache.comet.shaded.arrow.c.Data;
import org.apache.comet.shaded.arrow.memory.BufferAllocator;
import org.apache.comet.shaded.arrow.memory.RootAllocator;
import org.apache.comet.shaded.arrow.vector.FieldVector;
import org.apache.comet.shaded.arrow.vector.ValueVector;
import org.apache.comet.vector.CometPlainVector;
import org.apache.comet.vector.CometVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.spark.sql.types.DataType;

public class MetadataColumnReader
extends AbstractColumnReader {
    private final BufferAllocator allocator = new RootAllocator();
    private CometVector vector;
    private ArrowArray array = null;
    private ArrowSchema schema = null;
    private boolean isConstant;

    public MetadataColumnReader(DataType type, ColumnDescriptor descriptor, boolean useDecimal128, boolean isConstant) {
        super(type, descriptor, useDecimal128, false);
        this.isConstant = isConstant;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.close();
        super.setBatchSize(batchSize);
    }

    @Override
    public void readBatch(int total) {
        if (this.vector == null) {
            this.array = ArrowArray.allocateNew(this.allocator);
            this.schema = ArrowSchema.allocateNew(this.allocator);
            long arrayAddr = this.array.memoryAddress();
            long schemaAddr = this.schema.memoryAddress();
            Native.currentBatch(this.nativeHandle, arrayAddr, schemaAddr);
            FieldVector fieldVector = Data.importVector(this.allocator, this.array, this.schema, null);
            this.vector = new CometPlainVector((ValueVector)fieldVector, this.useDecimal128, false, this.isConstant);
        }
        this.vector.setNumValues(total);
    }

    void setNumNulls(int total) {
        this.vector.setNumNulls(total);
    }

    @Override
    public CometVector currentBatch() {
        return this.vector;
    }

    @Override
    public void close() {
        if (this.vector != null) {
            this.vector.close();
            this.vector = null;
        }
        super.close();
    }
}

