/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet;

import java.io.Serializable;
import java.nio.ByteOrder;
import org.apache.comet.CometConf$;
import org.apache.comet.CometExplainInfo$;
import org.apache.comet.CometRuntimeException;
import org.apache.comet.ConfigEntry;
import org.apache.comet.ConfigHelpers$;
import org.apache.comet.NativeBase;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.comet.CometBatchScanExec;
import org.apache.spark.sql.comet.CometScanExec;
import org.apache.spark.sql.comet.CometSparkToColumnarExec$;
import org.apache.spark.sql.comet.execution.shuffle.CometShuffleManager$;
import org.apache.spark.sql.comet.util.Utils$;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.LeafExecNode;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import org.apache.spark.sql.execution.datasources.v2.csv.CSVScan;
import org.apache.spark.sql.execution.datasources.v2.json.JsonScan;
import org.apache.spark.sql.execution.datasources.v2.parquet.ParquetScan;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class CometSparkSessionExtensions$
implements Logging {
    public static CometSparkSessionExtensions$ MODULE$;
    private boolean isBigEndian;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new CometSparkSessionExtensions$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean isBigEndian$lzycompute() {
        CometSparkSessionExtensions$ cometSparkSessionExtensions$ = this;
        synchronized (cometSparkSessionExtensions$) {
            if (!this.bitmap$0) {
                this.isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
                this.bitmap$0 = true;
            }
        }
        return this.isBigEndian;
    }

    public boolean isBigEndian() {
        if (!this.bitmap$0) {
            return this.isBigEndian$lzycompute();
        }
        return this.isBigEndian;
    }

    public boolean isANSIEnabled(SQLConf conf) {
        return BoxesRunTime.unboxToBoolean((Object)conf.getConf(SQLConf$.MODULE$.ANSI_ENABLED()));
    }

    public boolean isCometLoaded(SQLConf conf) {
        boolean bl;
        if (this.isBigEndian()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Comet extension is disabled because platform is big-endian");
            return false;
        }
        if (!BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_ENABLED().get(conf))) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Comet extension is disabled, please turn on ").append(CometConf$.MODULE$.COMET_ENABLED().key()).append(" to enable it").toString());
            return false;
        }
        if (BoxesRunTime.unboxToBoolean((Object)conf.getConf(SQLConf$.MODULE$.PARQUET_INT96_TIMESTAMP_CONVERSION()))) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("Comet extension is disabled, because it currently doesn't support").append(" ").append(SQLConf$.MODULE$.PARQUET_INT96_TIMESTAMP_CONVERSION()).append(" setting to true.").toString());
            return false;
        }
        try {
            bl = NativeBase.isLoaded();
        }
        catch (Throwable e) {
            if (BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_NATIVE_LOAD_REQUIRED().get(conf))) {
                throw new CometRuntimeException(new StringBuilder(112).append("Error when loading native library. Please fix the error and try again, or fallback ").append("to Spark by setting ").append(CometConf$.MODULE$.COMET_ENABLED().key()).append(" to false").toString(), e);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Comet extension is disabled because of error when loading native lib. Falling back to Spark", e);
            bl = false;
        }
        return bl;
    }

    public boolean isCometBroadCastForceEnabled(SQLConf conf) {
        return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_EXEC_BROADCAST_FORCE_ENABLED().get(conf));
    }

    public Option<String> getCometBroadcastNotEnabledReason(SQLConf conf) {
        if (!BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_EXEC_BROADCAST_EXCHANGE_ENABLED().get(conf)) && !this.isCometBroadCastForceEnabled(conf)) {
            return new Some((Object)new StringBuilder(47).append(CometConf$.MODULE$.COMET_EXEC_BROADCAST_EXCHANGE_ENABLED().key()).append(".enabled is not specified and ").append(CometConf$.MODULE$.COMET_EXEC_BROADCAST_FORCE_ENABLED().key()).append(" is not specified").toString());
        }
        return None$.MODULE$;
    }

    public boolean isCometShuffleEnabled(SQLConf conf) {
        return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_EXEC_SHUFFLE_ENABLED().get(conf)) && this.isCometShuffleManagerEnabled(conf);
    }

    public Option<String> getCometShuffleNotEnabledReason(SQLConf conf) {
        if (!BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_EXEC_SHUFFLE_ENABLED().get(conf))) {
            return new Some((Object)new StringBuilder(15).append(CometConf$.MODULE$.COMET_EXEC_SHUFFLE_ENABLED().key()).append(" is not enabled").toString());
        }
        if (!this.isCometShuffleManagerEnabled(conf)) {
            return new Some((Object)new StringBuilder(36).append("spark.shuffle.manager is not set to ").append(CometShuffleManager$.MODULE$.getClass().getName()).toString());
        }
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCometShuffleManagerEnabled(SQLConf conf) {
        if (!conf.contains("spark.shuffle.manager")) return false;
        String string = conf.getConfString("spark.shuffle.manager");
        String string2 = "org.apache.spark.sql.comet.execution.shuffle.CometShuffleManager";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public boolean isCometScanEnabled(SQLConf conf) {
        return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_NATIVE_SCAN_ENABLED().get(conf));
    }

    public boolean isCometExecEnabled(SQLConf conf) {
        return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_EXEC_ENABLED().get(conf));
    }

    public boolean isCometNativeShuffleMode(SQLConf conf) {
        String string = CometConf$.MODULE$.COMET_SHUFFLE_MODE().get(conf);
        if ("native".equals(string)) {
            return true;
        }
        return "auto".equals(string);
    }

    public boolean isCometJVMShuffleMode(SQLConf conf) {
        String string = CometConf$.MODULE$.COMET_SHUFFLE_MODE().get(conf);
        if ("jvm".equals(string)) {
            return true;
        }
        return "auto".equals(string);
    }

    public boolean isCometScan(SparkPlan op) {
        return op instanceof CometBatchScanExec || op instanceof CometScanExec;
    }

    public boolean shouldApplySparkToColumnar(SQLConf conf, SparkPlan op) {
        if (CometSparkToColumnarExec$.MODULE$.isSchemaSupported(op.schema())) {
            SparkPlan sparkPlan = op;
            if (sparkPlan instanceof FileSourceScanExec) {
                FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)sparkPlan;
                FileFormat fileFormat = fileSourceScanExec.relation().fileFormat();
                if (fileFormat instanceof CSVFileFormat) {
                    return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_CONVERT_FROM_CSV_ENABLED().get(conf));
                }
                if (fileFormat instanceof JsonFileFormat) {
                    return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_CONVERT_FROM_JSON_ENABLED().get(conf));
                }
                if (fileFormat instanceof ParquetFileFormat) {
                    return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_CONVERT_FROM_PARQUET_ENABLED().get(conf));
                }
                return this.isSparkToArrowEnabled(conf, op);
            }
            if (sparkPlan instanceof BatchScanExec) {
                BatchScanExec batchScanExec = (BatchScanExec)sparkPlan;
                Scan scan = batchScanExec.scan();
                if (scan instanceof CSVScan) {
                    return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_CONVERT_FROM_CSV_ENABLED().get(conf));
                }
                if (scan instanceof JsonScan) {
                    return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_CONVERT_FROM_JSON_ENABLED().get(conf));
                }
                if (scan instanceof ParquetScan) {
                    return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_CONVERT_FROM_PARQUET_ENABLED().get(conf));
                }
                return this.isSparkToArrowEnabled(conf, op);
            }
            if (sparkPlan instanceof LeafExecNode) {
                return this.isSparkToArrowEnabled(conf, op);
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSparkToArrowEnabled(SQLConf conf, SparkPlan op) {
        if (!BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_SPARK_TO_ARROW_ENABLED().get(conf))) return false;
        String simpleClassName = Utils$.MODULE$.getSimpleName(op.getClass());
        String nodeName = simpleClassName.replaceAll("Exec$", "");
        if (!((SeqLike)CometConf$.MODULE$.COMET_SPARK_TO_ARROW_SUPPORTED_OPERATOR_LIST().get(conf)).contains((Object)nodeName)) return false;
        return true;
    }

    public boolean isSpark35Plus() {
        return new StringOps(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION())).$greater$eq((Object)"3.5");
    }

    public boolean isSpark40Plus() {
        return new StringOps(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION())).$greater$eq((Object)"4.0");
    }

    public boolean usingDataFusionParquetExec(SQLConf conf) {
        return ((SeqLike)new .colon.colon((Object)CometConf$.MODULE$.SCAN_NATIVE_ICEBERG_COMPAT(), (List)new .colon.colon((Object)CometConf$.MODULE$.SCAN_NATIVE_DATAFUSION(), (List)Nil$.MODULE$))).contains((Object)CometConf$.MODULE$.COMET_NATIVE_SCAN_IMPL().get(conf));
    }

    public boolean shouldOverrideMemoryConf(SparkConf conf) {
        boolean cometEnabled = this.getBooleanConf(conf, CometConf$.MODULE$.COMET_ENABLED());
        boolean cometShuffleEnabled = this.getBooleanConf(conf, CometConf$.MODULE$.COMET_EXEC_SHUFFLE_ENABLED());
        boolean cometExecEnabled = this.getBooleanConf(conf, CometConf$.MODULE$.COMET_EXEC_ENABLED());
        boolean offHeapMode = this.isOffHeapEnabled(conf);
        return cometEnabled && (cometShuffleEnabled || cometExecEnabled) && !offHeapMode;
    }

    public long getCometMemoryOverheadInMiB(SparkConf sparkConf) {
        if (this.isOffHeapEnabled(sparkConf)) {
            return 0L;
        }
        long baseMemoryMiB = ConfigHelpers$.MODULE$.byteFromString(sparkConf.get("spark.executor.memory", "1024MB"), ByteUnit.MiB);
        String cometMemoryOverheadMinAsString = sparkConf.get(CometConf$.MODULE$.COMET_MEMORY_OVERHEAD_MIN_MIB().key(), CometConf$.MODULE$.COMET_MEMORY_OVERHEAD_MIN_MIB().defaultValueString());
        long minimum = ConfigHelpers$.MODULE$.byteFromString(cometMemoryOverheadMinAsString, ByteUnit.MiB);
        double overheadFactor = this.getDoubleConf(sparkConf, CometConf$.MODULE$.COMET_MEMORY_OVERHEAD_FACTOR());
        Option overHeadMemFromConf = sparkConf.getOption(CometConf$.MODULE$.COMET_MEMORY_OVERHEAD().key()).map((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToLong((long)ConfigHelpers$.MODULE$.byteFromString(x$35, ByteUnit.MiB)));
        return BoxesRunTime.unboxToLong((Object)overHeadMemFromConf.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max((long)(overheadFactor * (double)baseMemoryMiB), minimum)));
    }

    private boolean getBooleanConf(SparkConf conf, ConfigEntry<Object> entry) {
        return conf.getBoolean(entry.key(), BoxesRunTime.unboxToBoolean((Object)entry.defaultValue().get()));
    }

    private double getDoubleConf(SparkConf conf, ConfigEntry<Object> entry) {
        return conf.getDouble(entry.key(), BoxesRunTime.unboxToDouble((Object)entry.defaultValue().get()));
    }

    public long getCometMemoryOverhead(SparkConf sparkConf) {
        return ByteUnit.MiB.toBytes(this.getCometMemoryOverheadInMiB(sparkConf));
    }

    public long getCometShuffleMemorySize(SparkConf sparkConf, SQLConf conf) {
        Predef$.MODULE$.assert(!this.isOffHeapEnabled(sparkConf));
        long cometMemoryOverhead = this.getCometMemoryOverheadInMiB(sparkConf);
        double overheadFactor = BoxesRunTime.unboxToDouble((Object)CometConf$.MODULE$.COMET_COLUMNAR_SHUFFLE_MEMORY_FACTOR().get(conf));
        Option<Object> cometShuffleMemoryFromConf = CometConf$.MODULE$.COMET_COLUMNAR_SHUFFLE_MEMORY_SIZE().get(conf);
        long shuffleMemorySize = BoxesRunTime.unboxToLong((Object)cometShuffleMemoryFromConf.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> (long)(overheadFactor * (double)cometMemoryOverhead)));
        if (shuffleMemorySize > cometMemoryOverhead) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("Configured shuffle memory size ").append(shuffleMemorySize).append(" is larger than Comet memory overhead ").append(cometMemoryOverhead).append(", using Comet memory overhead instead.").toString());
            return ByteUnit.MiB.toBytes(cometMemoryOverhead);
        }
        return ByteUnit.MiB.toBytes(shuffleMemorySize);
    }

    public SQLConf getCometShuffleMemorySize$default$2() {
        return SQLConf$.MODULE$.get();
    }

    public boolean isOffHeapEnabled(SparkConf sparkConf) {
        return sparkConf.getBoolean("spark.memory.offHeap.enabled", false);
    }

    public <T extends TreeNode<?>> T withInfo(T node, String info, Seq<T> exprs) {
        Set infoSet = info == null || info.isEmpty() ? Predef$.MODULE$.Set().empty() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])info.split("\n"))).toSet();
        return this.withInfos(node, (Set<String>)infoSet, exprs);
    }

    public <T extends TreeNode<?>> T withInfos(T node, Set<String> info, Seq<T> exprs) {
        Option existingNodeInfos = node.getTagValue(CometExplainInfo$.MODULE$.EXTENSION_INFO());
        Set newNodeInfo = ((TraversableOnce)((GenericTraversableTemplate)Option$.MODULE$.option2Iterable(existingNodeInfos).$plus$plus((GenTraversableOnce)exprs.flatMap((Function1 & Serializable & scala.Serializable)x$36 -> Option$.MODULE$.option2Iterable(x$36.getTagValue(CometExplainInfo$.MODULE$.EXTENSION_INFO())), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).toSet();
        node.setTagValue(CometExplainInfo$.MODULE$.EXTENSION_INFO(), (Object)newNodeInfo.$plus$plus(info));
        return node;
    }

    public <T extends TreeNode<?>> T withInfo(T node, Seq<T> exprs) {
        return this.withInfos(node, (Set<String>)Predef$.MODULE$.Set().empty(), exprs);
    }

    public Option<String> createMessage(boolean condition, Function0<String> message) {
        if (condition) {
            return new Some(message.apply());
        }
        return None$.MODULE$;
    }

    private CometSparkSessionExtensions$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

