/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.comet.execution.shuffle;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.comet.shims.ShimCometShuffleExchangeExec;
import org.apache.spark.Aggregator;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.RangePartitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleWriteProcessor;
import org.apache.spark.shuffle.sort.SortShuffleManager$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.codegen.LazilyGeneratedOrdering;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.RangePartitioning;
import org.apache.spark.sql.catalyst.plans.physical.RoundRobinPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.SinglePartition$;
import org.apache.spark.sql.comet.execution.shuffle.CometColumnarShuffle$;
import org.apache.spark.sql.comet.execution.shuffle.CometNativeShuffle$;
import org.apache.spark.sql.comet.execution.shuffle.CometShuffleDependency;
import org.apache.spark.sql.comet.execution.shuffle.CometShuffleDependency$;
import org.apache.spark.sql.comet.execution.shuffle.CometShuffleExchangeExec;
import org.apache.spark.sql.comet.execution.shuffle.CometShuffleManager;
import org.apache.spark.sql.comet.execution.shuffle.CometShuffleWriteProcessor;
import org.apache.spark.sql.comet.execution.shuffle.ConstantPartitioner;
import org.apache.spark.sql.comet.execution.shuffle.PartitionIdPassthrough;
import org.apache.spark.sql.comet.execution.shuffle.ShuffleType;
import org.apache.spark.sql.execution.RecordBinaryComparator;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.UnsafeExternalRowSorter;
import org.apache.spark.sql.execution.exchange.ENSURE_REQUIREMENTS$;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec$;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeLike;
import org.apache.spark.sql.execution.exchange.ShuffleOrigin;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.MutablePair;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparators;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class CometShuffleExchangeExec$
implements ShimCometShuffleExchangeExec,
scala.Serializable {
    public static CometShuffleExchangeExec$ MODULE$;

    static {
        new CometShuffleExchangeExec$();
    }

    @Override
    public CometShuffleExchangeExec apply(ShuffleExchangeExec s, ShuffleType shuffleType) {
        return ShimCometShuffleExchangeExec.apply$(this, s, shuffleType);
    }

    @Override
    public StructType fromAttributes(Seq<Attribute> attributes) {
        return ShimCometShuffleExchangeExec.fromAttributes$(this, attributes);
    }

    @Override
    public int getShuffleId(ShuffleDependency<Object, ?, ?> shuffleDependency) {
        return ShimCometShuffleExchangeExec.getShuffleId$(this, shuffleDependency);
    }

    public ShuffleOrigin $lessinit$greater$default$4() {
        return ENSURE_REQUIREMENTS$.MODULE$;
    }

    public ShuffleType $lessinit$greater$default$5() {
        return CometNativeShuffle$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public ShuffleDependency<Object, ColumnarBatch, ColumnarBatch> prepareShuffleDependency(RDD<ColumnarBatch> rdd, Seq<Attribute> outputAttributes, Partitioning outputPartitioning, Serializer serializer, Map<String, SQLMetric> metrics) {
        int numParts = rdd.getNumPartitions();
        RDD x$1 = rdd.map((Function1 & Serializable & scala.Serializable)x$3 -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), x$3), ClassTag$.MODULE$.apply(Tuple2.class));
        Serializer x$2 = serializer;
        CometShuffleWriteProcessor x$32 = new CometShuffleWriteProcessor(outputPartitioning, outputAttributes, metrics, numParts);
        CometNativeShuffle$ x$4 = CometNativeShuffle$.MODULE$;
        Partitioner x$5 = new Partitioner(outputPartitioning){
            private final Partitioning outputPartitioning$1;

            public int numPartitions() {
                return this.outputPartitioning$1.numPartitions();
            }

            public int getPartition(Object key) {
                return BoxesRunTime.unboxToInt((Object)key);
            }
            {
                this.outputPartitioning$1 = outputPartitioning$1;
            }
        };
        SQLMetric x$6 = (SQLMetric)metrics.apply((Object)"decode_time");
        None$ x$7 = CometShuffleDependency$.MODULE$.$lessinit$greater$default$4();
        None$ x$8 = CometShuffleDependency$.MODULE$.$lessinit$greater$default$5();
        boolean x$9 = CometShuffleDependency$.MODULE$.$lessinit$greater$default$6();
        Option<StructType> x$10 = CometShuffleDependency$.MODULE$.$lessinit$greater$default$9();
        CometShuffleDependency<Object, ColumnarBatch, ColumnarBatch> dependency = new CometShuffleDependency<Object, ColumnarBatch, ColumnarBatch>((RDD<Product2<Object, ColumnarBatch>>)x$1, x$5, x$2, (Option<Ordering<Object>>)x$7, (Option<Aggregator<Object, ColumnarBatch, ColumnarBatch>>)x$8, x$9, x$32, x$4, x$10, x$6, (ClassTag<Object>)ClassTag$.MODULE$.Int(), (ClassTag<ColumnarBatch>)ClassTag$.MODULE$.apply(ColumnarBatch.class), (ClassTag<ColumnarBatch>)ClassTag$.MODULE$.apply(ColumnarBatch.class));
        return dependency;
    }

    private boolean needToCopyObjectsBeforeShuffle(Partitioner partitioner) {
        SparkConf conf = SparkEnv$.MODULE$.get().conf();
        ShuffleManager shuffleManager = SparkEnv$.MODULE$.get().shuffleManager();
        boolean sortBasedShuffleOn = shuffleManager instanceof CometShuffleManager;
        int bypassMergeThreshold = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.SHUFFLE_SORT_BYPASS_MERGE_THRESHOLD()));
        int numParts = partitioner.numPartitions();
        if (sortBasedShuffleOn) {
            if (numParts <= bypassMergeThreshold) {
                return false;
            }
            if (numParts <= SortShuffleManager$.MODULE$.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE()) {
                return false;
            }
            return false;
        }
        return true;
    }

    public ShuffleDependency<Object, InternalRow, InternalRow> prepareJVMShuffleDependency(RDD<InternalRow> rdd, Seq<Attribute> outputAttributes, Partitioning newPartitioning, Serializer serializer, Map<String, SQLMetric> writeMetrics) {
        RDD rddWithPartitionIds;
        RDD rDD;
        boolean isOrderSensitive;
        Object object;
        Partitioning partitioning = newPartitioning;
        if (partitioning instanceof RoundRobinPartitioning) {
            RoundRobinPartitioning roundRobinPartitioning = (RoundRobinPartitioning)partitioning;
            int numPartitions = roundRobinPartitioning.numPartitions();
            object = new HashPartitioner(numPartitions);
        } else if (partitioning instanceof HashPartitioning) {
            HashPartitioning hashPartitioning = (HashPartitioning)partitioning;
            int n = hashPartitioning.numPartitions();
            object = new PartitionIdPassthrough(n);
        } else if (partitioning instanceof RangePartitioning) {
            RangePartitioning rangePartitioning = (RangePartitioning)partitioning;
            Seq sortingExpressions = rangePartitioning.ordering();
            int numPartitions = rangePartitioning.numPartitions();
            RDD rddForSampling = rdd.mapPartitionsInternal((Function1 & Serializable & scala.Serializable)iter -> {
                UnsafeProjection projection = UnsafeProjection$.MODULE$.create((Seq)sortingExpressions.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.child(), Seq$.MODULE$.canBuildFrom()), outputAttributes);
                MutablePair mutablePair = new MutablePair();
                return iter.map((Function1 & Serializable & scala.Serializable)row -> mutablePair.update((Object)projection.apply(row).copy(), null));
            }, rdd.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(MutablePair.class));
            Seq orderingAttributes = (Seq)((TraversableLike)sortingExpressions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    SortOrder ord = (SortOrder)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    return ord.copy((Expression)new BoundReference(i, ord.dataType(), ord.nullable()), ord.copy$default$2(), ord.copy$default$3(), ord.copy$default$4());
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            LazilyGeneratedOrdering ordering = new LazilyGeneratedOrdering(orderingAttributes);
            object = new RangePartitioner(numPartitions, rddForSampling, true, SQLConf$.MODULE$.get().rangeExchangeSampleSizePerPartition(), (Ordering)ordering, ClassTag$.MODULE$.apply(InternalRow.class));
        } else if (SinglePartition$.MODULE$.equals(partitioning)) {
            object = new ConstantPartitioner();
        } else {
            throw new IllegalStateException(new StringBuilder(29).append("Exchange not implemented for ").append(newPartitioning).toString());
        }
        HashPartitioner part = object;
        boolean isRoundRobin = newPartitioning instanceof RoundRobinPartitioning && newPartitioning.numPartitions() > 1;
        RDD newRdd = isRoundRobin && SQLConf$.MODULE$.get().sortBeforeRepartition() ? rdd.mapPartitionsInternal((Function1 & Serializable & scala.Serializable)iter -> {
            Supplier<RecordComparator> recordComparatorSupplier = new Supplier<RecordComparator>(){

                public RecordComparator get() {
                    return new RecordBinaryComparator();
                }
            };
            PrefixComparator prefixComparator = PrefixComparators.LONG;
            UnsafeExternalRowSorter.PrefixComputer prefixComputer = new UnsafeExternalRowSorter.PrefixComputer(){
                private final UnsafeExternalRowSorter.PrefixComputer.Prefix result;

                private UnsafeExternalRowSorter.PrefixComputer.Prefix result() {
                    return this.result;
                }

                public UnsafeExternalRowSorter.PrefixComputer.Prefix computePrefix(InternalRow row) {
                    this.result().isNull = false;
                    this.result().value = row.hashCode();
                    return this.result();
                }
                {
                    this.result = new UnsafeExternalRowSorter.PrefixComputer.Prefix();
                }
            };
            long pageSize = SparkEnv$.MODULE$.get().memoryManager().pageSizeBytes();
            UnsafeExternalRowSorter sorter = UnsafeExternalRowSorter.createWithRecordComparator((StructType)MODULE$.fromAttributes(outputAttributes), (Supplier)recordComparatorSupplier, (PrefixComparator)prefixComparator, (UnsafeExternalRowSorter.PrefixComputer)prefixComputer, (long)pageSize, (boolean)false);
            return sorter.sort(iter);
        }, rdd.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(InternalRow.class)) : rdd;
        boolean bl = isOrderSensitive = isRoundRobin && !SQLConf$.MODULE$.get().sortBeforeRepartition();
        if (this.needToCopyObjectsBeforeShuffle((Partitioner)part)) {
            Function2 & Serializable & scala.Serializable x$1 = (arg_0, arg_1) -> CometShuffleExchangeExec$.$anonfun$prepareJVMShuffleDependency$11$adapted((Partitioner)part, newPartitioning, outputAttributes, arg_0, arg_1);
            boolean x$2 = isOrderSensitive;
            boolean x$3 = newRdd.mapPartitionsWithIndexInternal$default$2();
            rDD = newRdd.mapPartitionsWithIndexInternal((Function2)x$1, x$3, x$2, ClassTag$.MODULE$.apply(Product2.class));
        } else {
            Function2 & Serializable & scala.Serializable x$4 = (arg_0, arg_1) -> CometShuffleExchangeExec$.$anonfun$prepareJVMShuffleDependency$13$adapted((Partitioner)part, newPartitioning, outputAttributes, arg_0, arg_1);
            boolean x$5 = isOrderSensitive;
            boolean x$6 = newRdd.mapPartitionsWithIndexInternal$default$2();
            rDD = newRdd.mapPartitionsWithIndexInternal((Function2)x$4, x$6, x$5, ClassTag$.MODULE$.apply(Product2.class));
        }
        RDD x$7 = rddWithPartitionIds = rDD;
        PartitionIdPassthrough x$8 = new PartitionIdPassthrough(part.numPartitions());
        Serializer x$9 = serializer;
        ShuffleWriteProcessor x$10 = ShuffleExchangeExec$.MODULE$.createShuffleWriteProcessor(writeMetrics);
        CometColumnarShuffle$ x$11 = CometColumnarShuffle$.MODULE$;
        Some x$12 = new Some((Object)this.fromAttributes(outputAttributes));
        SQLMetric x$13 = (SQLMetric)writeMetrics.apply((Object)"decode_time");
        None$ x$14 = CometShuffleDependency$.MODULE$.$lessinit$greater$default$4();
        None$ x$15 = CometShuffleDependency$.MODULE$.$lessinit$greater$default$5();
        boolean x$16 = CometShuffleDependency$.MODULE$.$lessinit$greater$default$6();
        CometShuffleDependency<Object, InternalRow, InternalRow> dependency = new CometShuffleDependency<Object, InternalRow, InternalRow>((RDD<Product2<Object, InternalRow>>)x$7, x$8, x$9, (Option<Ordering<Object>>)x$14, (Option<Aggregator<Object, InternalRow, InternalRow>>)x$15, x$16, x$10, x$11, (Option<StructType>)x$12, x$13, (ClassTag<Object>)ClassTag$.MODULE$.Int(), (ClassTag<InternalRow>)ClassTag$.MODULE$.apply(InternalRow.class), (ClassTag<InternalRow>)ClassTag$.MODULE$.apply(InternalRow.class));
        return dependency;
    }

    public CometShuffleExchangeExec apply(Partitioning outputPartitioning, SparkPlan child, ShuffleExchangeLike originalPlan, ShuffleOrigin shuffleOrigin, ShuffleType shuffleType, Option<Object> advisoryPartitionSize) {
        return new CometShuffleExchangeExec(outputPartitioning, child, originalPlan, shuffleOrigin, shuffleType, advisoryPartitionSize);
    }

    public ShuffleOrigin apply$default$4() {
        return ENSURE_REQUIREMENTS$.MODULE$;
    }

    public ShuffleType apply$default$5() {
        return CometNativeShuffle$.MODULE$;
    }

    public Option<Object> apply$default$6() {
        return None$.MODULE$;
    }

    public Option<Tuple6<Partitioning, SparkPlan, ShuffleExchangeLike, ShuffleOrigin, ShuffleType, Option<Object>>> unapply(CometShuffleExchangeExec x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.outputPartitioning(), (Object)x$0.child(), (Object)x$0.originalPlan(), (Object)x$0.shuffleOrigin(), (Object)x$0.shuffleType(), x$0.advisoryPartitionSize()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ int $anonfun$prepareJVMShuffleDependency$5(IntRef position$1, InternalRow x$5) {
        ++position$1.elem;
        return position$1.elem;
    }

    public static final /* synthetic */ int $anonfun$prepareJVMShuffleDependency$6(UnsafeProjection projection$2, InternalRow row) {
        return projection$2.apply(row).getInt(0);
    }

    private static final Function1 getPartitionKeyExtractor$1(Partitioning newPartitioning$1, Seq outputAttributes$1) {
        Partitioning partitioning = newPartitioning$1;
        if (partitioning instanceof RoundRobinPartitioning) {
            RoundRobinPartitioning roundRobinPartitioning = (RoundRobinPartitioning)partitioning;
            int numPartitions = roundRobinPartitioning.numPartitions();
            int partitionId = TaskContext$.MODULE$.get().partitionId();
            IntRef position = IntRef.create((int)new XORShiftRandom((long)partitionId).nextInt(numPartitions));
            return (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)CometShuffleExchangeExec$.$anonfun$prepareJVMShuffleDependency$5(position, x$5));
        }
        if (partitioning instanceof HashPartitioning) {
            HashPartitioning hashPartitioning = (HashPartitioning)partitioning;
            Expression expression = hashPartitioning.partitionIdExpression();
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((Seq)Nil$.MODULE$.$colon$colon((Object)expression), outputAttributes$1);
            return (Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)CometShuffleExchangeExec$.$anonfun$prepareJVMShuffleDependency$6(projection, row));
        }
        if (partitioning instanceof RangePartitioning) {
            RangePartitioning rangePartitioning = (RangePartitioning)partitioning;
            Seq sortingExpressions = rangePartitioning.ordering();
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((Seq)sortingExpressions.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.child(), Seq$.MODULE$.canBuildFrom()), outputAttributes$1);
            return (Function1 & Serializable & scala.Serializable)row -> projection.apply(row);
        }
        if (SinglePartition$.MODULE$.equals(partitioning)) {
            return (Function1 & Serializable & scala.Serializable)x -> (InternalRow)Predef$.MODULE$.identity(x);
        }
        throw new IllegalStateException(new StringBuilder(29).append("Exchange not implemented for ").append(newPartitioning$1).toString());
    }

    public static final /* synthetic */ Iterator $anonfun$prepareJVMShuffleDependency$11(Partitioner part$1, Partitioning newPartitioning$1, Seq outputAttributes$1, int x$8, Iterator iter) {
        Function1 getPartitionKey = CometShuffleExchangeExec$.getPartitionKeyExtractor$1(newPartitioning$1, outputAttributes$1);
        return iter.map((Function1 & Serializable & scala.Serializable)row -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)part$1.getPartition(getPartitionKey.apply(row))), (Object)row.copy()));
    }

    public static final /* synthetic */ Iterator $anonfun$prepareJVMShuffleDependency$13(Partitioner part$1, Partitioning newPartitioning$1, Seq outputAttributes$1, int x$9, Iterator iter) {
        Function1 getPartitionKey = CometShuffleExchangeExec$.getPartitionKeyExtractor$1(newPartitioning$1, outputAttributes$1);
        MutablePair mutablePair = new MutablePair();
        return iter.map((Function1 & Serializable & scala.Serializable)row -> mutablePair.update((Object)BoxesRunTime.boxToInteger((int)part$1.getPartition(getPartitionKey.apply(row))), row));
    }

    private CometShuffleExchangeExec$() {
        MODULE$ = this;
        ShimCometShuffleExchangeExec.$init$(this);
    }

    public static final /* synthetic */ Iterator $anonfun$prepareJVMShuffleDependency$11$adapted(Partitioner part$1, Partitioning newPartitioning$1, Seq outputAttributes$1, Object x$8, Iterator iter) {
        return CometShuffleExchangeExec$.$anonfun$prepareJVMShuffleDependency$11(part$1, newPartitioning$1, outputAttributes$1, BoxesRunTime.unboxToInt((Object)x$8), iter);
    }

    public static final /* synthetic */ Iterator $anonfun$prepareJVMShuffleDependency$13$adapted(Partitioner part$1, Partitioning newPartitioning$1, Seq outputAttributes$1, Object x$9, Iterator iter) {
        return CometShuffleExchangeExec$.$anonfun$prepareJVMShuffleDependency$13(part$1, newPartitioning$1, outputAttributes$1, BoxesRunTime.unboxToInt((Object)x$9), iter);
    }
}

