/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.vector;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.comet.shaded.arrow.vector.FixedWidthVector;
import org.apache.comet.shaded.arrow.vector.ValueVector;
import org.apache.comet.shaded.arrow.vector.complex.ListVector;
import org.apache.comet.shaded.arrow.vector.complex.MapVector;
import org.apache.comet.shaded.arrow.vector.complex.StructVector;
import org.apache.comet.shaded.arrow.vector.dictionary.Dictionary;
import org.apache.comet.shaded.arrow.vector.dictionary.DictionaryProvider;
import org.apache.comet.shaded.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.comet.vector.CometDictionary;
import org.apache.comet.vector.CometDictionaryVector;
import org.apache.comet.vector.CometListVector;
import org.apache.comet.vector.CometMapVector;
import org.apache.comet.vector.CometPlainVector;
import org.apache.comet.vector.CometStructVector;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;
import sun.misc.Unsafe;

public abstract class CometVector
extends ColumnVector {
    private static final int DECIMAL_BYTE_WIDTH = 16;
    private final byte[] DECIMAL_BYTES = new byte[16];
    protected final boolean useDecimal128;
    private static final long decimalValOffset;

    protected CometVector(DataType type, boolean useDecimal128) {
        super(type);
        this.useDecimal128 = useDecimal128;
    }

    public abstract void setNumNulls(int var1);

    public abstract void setNumValues(int var1);

    public abstract int numValues();

    public boolean isFixedLength() {
        return this.getValueVector() instanceof FixedWidthVector;
    }

    public Decimal getDecimal(int i, int precision, int scale) {
        if (!this.useDecimal128 && precision <= Decimal.MAX_INT_DIGITS() && this.type instanceof IntegerType) {
            return this.createDecimal(this.getInt(i), precision, scale);
        }
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            return this.createDecimal(this.useDecimal128 ? this.getLongDecimal(i) : this.getLong(i), precision, scale);
        }
        byte[] bytes = this.getBinaryDecimal(i);
        BigInteger bigInteger = new BigInteger(bytes);
        BigDecimal javaDecimal = new BigDecimal(bigInteger, scale);
        return this.createDecimal(javaDecimal, precision, scale);
    }

    private Decimal createDecimal(long unscaled, int precision, int scale) {
        Decimal dec = new Decimal();
        dec.org$apache$spark$sql$types$Decimal$$longVal_$eq(unscaled);
        dec.org$apache$spark$sql$types$Decimal$$_precision_$eq(precision);
        dec.org$apache$spark$sql$types$Decimal$$_scale_$eq(scale);
        return dec;
    }

    private Decimal createDecimal(BigDecimal value, int precision, int scale) {
        Decimal dec = new Decimal();
        Platform.putObjectVolatile((Object)dec, (long)decimalValOffset, (Object)new scala.math.BigDecimal(value));
        dec.org$apache$spark$sql$types$Decimal$$_precision_$eq(precision);
        dec.org$apache$spark$sql$types$Decimal$$_scale_$eq(scale);
        return dec;
    }

    byte[] getBinaryDecimal(int i) {
        return this.copyBinaryDecimal(i, this.DECIMAL_BYTES);
    }

    public byte[] copyBinaryDecimal(int i, byte[] dest) {
        long valueBufferAddress = this.getValueVector().getDataBuffer().memoryAddress();
        Platform.copyMemory(null, (long)(valueBufferAddress + (long)i * 16L), (Object)dest, (long)Platform.BYTE_ARRAY_OFFSET, (long)16L);
        int j = 0;
        int k = 15;
        while (j < 8) {
            byte tmp = dest[j];
            dest[j] = dest[k];
            dest[k] = tmp;
            ++j;
            --k;
        }
        return dest;
    }

    public boolean getBoolean(int rowId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public byte getByte(int rowId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public short getShort(int rowId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public int getInt(int rowId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public long getLong(int rowId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public long getLongDecimal(int rowId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public float getFloat(int rowId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public double getDouble(int rowId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public UTF8String getUTF8String(int rowId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public byte[] getBinary(int rowId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public ColumnarArray getArray(int i) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public ColumnarMap getMap(int i) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public ColumnVector getChild(int i) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public void close() {
        this.getValueVector().close();
    }

    public DictionaryProvider getDictionaryProvider() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public abstract ValueVector getValueVector();

    public abstract CometVector slice(int var1, int var2);

    protected static CometVector getVector(ValueVector vector, boolean useDecimal128, DictionaryProvider dictionaryProvider) {
        if (vector instanceof StructVector) {
            return new CometStructVector(vector, useDecimal128, dictionaryProvider);
        }
        if (vector instanceof MapVector) {
            return new CometMapVector(vector, useDecimal128, dictionaryProvider);
        }
        if (vector instanceof ListVector) {
            return new CometListVector(vector, useDecimal128, dictionaryProvider);
        }
        DictionaryEncoding dictionaryEncoding = vector.getField().getDictionary();
        CometPlainVector cometVector = new CometPlainVector(vector, useDecimal128);
        if (dictionaryEncoding == null) {
            return cometVector;
        }
        Dictionary dictionary = dictionaryProvider.lookup(dictionaryEncoding.getId());
        CometPlainVector dictionaryVector = new CometPlainVector(dictionary.getVector(), useDecimal128);
        CometDictionary cometDictionary = new CometDictionary(dictionaryVector);
        return new CometDictionaryVector(cometVector, cometDictionary, dictionaryProvider, useDecimal128);
    }

    protected static CometVector getVector(ValueVector vector, boolean useDecimal128) {
        return CometVector.getVector(vector, useDecimal128, null);
    }

    static {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Unsafe unsafe = (Unsafe)unsafeField.get(null);
            decimalValOffset = unsafe.objectFieldOffset(Decimal.class.getDeclaredField("decimalVal"));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

