/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Basic utility libraries and interfaces.
 *
 * <p>This package is a part of the open-source
 * <a href="http://guava-libraries.googlecode.com">Guava libraries</a>.
 *
 * <h2>Contents</h2>
 *
 * <h3>String-related utilities</h3>
 *
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.base.Ascii}
 * <li>{@link org.apache.comet.shaded.guava.base.CaseFormat}
 * <li>{@link org.apache.comet.shaded.guava.base.CharMatcher}
 * <li>{@link org.apache.comet.shaded.guava.base.Charsets}
 * <li>{@link org.apache.comet.shaded.guava.base.Joiner}
 * <li>{@link org.apache.comet.shaded.guava.base.Splitter}
 * <li>{@link org.apache.comet.shaded.guava.base.Strings}
 * </ul>
 *
 * <h3>Function types</h3>
 *
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.base.Function},
 *     {@link org.apache.comet.shaded.guava.base.Functions}
 * <li>{@link org.apache.comet.shaded.guava.base.Predicate},
 *     {@link org.apache.comet.shaded.guava.base.Predicates}
 * <li>{@link org.apache.comet.shaded.guava.base.Equivalence}
 * <li>{@link org.apache.comet.shaded.guava.base.Supplier},
 *     {@link org.apache.comet.shaded.guava.base.Suppliers}
 * </ul>
 *
 * <h3>Other</h3>
 *
 * <ul>
 * <li>{@link org.apache.comet.shaded.guava.base.Defaults}
 * <li>{@link org.apache.comet.shaded.guava.base.Enums}
 * <li>{@link org.apache.comet.shaded.guava.base.Objects}
 * <li>{@link org.apache.comet.shaded.guava.base.Optional}
 * <li>{@link org.apache.comet.shaded.guava.base.Preconditions}
 * <li>{@link org.apache.comet.shaded.guava.base.Stopwatch}
 * <li>{@link org.apache.comet.shaded.guava.base.Throwables}
 * </ul>
 *
 */
@ParametersAreNonnullByDefault
package org.apache.comet.shaded.guava.base;

import javax.annotation.ParametersAreNonnullByDefault;
