/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors.unparsers;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.daffodil.infoset.DISimple;
import org.apache.daffodil.infoset.DataValue$;
import org.apache.daffodil.io.DirectOrBufferedDataOutputStream;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.processors.ElementRuntimeData;
import org.apache.daffodil.processors.PrimProcessor;
import org.apache.daffodil.processors.Processor;
import org.apache.daffodil.processors.ToBriefXMLImpl;
import org.apache.daffodil.processors.unparsers.PrimUnparser;
import org.apache.daffodil.processors.unparsers.UState;
import org.apache.daffodil.processors.unparsers.UnparseError$;
import org.apache.daffodil.processors.unparsers.Unparser;
import org.apache.daffodil.util.LogLevel;
import org.apache.daffodil.util.LogWriter;
import org.apache.daffodil.util.Logging;
import org.apache.daffodil.util.Maybe;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u00193Q!\u0001\u0002\u0002\u00025\u0011\u0001C\u00117pEVs\u0007/\u0019:tKJ\u0014\u0015m]3\u000b\u0005\r!\u0011!C;oa\u0006\u00148/\u001a:t\u0015\t)a!\u0001\u0006qe>\u001cWm]:peNT!a\u0002\u0005\u0002\u0011\u0011\fgMZ8eS2T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u0019A\u0013\u0018.\\+oa\u0006\u00148/\u001a:\t\u0011e\u0001!Q1A\u0005Bi\tqaY8oi\u0016DH/F\u0001\u001c!\taR$D\u0001\u0005\u0013\tqBA\u0001\nFY\u0016lWM\u001c;Sk:$\u0018.\\3ECR\f\u0007\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u0011\r|g\u000e^3yi\u0002BQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtDC\u0001\u0013&!\t)\u0002\u0001C\u0003\u001aC\u0001\u00071\u0004\u0003\u0005(\u0001!\u0015\r\u0011\"\u0011)\u0003M\u0011XO\u001c;j[\u0016$U\r]3oI\u0016t7-[3t+\u0005I\u0003c\u0001\u00160c5\t1F\u0003\u0002-[\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003]A\t!bY8mY\u0016\u001cG/[8o\u0013\t\u00014F\u0001\u0004WK\u000e$xN\u001d\t\u0003\u001fIJ!a\r\t\u0003\u000f9{G\u000f[5oO\")Q\u0007\u0001D\tm\u0005yq-\u001a;MK:<G\u000f[%o\u0005&$8\u000f\u0006\u00028uA\u0011q\u0002O\u0005\u0003sA\u0011A\u0001T8oO\")1\b\u000ea\u0001y\u0005)1\u000f^1uKB\u0011Q#P\u0005\u0003}\t\u0011a!V*uCR,\u0007\"\u0002!\u0001\t\u0003\n\u0015aB;oa\u0006\u00148/\u001a\u000b\u0003\u0005\u0016\u0003\"aD\"\n\u0005\u0011\u0003\"\u0001B+oSRDQaO A\u0002q\u0002")
public abstract class BlobUnparserBase
implements PrimUnparser {
    private Vector<Nothing$> runtimeDependencies;
    private final ElementRuntimeData context;
    private boolean isInitialized;
    private String logID;
    private Object logWriter;
    private Object logLevel;
    private String org$apache$daffodil$processors$ToBriefXMLImpl$$nom_;
    private volatile byte bitmap$0;

    public Vector<Processor> childProcessors() {
        return PrimProcessor.childProcessors$((PrimProcessor)this);
    }

    public boolean isPrimitive() {
        return PrimProcessor.isPrimitive$((PrimProcessor)this);
    }

    public boolean isEmpty() {
        return Unparser.isEmpty$((Unparser)this);
    }

    public final void unparse1(UState ustate, Object ignore) {
        Unparser.unparse1$((Unparser)this, (UState)ustate, (Object)ignore);
    }

    public Nothing$ UE(UState ustate, String s, Seq<Object> args) {
        return Unparser.UE$((Unparser)this, (UState)ustate, (String)s, args);
    }

    public final Object unparse1$default$2() {
        return Unparser.unparse1$default$2$((Unparser)this);
    }

    public void setLoggingLevel(LogLevel.Type level) {
        Logging.setLoggingLevel$((Logging)this, (LogLevel.Type)level);
    }

    public final LogLevel.Type getLoggingLevel() {
        return Logging.getLoggingLevel$((Logging)this);
    }

    public void setLogWriter(LogWriter lw) {
        Logging.setLogWriter$((Logging)this, (LogWriter)lw);
    }

    public LogWriter getLogWriter() {
        return Logging.getLogWriter$((Logging)this);
    }

    public final boolean areLogging(LogLevel.Type lvl) {
        return Logging.areLogging$((Logging)this, (LogLevel.Type)lvl);
    }

    public void doLogging(LogLevel.Type lvl, String msg, Seq<Object> args) {
        Logging.doLogging$((Logging)this, (LogLevel.Type)lvl, (String)msg, args);
    }

    public <S> LogLevel.Type withLoggingLevel$default$1() {
        return Logging.withLoggingLevel$default$1$((Logging)this);
    }

    public String nom() {
        return ToBriefXMLImpl.nom$((ToBriefXMLImpl)this);
    }

    public String briefXMLAttributes() {
        return ToBriefXMLImpl.briefXMLAttributes$((ToBriefXMLImpl)this);
    }

    public String toBriefXML(int depthLimit) {
        return ToBriefXMLImpl.toBriefXML$((ToBriefXMLImpl)this, (int)depthLimit);
    }

    public String toString() {
        return ToBriefXMLImpl.toString$((ToBriefXMLImpl)this);
    }

    public int toBriefXML$default$1() {
        return ToBriefXMLImpl.toBriefXML$default$1$((ToBriefXMLImpl)this);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    private String logID$lzycompute() {
        BlobUnparserBase blobUnparserBase = this;
        synchronized (blobUnparserBase) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logID = Logging.logID$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logID;
    }

    public String logID() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logID$lzycompute() : this.logID;
    }

    public Object logWriter() {
        return this.logWriter;
    }

    public void logWriter_$eq(Object x$1) {
        this.logWriter = x$1;
    }

    public Object logLevel() {
        return this.logLevel;
    }

    public void logLevel_$eq(Object x$1) {
        this.logLevel = x$1;
    }

    private String org$apache$daffodil$processors$ToBriefXMLImpl$$nom_$lzycompute() {
        BlobUnparserBase blobUnparserBase = this;
        synchronized (blobUnparserBase) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_ = ToBriefXMLImpl.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_$((ToBriefXMLImpl)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_;
    }

    public String org$apache$daffodil$processors$ToBriefXMLImpl$$nom_() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_$lzycompute() : this.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_;
    }

    public ElementRuntimeData context() {
        return this.context;
    }

    private Vector<Nothing$> runtimeDependencies$lzycompute() {
        BlobUnparserBase blobUnparserBase = this;
        synchronized (blobUnparserBase) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.runtimeDependencies = (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.runtimeDependencies;
    }

    public Vector<Nothing$> runtimeDependencies() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.runtimeDependencies$lzycompute() : this.runtimeDependencies;
    }

    public abstract long getLengthInBits(UState var1);

    public void unparse(UState state) {
        long l;
        DISimple node = state.currentInfosetNode().asSimple();
        URI value = DataValue$.MODULE$.getURI$extension(node.dataValue());
        long lengthInBits = this.getLengthInBits(state);
        long lengthInBytes = (lengthInBits + 7L) / 8L;
        String uriScheme = value.getScheme();
        String uriPath = value.getPath();
        String string = uriScheme;
        String string2 = "file";
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw UnparseError$.MODULE$.apply(Maybe.One$.MODULE$.apply((Object)this.context().schemaFileLocation()), Maybe.One$.MODULE$.apply((Object)state.currentLocation()), "Blob URI must be a file: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value.toString()}));
        }
        Path path = Paths.get(value);
        try {
            l = Files.size(path);
        }
        catch (Exception e) {
            throw UnparseError$.MODULE$.apply(Maybe.One$.MODULE$.apply((Object)this.context().schemaFileLocation()), Maybe.One$.MODULE$.apply((Object)state.currentLocation()), "Unable to open blob for reading: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value.toString()}));
        }
        long fileSizeInBytes = l;
        if (fileSizeInBytes > lengthInBytes) {
            throw UnparseError$.MODULE$.apply(Maybe.One$.MODULE$.apply((Object)this.context().schemaFileLocation()), Maybe.One$.MODULE$.apply((Object)state.currentLocation()), "Blob length (%d bits) exceeds explicit length value: %d bits", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(fileSizeInBytes * 8L)), BoxesRunTime.boxToLong((long)lengthInBits)}));
        }
        DirectOrBufferedDataOutputStream dos = state.dataOutputStream();
        DirectOrBufferedDataOutputStream newStream = dos.addBufferedBlob(path, lengthInBits, state.tunable().blobChunkSizeInBytes(), (FormatInfo)state);
        state.dataOutputStream_$eq(newStream);
        dos.setFinished((FormatInfo)state);
    }

    public BlobUnparserBase(ElementRuntimeData context) {
        this.context = context;
        ToBriefXMLImpl.$init$((ToBriefXMLImpl)this);
        Logging.$init$((Logging)this);
        Processor.$init$((Processor)this);
        Unparser.$init$((Unparser)this);
        PrimProcessor.$init$((PrimProcessor)this);
    }
}

