/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors.unparsers;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.io.DataOutputStream;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.processors.ElementRuntimeData;
import org.apache.daffodil.processors.unparsers.PackedBinaryBaseUnparser;
import org.apache.daffodil.processors.unparsers.UState;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=3Q!\u0001\u0002\u0002\u00025\u0011q\u0004U1dW\u0016$')\u001b8bef$UmY5nC2\u0014\u0015m]3V]B\f'o]3s\u0015\t\u0019A!A\u0005v]B\f'o]3sg*\u0011QAB\u0001\u000baJ|7-Z:t_J\u001c(BA\u0004\t\u0003!!\u0017M\u001a4pI&d'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0019!\u0006\u001c7.\u001a3CS:\f'/\u001f\"bg\u0016,f\u000e]1sg\u0016\u0014\b\"C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0019\u0003\u0005)\u0007CA\u000b\u0017\u001b\u0005!\u0011BA\f\u0005\u0005I)E.Z7f]R\u0014VO\u001c;j[\u0016$\u0015\r^1\n\u0005e\u0001\u0012aB2p]R,\u0007\u0010\u001e\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005I\"-\u001b8bef$UmY5nC24\u0016N\u001d;vC2\u0004v.\u001b8u!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\rIe\u000e\u001e\u0005\u0006G\u0001!\t\u0001J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u00152s\u0005\u0005\u0002\u0010\u0001!)1C\ta\u0001)!)1D\ta\u00019!)\u0011\u0006\u0001C!U\u0005qq-\u001a;Ok6\u0014WM\u001d+p!V$HCA\u00164!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003mC:<'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012aAT;nE\u0016\u0014\b\"\u0002\u001b)\u0001\u0004)\u0014AB;ti\u0006$X\r\u0005\u0002\u0010m%\u0011qG\u0001\u0002\u0007+N#\u0018\r^3\t\u000be\u0002A\u0011\t\u001e\u0002\u0013A,HOT;nE\u0016\u0014H#B\u001e?\r\"S\u0005CA\u000f=\u0013\tidDA\u0004C_>dW-\u00198\t\u000b}B\u0004\u0019\u0001!\u0002\u0007\u0011|7\u000f\u0005\u0002B\t6\t!I\u0003\u0002D\r\u0005\u0011\u0011n\\\u0005\u0003\u000b\n\u0013\u0001\u0003R1uC>+H\u000f];u'R\u0014X-Y7\t\u000b\u001dC\u0004\u0019A\u0016\u0002\r9,XNY3s\u0011\u0015I\u0005\b1\u0001\u001d\u0003\u0015q')\u001b;t\u0011\u0015Y\u0005\b1\u0001M\u0003\u00151\u0017N\u001c4p!\t\tU*\u0003\u0002O\u0005\nQai\u001c:nCRLeNZ8")
public abstract class PackedBinaryDecimalBaseUnparser
extends PackedBinaryBaseUnparser {
    private final int binaryDecimalVirtualPoint;

    @Override
    public Number getNumberToPut(UState ustate) {
        Number number = super.getNumberToPut(ustate);
        BigDecimal bigDec = (BigDecimal)number;
        if (bigDec.movePointRight(this.binaryDecimalVirtualPoint).scale() != 0) {
            throw super.context().schemaDefinitionError("Decimal point of number '%s' does not match the binaryVirtualDecmialPoint: %d", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bigDec, BoxesRunTime.boxToInteger((int)this.binaryDecimalVirtualPoint)}));
        }
        return bigDec.unscaledValue();
    }

    @Override
    public boolean putNumber(DataOutputStream dos, Number number, int nBits, FormatInfo finfo) {
        byte[] packedNum = this.fromBigInteger((BigInteger)number, nBits);
        return dos.putByteArray(packedNum, packedNum.length * 8, finfo);
    }

    public PackedBinaryDecimalBaseUnparser(ElementRuntimeData e, int binaryDecimalVirtualPoint) {
        this.binaryDecimalVirtualPoint = binaryDecimalVirtualPoint;
        super(e);
    }
}

