/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.discovery.internal;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.jaxb.JAXBContextCache;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.spi.ProviderImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.transform.InTransformReader;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.apache.cxf.ws.discovery.WSDVersion;
import org.apache.cxf.ws.discovery.WSDiscoveryClient;
import org.apache.cxf.ws.discovery.WSDiscoveryService;
import org.apache.cxf.ws.discovery.wsdl.ByeType;
import org.apache.cxf.ws.discovery.wsdl.HelloType;
import org.apache.cxf.ws.discovery.wsdl.ObjectFactory;
import org.apache.cxf.ws.discovery.wsdl.ProbeMatchType;
import org.apache.cxf.ws.discovery.wsdl.ProbeMatchesType;
import org.apache.cxf.ws.discovery.wsdl.ProbeType;
import org.apache.cxf.ws.discovery.wsdl.ResolveMatchType;
import org.apache.cxf.ws.discovery.wsdl.ResolveMatchesType;
import org.apache.cxf.ws.discovery.wsdl.ResolveType;
import org.apache.cxf.ws.discovery.wsdl.ScopesType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDiscoveryServiceImpl
implements WSDiscoveryService {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDiscoveryService.class);
    Bus bus;
    Endpoint udpEndpoint;
    WSDiscoveryClient client;
    List<HelloType> registered = new CopyOnWriteArrayList<HelloType>();
    ObjectFactory factory = new ObjectFactory();
    boolean started;

    public WSDiscoveryServiceImpl(Bus b) {
        this.bus = b == null ? BusFactory.newInstance().createBus() : b;
        this.client = new WSDiscoveryClient();
        this.update(this.bus.getProperties());
    }

    public WSDiscoveryServiceImpl() {
        this.bus = BusFactory.newInstance().createBus();
        this.client = new WSDiscoveryClient();
        this.update(this.bus.getProperties());
    }

    public WSDiscoveryServiceImpl(Bus b, Map<String, Object> props) {
        this.bus = b;
        this.client = new WSDiscoveryClient();
        this.update(props);
    }

    public final synchronized void update(Map<String, Object> props) {
        String address = (String)props.get("org.apache.cxf.service.ws-discovery.address");
        if (address != null) {
            this.client.setAddress(address);
        }
        if (this.udpEndpoint != null && !this.client.isAdHoc()) {
            this.udpEndpoint.stop();
            this.udpEndpoint = null;
            this.started = false;
        }
    }

    @Override
    public WSDiscoveryClient getClient() {
        return this.client;
    }

    @Override
    public HelloType register(EndpointReference ref) {
        this.startup(false);
        HelloType ht = this.client.register(ref);
        this.registered.add(ht);
        return ht;
    }

    @Override
    public void register(HelloType ht) {
        this.startup(false);
        this.client.register(ht);
        this.registered.add(ht);
    }

    private Object getProperty(Server server, String s) {
        Object o = server.getEndpoint().get((Object)s);
        if (o == null) {
            o = server.getEndpoint().getEndpointInfo().getProperty(s);
        }
        return o;
    }

    @Override
    public void serverStarted(Server server) {
        Object o = this.getProperty(server, "ws-discovery-disable");
        if (o == Boolean.TRUE || Boolean.valueOf((String)o).booleanValue()) {
            return;
        }
        if (!this.startup(true)) {
            return;
        }
        HelloType ht = new HelloType();
        ht.setScopes(new ScopesType());
        ht.setMetadataVersion(1L);
        o = this.getProperty(server, "ws-discovery-types");
        if (o instanceof QName) {
            ht.getTypes().add((QName)o);
        } else if (o instanceof List) {
            for (Object o2 : (List)o) {
                if (o2 instanceof QName) {
                    ht.getTypes().add((QName)o2);
                    continue;
                }
                if (!(o2 instanceof String)) continue;
                ht.getTypes().add(QName.valueOf((String)o2));
            }
        } else if (o instanceof String) {
            ht.getTypes().add(QName.valueOf((String)o));
        }
        if (ht.getTypes().isEmpty()) {
            QName sn = ServiceModelUtil.getServiceQName((EndpointInfo)server.getEndpoint().getEndpointInfo());
            ht.getTypes().add(sn);
        }
        if ((o = this.getProperty(server, "ws-discovery-scopes")) != null) {
            this.setScopes(ht, o);
        }
        this.setXAddrs(ht, server);
        String uuid = (String)this.getProperty(server, "ws-discovery-uuid");
        if (uuid != null) {
            W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
            builder.address(uuid);
            ht.setEndpointReference(builder.build());
        }
        ht = this.client.register(ht);
        this.registered.add(ht);
        server.getEndpoint().put((Object)HelloType.class.getName(), (Object)ht);
    }

    private void setXAddrs(HelloType ht, Server server) {
        String s = (String)this.getProperty(server, "ws-discovery-published-url");
        if (s == null) {
            s = (String)this.getProperty(server, "publishedEndpointUrl");
        }
        if (s == null) {
            s = server.getEndpoint().getEndpointInfo().getAddress();
        }
        if (s != null) {
            ht.getXAddrs().add(s);
        }
    }

    private void setScopes(HelloType ht, Object o) {
        if (o instanceof List) {
            List l = (List)o;
            for (Object o2 : l) {
                ht.getScopes().getValue().add(o2.toString());
            }
        } else {
            ht.getScopes().getValue().add(o.toString());
        }
    }

    @Override
    public void serverStopped(Server server) {
        HelloType ht = (HelloType)server.getEndpoint().get((Object)HelloType.class.getName());
        if (ht != null) {
            this.unregister(ht);
        }
    }

    @Override
    public void unregister(HelloType ht) {
        this.registered.remove(ht);
        this.client.unregister(ht);
    }

    public synchronized void startup() {
        this.startup(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean startup(boolean optional) {
        String preferIPv4StackValue = System.getProperty("java.net.preferIPv4Stack");
        String preferIPv6AddressesValue = System.getProperty("java.net.preferIPv6Addresses");
        if (!this.started && this.client.isAdHoc()) {
            Bus b = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
            try {
                this.udpEndpoint = new EndpointImpl(this.bus, (Object)new WSDiscoveryProvider());
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("jaxws.provider.interpretNullAsOneway", "true");
                this.udpEndpoint.setProperties(props);
                if ("true".equals(preferIPv6AddressesValue) && "false".equals(preferIPv4StackValue)) {
                    try {
                        this.udpEndpoint.publish("soap.udp://[FF02::C]:3702");
                        this.started = true;
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Could not start WS-Discovery Service with ipv6 address", e);
                    }
                }
                if (!this.started) {
                    this.udpEndpoint.publish("soap.udp://239.255.255.250:3702");
                    this.started = true;
                }
            }
            catch (RuntimeException ex) {
                if (!optional) {
                    throw ex;
                }
                LOG.log(Level.WARNING, "Could not start WS-Discovery Service.", ex);
            }
            finally {
                if (b != this.bus) {
                    BusFactory.setThreadDefaultBus((Bus)b);
                }
            }
        }
        return true;
    }

    public ProbeMatchesType handleProbe(ProbeType pt) {
        LinkedList<HelloType> consider = new LinkedList<HelloType>(this.registered);
        if (pt.getTypes() != null && !pt.getTypes().isEmpty()) {
            ListIterator cit = consider.listIterator();
            while (cit.hasNext()) {
                HelloType ht = (HelloType)cit.next();
                boolean matches = true;
                for (QName qn : pt.getTypes()) {
                    if (ht.getTypes().contains(qn)) continue;
                    matches = false;
                }
                if (matches) continue;
                cit.remove();
            }
        }
        this.matchScopes(pt, consider);
        if (consider.isEmpty()) {
            return null;
        }
        ProbeMatchesType pmt = new ProbeMatchesType();
        for (HelloType ht : consider) {
            ProbeMatchType m = new ProbeMatchType();
            m.setEndpointReference(ht.getEndpointReference());
            m.setScopes(ht.getScopes());
            m.setMetadataVersion(ht.getMetadataVersion());
            m.getTypes().addAll(ht.getTypes());
            m.getXAddrs().addAll(ht.getXAddrs());
            pmt.getProbeMatch().add(m);
        }
        return pmt;
    }

    private UUID toUUID(String scope) {
        URI uri = URI.create(scope);
        if (uri.getScheme() == null) {
            return UUID.fromString(scope);
        }
        if (uri.getScheme().equals("urn")) {
            uri = URI.create(uri.getSchemeSpecificPart());
        }
        if (uri.getScheme().equals("uuid")) {
            return UUID.fromString(uri.getSchemeSpecificPart());
        }
        return null;
    }

    private boolean compare(String s, String s2) {
        if (s != null) {
            return s.equalsIgnoreCase(s2);
        }
        return false;
    }

    private boolean matchURIs(URI probe, URI target) {
        String[] tpath;
        String[] ppath;
        if (this.compare(target.getScheme(), probe.getScheme()) && this.compare(target.getAuthority(), probe.getAuthority()) && (ppath = StringUtils.split((String)probe.getPath(), (String)"/")).length <= (tpath = StringUtils.split((String)target.getPath(), (String)"/")).length) {
            for (int i = 0; i < ppath.length; ++i) {
                if (ppath[i].equals(tpath[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void matchScopes(ProbeType pt, List<HelloType> consider) {
        if (pt.getScopes() == null || pt.getScopes().getValue().isEmpty()) {
            return;
        }
        String mb = pt.getScopes().getMatchBy();
        if (mb == null) {
            mb = "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/rfc3986";
        }
        if (mb.startsWith("http://schemas.xmlsoap.org/ws/2005/04/discovery")) {
            mb = mb.substring("http://schemas.xmlsoap.org/ws/2005/04/discovery".length());
        } else if (mb.startsWith("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01")) {
            mb = mb.substring("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01".length());
        }
        ListIterator<HelloType> cit = consider.listIterator();
        while (cit.hasNext()) {
            boolean foundOne;
            HelloType ht = cit.next();
            boolean matches = false;
            if ("/rfc3986".equals(mb)) {
                matches = true;
                if (!pt.getScopes().getValue().isEmpty()) {
                    for (String ps : pt.getScopes().getValue()) {
                        foundOne = false;
                        URI psuri = URI.create(ps);
                        for (String hts : ht.getScopes().getValue()) {
                            URI hturi = URI.create(hts);
                            if (!this.matchURIs(psuri, hturi)) continue;
                            foundOne = true;
                        }
                        matches &= foundOne;
                    }
                }
            } else if ("/uuid".equals(mb)) {
                matches = true;
                if (!pt.getScopes().getValue().isEmpty()) {
                    for (String ps : pt.getScopes().getValue()) {
                        foundOne = false;
                        UUID psuuid = this.toUUID(ps);
                        for (String hts : ht.getScopes().getValue()) {
                            UUID htuuid = this.toUUID(hts);
                            if (htuuid.equals(psuuid)) continue;
                            foundOne = true;
                        }
                        matches &= foundOne;
                    }
                }
            } else if ("/ldap".equals(mb)) {
                if (!pt.getScopes().getValue().isEmpty()) {
                    matches = false;
                }
            } else if ("/strcmp0".equals(mb)) {
                matches = true;
                if (!pt.getScopes().getValue().isEmpty()) {
                    for (String s : pt.getScopes().getValue()) {
                        if (ht.getScopes().getValue().contains(s)) continue;
                        matches = false;
                    }
                }
            } else if ("/none".equals(mb) && (ht.getScopes() == null || ht.getScopes().getValue().isEmpty())) {
                matches = true;
            }
            if (matches) continue;
            cit.remove();
        }
    }

    @WebServiceProvider(wsdlLocation="classpath:/org/apache/cxf/ws/discovery/wsdl/wsdd-discovery-1.1-wsdl-os.wsdl", targetNamespace="http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01", serviceName="Discovery", portName="DiscoveryUDP")
    @XmlSeeAlso(value={ObjectFactory.class})
    @Addressing(required=true)
    class WSDiscoveryProvider
    implements Provider<Source> {
        JAXBContext context;

        public WSDiscoveryProvider() {
            try {
                this.context = JAXBContextCache.getCachedContextAndSchemas((Class[])new Class[]{ObjectFactory.class}).getContext();
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }

        private Source mapToOld(Document doc, JAXBElement<?> mt) throws JAXBException, XMLStreamException {
            doc.removeChild(doc.getDocumentElement());
            DOMResult result = new DOMResult(doc);
            XMLStreamWriter r = StaxUtils.createXMLStreamWriter((Result)result);
            this.context.createMarshaller().marshal(mt, r);
            XMLStreamReader domReader = StaxUtils.createXMLStreamReader((Document)doc);
            HashMap<String, String> inMap = new HashMap<String, String>();
            inMap.put("{" + WSDVersion.INSTANCE_1_1.getNamespace() + "}*", "{" + WSDVersion.INSTANCE_1_0.getNamespace() + "}*");
            inMap.put("{" + WSDVersion.INSTANCE_1_1.getAddressingNamespace() + "}*", "{" + WSDVersion.INSTANCE_1_0.getAddressingNamespace() + "}*");
            InTransformReader reader = new InTransformReader(domReader, inMap, null, false);
            doc = StaxUtils.read((XMLStreamReader)reader);
            return new DOMSource(doc);
        }

        private void updateOutputAction(String append) {
            AddressingProperties p = ContextUtils.retrieveMAPs((Message)PhaseInterceptorChain.getCurrentMessage(), (boolean)false, (boolean)false);
            AddressingProperties pout = new AddressingProperties();
            AttributedURIType action = new AttributedURIType();
            action.setValue(p.getAction().getValue() + append);
            pout.exposeAs(p.getNamespaceURI());
            pout.setAction(action);
            ContextUtils.storeMAPs((AddressingProperties)pout, (Message)PhaseInterceptorChain.getCurrentMessage(), (boolean)true);
        }

        private Document mapFromOld(Document doc) throws XMLStreamException {
            XMLStreamReader domReader = StaxUtils.createXMLStreamReader((Document)doc);
            HashMap<String, String> inMap = new HashMap<String, String>();
            inMap.put("{" + WSDVersion.INSTANCE_1_0.getNamespace() + "}*", "{" + WSDVersion.INSTANCE_1_1.getNamespace() + "}*");
            inMap.put("{" + WSDVersion.INSTANCE_1_0.getAddressingNamespace() + "}*", "{" + WSDVersion.INSTANCE_1_1.getAddressingNamespace() + "}*");
            InTransformReader reader = new InTransformReader(domReader, inMap, null, false);
            doc = StaxUtils.read((XMLStreamReader)reader);
            return doc;
        }

        public Source invoke(Source request) {
            Source ret;
            block17: {
                ret = null;
                try {
                    ByeType h;
                    Document doc = StaxUtils.read((Source)request);
                    boolean mapToOld = false;
                    if ("http://schemas.xmlsoap.org/ws/2005/04/discovery".equals(doc.getDocumentElement().getNamespaceURI())) {
                        doc = this.mapFromOld(doc);
                        mapToOld = true;
                    }
                    if (!"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01".equals(doc.getDocumentElement().getNamespaceURI())) {
                        return null;
                    }
                    Object obj = JAXBUtils.unmarshall((JAXBContext)this.context, (Element)doc.getDocumentElement());
                    if (obj instanceof JAXBElement) {
                        obj = ((JAXBElement)obj).getValue();
                    }
                    if (obj instanceof ProbeType) {
                        ProbeMatchesType pmt = WSDiscoveryServiceImpl.this.handleProbe((ProbeType)obj);
                        if (pmt == null) {
                            return null;
                        }
                        this.updateOutputAction("Matches");
                        ret = mapToOld ? this.mapToOld(doc, WSDiscoveryServiceImpl.this.factory.createProbeMatches(pmt)) : new JAXBSource(this.context, WSDiscoveryServiceImpl.this.factory.createProbeMatches(pmt));
                        break block17;
                    }
                    if (obj instanceof ResolveType) {
                        ResolveMatchesType rmt = this.handleResolve((ResolveType)obj);
                        if (rmt == null) {
                            return null;
                        }
                        this.updateOutputAction("Matches");
                        ret = mapToOld ? this.mapToOld(doc, WSDiscoveryServiceImpl.this.factory.createResolveMatches(rmt)) : new JAXBSource(this.context, WSDiscoveryServiceImpl.this.factory.createResolveMatches(rmt));
                        break block17;
                    }
                    if (obj instanceof HelloType) {
                        HelloType h2 = (HelloType)obj;
                        if (h2.getTypes().contains(WSDiscoveryClient.SERVICE_QNAME) || h2.getTypes().contains(new QName("", WSDiscoveryClient.SERVICE_QNAME.getLocalPart()))) {
                            try {
                                WSDiscoveryServiceImpl.this.client.close();
                                WSDiscoveryServiceImpl.this.client = new WSDiscoveryClient(h2.getXAddrs().get(0));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        break block17;
                    }
                    if (!(obj instanceof ByeType) || !(h = (ByeType)obj).getTypes().contains(WSDiscoveryClient.SERVICE_QNAME) && !h.getTypes().contains(new QName("", WSDiscoveryClient.SERVICE_QNAME.getLocalPart()))) break block17;
                    try {
                        if (WSDiscoveryServiceImpl.this.client.getAddress().equals(h.getXAddrs().get(0))) {
                            WSDiscoveryServiceImpl.this.client.close();
                            WSDiscoveryServiceImpl.this.client = new WSDiscoveryClient();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (JAXBException e) {
                    e.printStackTrace();
                }
                catch (XMLStreamException e1) {
                    e1.printStackTrace();
                }
            }
            return ret;
        }

        private ResolveMatchesType handleResolve(ResolveType resolve) {
            ResolveMatchType rmt = new ResolveMatchType();
            W3CEndpointReference ref = resolve.getEndpointReference();
            EndpointReferenceType iref = ProviderImpl.convertToInternal((EndpointReference)ref);
            for (HelloType hello : WSDiscoveryServiceImpl.this.registered) {
                W3CEndpointReference r = hello.getEndpointReference();
                if (!this.matches(iref, r)) continue;
                rmt.setEndpointReference(r);
                rmt.setScopes(hello.getScopes());
                rmt.getTypes().addAll(hello.getTypes());
                rmt.getXAddrs().addAll(hello.getXAddrs());
                rmt.getOtherAttributes().putAll(hello.getOtherAttributes());
                rmt.setMetadataVersion(hello.getMetadataVersion());
                ResolveMatchesType rmts = new ResolveMatchesType();
                rmts.setResolveMatch(rmt);
                return rmts;
            }
            return null;
        }

        private boolean matches(EndpointReferenceType ref, W3CEndpointReference r) {
            EndpointReferenceType cref = ProviderImpl.convertToInternal((EndpointReference)r);
            QName snr = EndpointReferenceUtils.getServiceName((EndpointReferenceType)ref, (Bus)WSDiscoveryServiceImpl.this.bus);
            QName snc = EndpointReferenceUtils.getServiceName((EndpointReferenceType)cref, (Bus)WSDiscoveryServiceImpl.this.bus);
            String addr = EndpointReferenceUtils.getAddress((EndpointReferenceType)ref);
            String addc = EndpointReferenceUtils.getAddress((EndpointReferenceType)cref);
            if (addr == null) {
                return false;
            }
            if (addr.equals(addc)) {
                return snr == null || snr.equals(snc);
            }
            return false;
        }
    }
}

