/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.karaf.commands.completers;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.karaf.commands.CXFController;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;

public abstract class EndpointCompleterSupport
implements Completer {
    private CXFController cxfController;

    public void setController(CXFController controller) {
        this.cxfController = controller;
    }

    public int complete(String buffer, int cursor, List candidates) {
        StringsCompleter delegate = new StringsCompleter();
        try {
            List<Bus> busses = this.cxfController.getBusses();
            for (Bus b : busses) {
                ServerRegistry reg = (ServerRegistry)b.getExtension(ServerRegistry.class);
                List servers = reg.getServers();
                for (Server serv : servers) {
                    if (!this.acceptsFeature(serv)) continue;
                    String qname = serv.getEndpoint().getEndpointInfo().getName().getLocalPart();
                    delegate.getStrings().add(qname);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return delegate.complete(buffer, cursor, candidates);
    }

    protected abstract boolean acceptsFeature(Server var1);
}

