/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.karaf.commands;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.CXFBusImpl;
import org.apache.cxf.karaf.commands.CXFController;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="cxf", name="list-busses", description="Lists all CXF Busses.")
public class ListBussesCommand
extends OsgiCommandSupport {
    protected static final int DEFAULT_BUSID_LENGTH = 38;
    protected String headerFormat = "%-40s %-20s";
    protected String outputFormat = "[%-38s] [%-18s]";
    private CXFController cxfController;

    public void setController(CXFController controller) {
        this.cxfController = controller;
    }

    protected Object doExecute() throws Exception {
        List<Bus> busses = this.cxfController.getBusses();
        this.renderFormat(busses);
        System.out.println(String.format(this.headerFormat, "Name", "State"));
        for (Bus bus : busses) {
            String state = "";
            if (bus instanceof CXFBusImpl) {
                state = ((CXFBusImpl)bus).getState().toString();
            }
            System.out.println(String.format(this.outputFormat, bus.getId(), state));
        }
        return null;
    }

    private void renderFormat(List<Bus> busses) {
        int longestBusId = 38;
        for (Bus bus : busses) {
            if (bus.getId().length() <= longestBusId) continue;
            longestBusId = bus.getId().length();
        }
        if (longestBusId > 38) {
            this.headerFormat = "%-" + (longestBusId + 2) + "s %-20s";
            this.outputFormat = "[%-" + longestBusId + "s] [%-18s]";
        }
    }
}

