/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.samlsso.example;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collections;
import java.util.zip.DataFormatException;
import javax.security.auth.callback.CallbackHandler;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.fediz.samlsso.example.SAML2CallbackHandler;
import org.apache.cxf.fediz.samlsso.example.SAML2PResponseComponentBuilder;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.AudienceRestrictionBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.SubjectConfirmationDataBean;
import org.apache.wss4j.common.util.DOM2Writer;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Path(value="/samlsso")
public class SamlSso {
    private final DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private MessageContext messageContext;

    public SamlSso() {
        this.docBuilderFactory.setNamespaceAware(true);
    }

    @POST
    public Response login(@FormParam(value="SAMLRequest") String samlRequest, @FormParam(value="RelayState") String relayState) throws Exception {
        return this.login(samlRequest, relayState, "POST");
    }

    @GET
    public Response login(@QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="RelayState") String relayState, @QueryParam(value="binding") String binding) throws Exception {
        AuthnRequest request = this.extractRequest(samlRequest);
        String racs = request.getAssertionConsumerServiceURL();
        String requestIssuer = request.getIssuer().getValue();
        Element response = this.createResponse(request.getID(), racs, requestIssuer);
        boolean redirect = "REDIRECT".equals(binding);
        String responseStr = this.encodeResponse(response, redirect);
        if (redirect) {
            return this.redirectResponse(relayState, racs, responseStr);
        }
        return this.postBindingResponse(relayState, racs, responseStr);
    }

    @Context
    public void setMessageContext(MessageContext mc) {
        this.messageContext = mc;
    }

    protected Element createResponse(String requestID, String racs, String requestIssuer) throws Exception {
        DocumentBuilder docBuilder = this.docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Status status = SAML2PResponseComponentBuilder.createStatus((String)"urn:oasis:names:tc:SAML:2.0:status:Success", null);
        String issuer = this.messageContext.getUriInfo().getAbsolutePath().toString();
        org.opensaml.saml.saml2.core.Response response = SAML2PResponseComponentBuilder.createSAMLResponse((String)requestID, (String)issuer, (Status)status);
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setIssuer(issuer);
        String user = this.messageContext.getSecurityContext().getUserPrincipal().getName();
        callbackHandler.setSubjectName(user);
        SubjectConfirmationDataBean subjectConfirmationData = new SubjectConfirmationDataBean();
        subjectConfirmationData.setAddress(this.messageContext.getHttpServletRequest().getRemoteAddr());
        subjectConfirmationData.setInResponseTo(requestID);
        subjectConfirmationData.setNotAfter(new DateTime().plusMinutes(5));
        subjectConfirmationData.setRecipient(racs);
        callbackHandler.setSubjectConfirmationData(subjectConfirmationData);
        ConditionsBean conditions = new ConditionsBean();
        conditions.setTokenPeriodMinutes(5);
        AudienceRestrictionBean audienceRestriction = new AudienceRestrictionBean();
        audienceRestriction.setAudienceURIs(Collections.singletonList(requestIssuer));
        conditions.setAudienceRestrictions(Collections.singletonList(audienceRestriction));
        callbackHandler.setConditions(conditions);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper assertion = new SamlAssertionWrapper(samlCallback);
        Crypto issuerCrypto = CryptoFactory.getInstance((String)"stsKeystoreB.properties");
        assertion.signAssertion("realmb", "realmb", issuerCrypto, false);
        response.getAssertions().add(assertion.getSaml2());
        Element policyElement = OpenSAMLUtil.toDom((XMLObject)response, (Document)doc);
        doc.appendChild(policyElement);
        return policyElement;
    }

    protected String encodeResponse(Element response, boolean redirect) throws IOException {
        String responseMessage = DOM2Writer.nodeToString((Node)response);
        System.out.println("RESP: " + responseMessage);
        byte[] deflatedBytes = null;
        if (redirect) {
            DeflateEncoderDecoder encoder = new DeflateEncoderDecoder();
            deflatedBytes = encoder.deflateToken(responseMessage.getBytes("UTF-8"));
        } else {
            deflatedBytes = responseMessage.getBytes("UTF-8");
        }
        return Base64Utility.encode((byte[])deflatedBytes);
    }

    protected AuthnRequest extractRequest(String samlRequest) throws Base64Exception, DataFormatException, XMLStreamException, UnsupportedEncodingException, WSSecurityException {
        byte[] deflatedToken = Base64Utility.decode((String)samlRequest);
        InputStream tokenStream = new DeflateEncoderDecoder().inflateToken(deflatedToken);
        Document responseDoc = StaxUtils.read((Reader)new InputStreamReader(tokenStream, "UTF-8"));
        AuthnRequest request = (AuthnRequest)OpenSAMLUtil.fromDom((Element)responseDoc.getDocumentElement());
        System.out.println(DOM2Writer.nodeToString((Node)responseDoc));
        return request;
    }

    protected Response postBindingResponse(String relayState, String racs, String responseStr) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("/TemplateSAMLResponse.xml");
        String responseTemplate = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        inputStream.close();
        responseTemplate = responseTemplate.replace("%RESPONSE_URL%", racs);
        responseTemplate = responseTemplate.replace("%SAMLResponse%", responseStr);
        responseTemplate = responseTemplate.replace("%RelayState%", relayState);
        return Response.ok((Object)responseTemplate).type("text/html").build();
    }

    protected Response redirectResponse(String relayState, String racs, String responseStr) {
        UriBuilder ub = UriBuilder.fromUri((String)racs);
        ub.queryParam("SAMLResponse", new Object[]{responseStr});
        ub.queryParam("RelayState", new Object[]{relayState});
        return Response.seeOther((URI)ub.build(new Object[0])).build();
    }

    static {
        OpenSAMLUtil.initSamlEngine();
    }
}

