/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.samlsso.example;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.callback.CallbackHandler;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.apache.wss4j.common.principal.WSUsernameTokenPrincipalImpl;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.UsernameTokenValidator;
import org.w3c.dom.Document;

public class BasicAuthFilter
implements ContainerRequestFilter {
    private CallbackHandler callbackHandler;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Message message = JAXRSUtils.getCurrentMessage();
        AuthorizationPolicy policy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class);
        if (policy == null || policy.getUserName() == null || policy.getPassword() == null) {
            requestContext.abortWith(Response.status((int)401).header("WWW-Authenticate", (Object)"Basic realm=\"IdP\"").build());
            return;
        }
        try {
            UsernameToken token = this.convertPolicyToToken(policy);
            Credential credential = new Credential();
            credential.setUsernametoken(token);
            RequestData data = new RequestData();
            data.setMsgContext((Object)message);
            data.setCallbackHandler(this.callbackHandler);
            UsernameTokenValidator validator = new UsernameTokenValidator();
            credential = validator.validate(credential, data);
            Principal p = null;
            if (credential != null && credential.getPrincipal() != null) {
                p = credential.getPrincipal();
            } else {
                p = new WSUsernameTokenPrincipalImpl(policy.getUserName(), false);
                ((WSUsernameTokenPrincipalImpl)p).setPassword(policy.getPassword());
            }
            message.put(SecurityContext.class, (Object)this.createSecurityContext(p));
        }
        catch (Exception ex) {
            requestContext.abortWith(Response.status((int)401).header("WWW-Authenticate", (Object)"Basic realm=\"IdP\"").build());
        }
    }

    protected UsernameToken convertPolicyToToken(AuthorizationPolicy policy) throws Exception {
        Document doc = DOMUtils.createDocument();
        UsernameToken token = new UsernameToken(false, doc, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        token.setName(policy.getUserName());
        token.setPassword(policy.getPassword());
        return token;
    }

    protected SecurityContext createSecurityContext(Principal p) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    static {
        WSSConfig.init();
    }
}

