/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.samlsso.example;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Collections;
import javax.security.auth.callback.CallbackHandler;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.fediz.samlsso.example.SAML2CallbackHandler;
import org.apache.cxf.fediz.samlsso.example.SAML2PResponseComponentBuilder;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.AudienceRestrictionBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.SubjectConfirmationDataBean;
import org.apache.wss4j.common.util.DOM2Writer;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Status;
import org.opensaml.xml.XMLObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Path(value="/samlsso")
public class SamlSso {
    private final DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private MessageContext messageContext;

    public SamlSso() {
        this.docBuilderFactory.setNamespaceAware(true);
    }

    @GET
    public Response login(@QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="RelayState") String relayState) throws Exception {
        byte[] deflatedToken = Base64Utility.decode((String)samlRequest);
        InputStream tokenStream = new DeflateEncoderDecoder().inflateToken(deflatedToken);
        Document responseDoc = StaxUtils.read((Reader)new InputStreamReader(tokenStream, "UTF-8"));
        AuthnRequest request = (AuthnRequest)OpenSAMLUtil.fromDom((Element)responseDoc.getDocumentElement());
        System.out.println(DOM2Writer.nodeToString((Node)responseDoc));
        String racs = request.getAssertionConsumerServiceURL();
        String requestIssuer = request.getIssuer().getValue();
        Element response = this.createResponse(request.getID(), racs, requestIssuer);
        String responseStr = this.encodeResponse(response);
        UriBuilder ub = UriBuilder.fromUri((String)racs);
        ub.queryParam("SAMLResponse", new Object[]{responseStr});
        ub.queryParam("RelayState", new Object[]{relayState});
        return Response.seeOther((URI)ub.build(new Object[0])).build();
    }

    @Context
    public void setMessageContext(MessageContext mc) {
        this.messageContext = mc;
    }

    private Element createResponse(String requestID, String racs, String requestIssuer) throws Exception {
        DocumentBuilder docBuilder = this.docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Status status = SAML2PResponseComponentBuilder.createStatus((String)"urn:oasis:names:tc:SAML:2.0:status:Success", null);
        String issuer = this.messageContext.getUriInfo().getAbsolutePath().toString();
        org.opensaml.saml2.core.Response response = SAML2PResponseComponentBuilder.createSAMLResponse((String)requestID, (String)issuer, (Status)status);
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setIssuer(issuer);
        String user = this.messageContext.getSecurityContext().getUserPrincipal().getName();
        callbackHandler.setSubjectName(user);
        SubjectConfirmationDataBean subjectConfirmationData = new SubjectConfirmationDataBean();
        subjectConfirmationData.setAddress(this.messageContext.getHttpServletRequest().getRemoteAddr());
        subjectConfirmationData.setInResponseTo(requestID);
        subjectConfirmationData.setNotAfter(new DateTime().plusMinutes(5));
        subjectConfirmationData.setRecipient(racs);
        callbackHandler.setSubjectConfirmationData(subjectConfirmationData);
        ConditionsBean conditions = new ConditionsBean();
        conditions.setTokenPeriodMinutes(5);
        AudienceRestrictionBean audienceRestriction = new AudienceRestrictionBean();
        audienceRestriction.setAudienceURIs(Collections.singletonList(requestIssuer));
        conditions.setAudienceRestrictions(Collections.singletonList(audienceRestriction));
        callbackHandler.setConditions(conditions);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper assertion = new SamlAssertionWrapper(samlCallback);
        Crypto issuerCrypto = CryptoFactory.getInstance((String)"stsKeystoreB.properties");
        assertion.signAssertion("realmb", "realmb", issuerCrypto, false);
        response.getAssertions().add(assertion.getSaml2());
        Element policyElement = OpenSAMLUtil.toDom((XMLObject)response, (Document)doc);
        doc.appendChild(policyElement);
        return policyElement;
    }

    private String encodeResponse(Element response) throws IOException {
        String responseMessage = DOM2Writer.nodeToString((Node)response);
        System.out.println("RESP: " + responseMessage);
        DeflateEncoderDecoder encoder = new DeflateEncoderDecoder();
        byte[] deflatedBytes = encoder.deflateToken(responseMessage.getBytes("UTF-8"));
        return Base64Utility.encode((byte[])deflatedBytes);
    }

    static {
        OpenSAMLUtil.initSamlEngine();
    }
}

