/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.samlsso.example;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.bean.AttributeBean;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;
import org.apache.wss4j.common.saml.bean.AuthenticationStatementBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.apache.wss4j.common.saml.bean.SubjectConfirmationDataBean;
import org.opensaml.common.SAMLVersion;

public class SAML2CallbackHandler
implements CallbackHandler {
    private String subjectName;
    private String subjectQualifier;
    private String confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    private String issuer;
    private String subjectNameIDFormat;
    private ConditionsBean conditions;
    private SubjectConfirmationDataBean subjectConfirmationData;

    private void createAndSetStatement(SAMLCallback callback) {
        AuthenticationStatementBean authBean = new AuthenticationStatementBean();
        authBean.setAuthenticationMethod("Password");
        callback.setAuthenticationStatementData(Collections.singletonList(authBean));
        ArrayList<String> roles = new ArrayList<String>();
        if ("alice".equals(this.subjectName)) {
            roles.add("boss");
            roles.add("employee");
            roles.add("User");
        } else if ("bob".equals(this.subjectName)) {
            roles.add("employee");
        }
        if (!roles.isEmpty()) {
            AttributeStatementBean attrBean = new AttributeStatementBean();
            AttributeBean attributeBean = new AttributeBean();
            attributeBean.setQualifiedName("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role");
            attributeBean.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
            attributeBean.setAttributeValues(roles);
            attrBean.setSamlAttributes(Collections.singletonList(attributeBean));
            callback.setAttributeStatementData(Collections.singletonList(attrBean));
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            SubjectBean subjectBean;
            SAMLCallback callback;
            if (callbacks[i] instanceof SAMLCallback) {
                callback = (SAMLCallback)callbacks[i];
                callback.setSamlVersion(SAMLVersion.VERSION_20);
                callback.setIssuer(this.issuer);
                if (this.conditions != null) {
                    callback.setConditions(this.conditions);
                }
                subjectBean = new SubjectBean(this.subjectName, this.subjectQualifier, this.confirmationMethod);
                if (this.subjectNameIDFormat != null) {
                    subjectBean.setSubjectNameIDFormat(this.subjectNameIDFormat);
                }
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            subjectBean.setSubjectConfirmationData(this.subjectConfirmationData);
            callback.setSubject(subjectBean);
            this.createAndSetStatement(callback);
        }
    }

    public void setSubjectConfirmationData(SubjectConfirmationDataBean subjectConfirmationData) {
        this.subjectConfirmationData = subjectConfirmationData;
    }

    public void setConditions(ConditionsBean conditionsBean) {
        this.conditions = conditionsBean;
    }

    public void setConfirmationMethod(String confMethod) {
        this.confirmationMethod = confMethod;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setSubjectNameIDFormat(String subjectNameIDFormat) {
        this.subjectNameIDFormat = subjectNameIDFormat;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSubjectQualifier() {
        return this.subjectQualifier;
    }

    public void setSubjectQualifier(String subjectQualifier) {
        this.subjectQualifier = subjectQualifier;
    }
}

