/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.tomcat7.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.cxf.fediz.core.FedizPrincipal;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.handler.SigninHandler;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.apache.cxf.fediz.tomcat7.FederationPrincipalImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatSigninHandler
extends SigninHandler<FedizPrincipal> {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatSigninHandler.class);
    private Object landingPage;

    public TomcatSigninHandler(FedizContext fedizContext) {
        super(fedizContext);
    }

    protected FedizPrincipal createPrincipal(HttpServletRequest request, HttpServletResponse response, FedizResponse wfRes) {
        List<String> roles = wfRes.getRoles();
        if (roles == null || roles.isEmpty()) {
            roles = Collections.singletonList("Authenticated");
        } else if (this.getFedizContext().isAddAuthenticatedRole()) {
            roles = new ArrayList<String>(roles);
            roles.add("Authenticated");
        }
        FederationPrincipalImpl principal = new FederationPrincipalImpl(wfRes.getUsername(), roles, wfRes.getClaims(), wfRes.getToken());
        Session session = ((Request)request).getSessionInternal();
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", (Object)principal);
        session.setNote("org.apache.cxf.fediz.tomcat.FEDERATION", (Object)wfRes);
        request.getSession(true).setAttribute("org.apache.fediz.SECURITY_TOKEN", (Object)wfRes.getToken());
        LOG.debug("UserPrincipal was created successfully for {}", (Object)principal);
        return principal;
    }

    public Object getLandingPage() {
        return this.landingPage;
    }

    public void setLandingPage(Object landingPage) {
        this.landingPage = landingPage;
    }
}

