/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.handler;

import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.fediz.core.config.FederationProtocol;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.SAMLProtocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.handler.RequestHandler;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.FedizRequest;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigninHandler<T>
implements RequestHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SigninHandler.class);
    private final FedizContext fedizContext;

    public SigninHandler(FedizContext fedizContext) {
        this.fedizContext = fedizContext;
    }

    @Override
    public boolean canHandleRequest(HttpServletRequest request) {
        if (this.fedizContext.getProtocol() instanceof FederationProtocol && "wsignin1.0".equals(request.getParameter("wa"))) {
            return true;
        }
        return this.fedizContext.getProtocol() instanceof SAMLProtocol && request.getParameter("RelayState") != null;
    }

    @Override
    public T handleRequest(HttpServletRequest request, HttpServletResponse response) {
        if (request.getMethod().equals("POST")) {
            LOG.debug("Sign-In-Response received");
            String responseToken = this.getResponseToken(request);
            if (responseToken != null) {
                LOG.debug("Validating RSTR...");
                try {
                    FedizResponse federationResponse = this.processSigninRequest(responseToken, request, response);
                    if (!this.validateAudienceRestrictions(federationResponse.getAudience(), request.getRequestURL().toString())) {
                        return null;
                    }
                    LOG.debug("RSTR validated successfully");
                    return this.createPrincipal(request, response, federationResponse);
                }
                catch (ProcessingException e) {
                    LOG.error("Federation processing failed: " + e.getMessage());
                }
            }
        } else {
            throw new RuntimeException("Incorrect method GET for Sign-In-Response");
        }
        return null;
    }

    protected T createPrincipal(HttpServletRequest request, HttpServletResponse response, FedizResponse federationResponse) {
        return null;
    }

    public FedizResponse processSigninRequest(String responseToken, HttpServletRequest req, HttpServletResponse resp) throws ProcessingException {
        LOG.debug("Process SignIn request");
        LOG.debug("token=\n{}", (Object)responseToken);
        FedizRequest federationRequest = new FedizRequest();
        String wa = req.getParameter("wa");
        federationRequest.setAction(wa);
        federationRequest.setResponseToken(responseToken);
        federationRequest.setState(req.getParameter("RelayState"));
        federationRequest.setRequest(req);
        federationRequest.setCerts((X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate"));
        FedizProcessor processor = FedizProcessorFactory.newFedizProcessor(this.fedizContext.getProtocol());
        return processor.processRequest(federationRequest, this.fedizContext);
    }

    protected boolean validateAudienceRestrictions(String audience, String requestURL) {
        boolean validAudience;
        List<String> audienceURIs = this.fedizContext.getAudienceUris();
        boolean bl = validAudience = audienceURIs.isEmpty() && audience == null;
        if (!validAudience && audience != null) {
            for (String a : audienceURIs) {
                if (!audience.startsWith(a)) continue;
                validAudience = true;
                LOG.debug("Token audience matches with valid URIs.");
                break;
            }
            if (!validAudience) {
                LOG.warn("Token AudienceRestriction [{}] doesn't match with specified list of URIs.", (Object)audience);
                LOG.debug("Authenticated URIs are: {}", audienceURIs);
            }
            if (LOG.isDebugEnabled() && requestURL != null && requestURL.indexOf(audience) == -1) {
                LOG.debug("Token AudienceRestriction doesn't match with request URL [{}]  [{}]", (Object)audience, (Object)requestURL);
            }
        }
        return validAudience;
    }

    public String getResponseToken(HttpServletRequest request) {
        String token = null;
        if (this.fedizContext.getProtocol() instanceof FederationProtocol) {
            token = request.getParameter("wresult");
            if (token == null) {
                throw new RuntimeException("Missing required parameter 'wresult'");
            }
        } else if (this.fedizContext.getProtocol() instanceof SAMLProtocol && (token = request.getParameter("SAMLResponse")) == null) {
            throw new RuntimeException("Missing required parameter 'SAMLResponse'");
        }
        return token;
    }

    public FedizContext getFedizContext() {
        return this.fedizContext;
    }
}

