/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.config;

import java.util.regex.Pattern;
import org.apache.cxf.fediz.core.config.CertificateValidationMethod;
import org.apache.cxf.fediz.core.config.jaxb.TrustedIssuerType;
import org.apache.cxf.fediz.core.config.jaxb.ValidationType;

public class TrustedIssuer {
    private final TrustedIssuerType trustedIssuerType;
    private Pattern subject;

    public TrustedIssuer(TrustedIssuerType trustedIssuerType) {
        this.trustedIssuerType = trustedIssuerType;
    }

    public String getName() {
        return this.trustedIssuerType.getName();
    }

    public void setName(String name) {
        this.trustedIssuerType.setName(name);
    }

    public Pattern getCompiledSubject() {
        if (this.subject != null) {
            return this.subject;
        }
        if (this.trustedIssuerType.getSubject() != null) {
            this.subject = Pattern.compile(this.trustedIssuerType.getSubject());
        }
        return this.subject;
    }

    public String getSubject() {
        return this.trustedIssuerType.getSubject();
    }

    public void setSubject(String subject) {
        this.trustedIssuerType.setSubject(subject);
        this.subject = null;
    }

    public CertificateValidationMethod getCertificateValidationMethod() {
        ValidationType certificateValidation = this.trustedIssuerType.getCertificateValidation();
        if (ValidationType.CHAIN_TRUST.equals((Object)certificateValidation)) {
            return CertificateValidationMethod.CHAIN_TRUST;
        }
        if (ValidationType.PEER_TRUST.equals((Object)certificateValidation)) {
            return CertificateValidationMethod.PEER_TRUST;
        }
        throw new IllegalStateException("Not supported certificate validation type: " + certificateValidation.value());
    }

    public void setCertificateValidationMethod(CertificateValidationMethod validationMethod) {
        if (CertificateValidationMethod.CHAIN_TRUST.equals((Object)validationMethod)) {
            this.trustedIssuerType.setCertificateValidation(ValidationType.CHAIN_TRUST);
        } else if (CertificateValidationMethod.PEER_TRUST.equals((Object)validationMethod)) {
            this.trustedIssuerType.setCertificateValidation(ValidationType.PEER_TRUST);
        } else {
            String error = "Not supported certificate validation type";
            if (validationMethod != null) {
                error = error + ": " + validationMethod.value();
            }
            throw new IllegalStateException(error);
        }
    }

    public int hashCode() {
        return this.trustedIssuerType.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TrustedIssuer)) {
            return false;
        }
        TrustedIssuer that = (TrustedIssuer)obj;
        if (this.trustedIssuerType != null && !this.trustedIssuerType.equals(that.getTrustedIssuerType())) {
            return false;
        }
        return this.trustedIssuerType != null || that.getTrustedIssuerType() == null;
    }

    public String toString() {
        return this.trustedIssuerType.toString();
    }

    public TrustedIssuerType getTrustedIssuerType() {
        return this.trustedIssuerType;
    }
}

