/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.config;

import java.util.ArrayList;
import org.apache.cxf.fediz.core.config.jaxb.ArgumentType;
import org.apache.cxf.fediz.core.config.jaxb.CallbackType;
import org.apache.cxf.fediz.core.util.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUtils.class);

    private ConfigUtils() {
    }

    public static Object loadCallbackType(CallbackType cbt, String name, ClassLoader classLoader) {
        if (cbt == null || cbt.getValue() == null) {
            return null;
        }
        if (cbt.getType() == null || cbt.getType().equals((Object)ArgumentType.STRING)) {
            return cbt.getValue();
        }
        if (cbt.getType().equals((Object)ArgumentType.CLASS)) {
            String[] cbtHandler;
            ArrayList handler = new ArrayList();
            for (String cbh : cbtHandler = cbt.getValue().split(",")) {
                try {
                    if (classLoader == null) {
                        handler.add(ClassLoaderUtils.loadClass(cbh, ConfigUtils.class).newInstance());
                        continue;
                    }
                    handler.add(classLoader.loadClass(cbh).newInstance());
                }
                catch (Exception e) {
                    LOG.error("Failed to create instance of " + cbh, (Throwable)e);
                }
            }
            if (handler.size() == 1) {
                return handler.get(0);
            }
            return handler;
        }
        LOG.error("Only String and Class are supported for '{}'", (Object)name);
        throw new IllegalStateException("Only String and Class are supported for '" + name + "'");
    }
}

