/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.processor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.zip.DataFormatException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.fediz.core.RequestState;
import org.apache.cxf.fediz.core.TokenValidator;
import org.apache.cxf.fediz.core.TokenValidatorRequest;
import org.apache.cxf.fediz.core.TokenValidatorResponse;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.SAMLProtocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.metadata.MetadataWriter;
import org.apache.cxf.fediz.core.processor.AbstractFedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizRequest;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.apache.cxf.fediz.core.processor.RedirectionResponse;
import org.apache.cxf.fediz.core.samlsso.CompressionUtils;
import org.apache.cxf.fediz.core.samlsso.SAMLPRequestBuilder;
import org.apache.cxf.fediz.core.samlsso.SAMLProtocolResponseValidator;
import org.apache.cxf.fediz.core.samlsso.SAMLSSOResponseValidator;
import org.apache.cxf.fediz.core.samlsso.SSOValidatorResponse;
import org.apache.cxf.fediz.core.util.DOMUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLProcessorImpl
extends AbstractFedizProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLProcessorImpl.class);

    @Override
    public FedizResponse processRequest(FedizRequest request, FedizContext config) throws ProcessingException {
        if (!(config.getProtocol() instanceof SAMLProtocol)) {
            LOG.error("Unsupported protocol");
            throw new IllegalStateException("Unsupported protocol");
        }
        if (request.getResponseToken() == null || request.getState() == null) {
            LOG.error("Missing response token or RelayState parameters");
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        return this.processSignInRequest(request, config);
    }

    @Override
    public Document getMetaData(HttpServletRequest request, FedizContext config) throws ProcessingException {
        return new MetadataWriter().getMetaData(request, config);
    }

    private RequestState processRelayState(String relayState, RequestState requestState) throws ProcessingException {
        if (relayState.getBytes().length <= 0 || relayState.getBytes().length > 80) {
            LOG.error("Invalid RelayState");
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        if (requestState == null) {
            LOG.error("Missing Request State");
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        return requestState;
    }

    protected FedizResponse processSignInRequest(FedizRequest request, FedizContext config) throws ProcessingException {
        SAMLProtocol protocol = (SAMLProtocol)config.getProtocol();
        RequestState requestState = this.processRelayState(request.getState(), request.getRequestState());
        InputStream tokenStream = null;
        try {
            byte[] deflatedToken = Base64.decode((String)request.getResponseToken());
            tokenStream = protocol.isDisableDeflateEncoding() ? new ByteArrayInputStream(deflatedToken) : CompressionUtils.inflate(deflatedToken);
        }
        catch (DataFormatException ex) {
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        catch (Base64DecodingException e) {
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        Document doc = null;
        Element el = null;
        try {
            doc = DOMUtils.readXml(tokenStream);
            el = doc.getDocumentElement();
        }
        catch (Exception e) {
            LOG.warn("Failed to parse token: " + e.getMessage());
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        LOG.debug("Received response: " + DOM2Writer.nodeToString((Node)el));
        XMLObject responseObject = null;
        try {
            responseObject = OpenSAMLUtil.fromDom((Element)el);
        }
        catch (WSSecurityException ex) {
            LOG.debug(ex.getMessage(), (Throwable)ex);
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        if (!(responseObject instanceof Response)) {
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        this.validateSamlResponseProtocol((Response)responseObject, config);
        SSOValidatorResponse ssoValidatorResponse = this.validateSamlSSOResponse((Response)responseObject, request.getRequest(), requestState, config);
        TokenValidatorResponse validatorResponse = null;
        List<Element> assertions = DOMUtils.getChildrenWithName(el, "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        if (assertions.isEmpty()) {
            LOG.debug("No Assertion extracted from SAML Response");
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        Element token = assertions.get(0);
        List<TokenValidator> validators = protocol.getTokenValidators();
        Iterator<TokenValidator> i$ = validators.iterator();
        if (i$.hasNext()) {
            TokenValidator validator = i$.next();
            boolean canHandle = validator.canHandleToken(token);
            if (canHandle) {
                try {
                    TokenValidatorRequest validatorRequest = new TokenValidatorRequest(token, request.getCerts());
                    validatorResponse = validator.validateAndProcessToken(validatorRequest, config);
                }
                catch (ProcessingException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    LOG.warn("Failed to validate token", (Throwable)ex);
                    throw new ProcessingException(ProcessingException.TYPE.TOKEN_INVALID);
                }
            } else {
                LOG.warn("No security token validator found for '" + token.getLocalName() + "'");
                throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
            }
        }
        if (validatorResponse == null) {
            LOG.warn("No token validation response was available");
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        Date expires = validatorResponse.getExpires();
        if (expires == null) {
            expires = ssoValidatorResponse.getSessionNotOnOrAfter();
        }
        this.testForReplayAttack(validatorResponse.getUniqueTokenId(), config, expires);
        FedizResponse fedResponse = new FedizResponse(validatorResponse.getUsername(), validatorResponse.getIssuer(), validatorResponse.getRoles(), validatorResponse.getClaims(), validatorResponse.getAudience(), validatorResponse.getCreated(), expires, token, validatorResponse.getUniqueTokenId());
        return fedResponse;
    }

    protected void validateSamlResponseProtocol(Response samlResponse, FedizContext config) throws ProcessingException {
        try {
            SAMLProtocolResponseValidator protocolValidator = new SAMLProtocolResponseValidator();
            protocolValidator.validateSamlResponse(samlResponse, config);
        }
        catch (WSSecurityException ex) {
            LOG.debug(ex.getMessage(), (Throwable)ex);
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
    }

    protected SSOValidatorResponse validateSamlSSOResponse(Response samlResponse, HttpServletRequest request, RequestState requestState, FedizContext config) throws ProcessingException {
        try {
            SAMLSSOResponseValidator ssoResponseValidator = new SAMLSSOResponseValidator();
            String requestURL = request.getRequestURL().toString();
            ssoResponseValidator.setAssertionConsumerURL(requestURL);
            ssoResponseValidator.setClientAddress(request.getRemoteAddr());
            boolean doNotEnforceKnownIssuer = ((SAMLProtocol)config.getProtocol()).isDoNotEnforceKnownIssuer();
            ssoResponseValidator.setEnforceKnownIssuer(!doNotEnforceKnownIssuer);
            ssoResponseValidator.setIssuerIDP(requestState.getIdpServiceAddress());
            ssoResponseValidator.setRequestId(requestState.getRequestId());
            ssoResponseValidator.setSpIdentifier(requestState.getIssuerId());
            ssoResponseValidator.setEnforceAssertionsSigned(true);
            ssoResponseValidator.setReplayCache(config.getTokenReplayCache());
            return ssoResponseValidator.validateSamlResponse(samlResponse, false);
        }
        catch (WSSecurityException ex) {
            LOG.debug(ex.getMessage(), (Throwable)ex);
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
    }

    @Override
    public RedirectionResponse createSignInRequest(HttpServletRequest request, FedizContext config) throws ProcessingException {
        String redirectURL = null;
        try {
            if (!(config.getProtocol() instanceof SAMLProtocol)) {
                LOG.error("Unsupported protocol");
                throw new IllegalStateException("Unsupported protocol");
            }
            String issuerURL = this.resolveIssuer(request, config);
            LOG.info("Issuer url: " + issuerURL);
            if (issuerURL != null && issuerURL.length() > 0) {
                redirectURL = issuerURL;
            }
            SAMLPRequestBuilder samlpRequestBuilder = ((SAMLProtocol)config.getProtocol()).getSAMLPRequestBuilder();
            Document doc = DOMUtils.createDocument();
            doc.appendChild(doc.createElement("root"));
            String requestURL = request.getRequestURL().toString();
            String realm = this.resolveWTRealm(request, config);
            AuthnRequest authnRequest = samlpRequestBuilder.createAuthnRequest(realm, requestURL);
            if (((SAMLProtocol)config.getProtocol()).isSignRequest()) {
                authnRequest.setDestination(redirectURL);
            }
            Element authnRequestElement = OpenSAMLUtil.toDom((XMLObject)authnRequest, (Document)doc);
            String authnRequestEncoded = this.encodeAuthnRequest(authnRequestElement);
            String relayState = URLEncoder.encode(UUID.randomUUID().toString(), "UTF-8");
            RequestState requestState = new RequestState();
            requestState.setTargetAddress(requestURL);
            requestState.setIdpServiceAddress(redirectURL);
            requestState.setRequestId(authnRequest.getID());
            requestState.setIssuerId(realm);
            requestState.setWebAppContext(authnRequest.getIssuer().getValue());
            requestState.setState(relayState);
            requestState.setCreatedAt(System.currentTimeMillis());
            String urlEncodedRequest = URLEncoder.encode(authnRequestEncoded, "UTF-8");
            StringBuilder sb = new StringBuilder();
            sb.append("SAMLRequest").append('=').append(urlEncodedRequest);
            sb.append("&RelayState").append('=').append(relayState);
            if (((SAMLProtocol)config.getProtocol()).isSignRequest()) {
                String signature = this.signRequest(config, sb);
                sb.append("&Signature").append('=').append(signature);
            }
            RedirectionResponse response = new RedirectionResponse();
            response.addHeader("Cache-Control", "no-cache, no-store");
            response.addHeader("Pragma", "no-cache");
            response.setRequestState(requestState);
            redirectURL = redirectURL + "?" + sb.toString();
            response.setRedirectionURL(redirectURL);
            return response;
        }
        catch (Exception ex) {
            LOG.error("Failed to create SignInRequest", (Throwable)ex);
            throw new ProcessingException("Failed to create SignInRequest");
        }
    }

    private String signRequest(FedizContext config, StringBuilder sb) throws Exception {
        Crypto crypto = config.getSigningKey().getCrypto();
        if (crypto == null) {
            LOG.debug("No crypto instance of properties file configured for signature");
            throw new ProcessingException("Failed to Sign Request");
        }
        String signatureUser = config.getSigningKey().getKeyAlias();
        if (signatureUser == null) {
            LOG.debug("No user configured for signature");
            throw new ProcessingException("Failed to Sign Request");
        }
        String signaturePassword = config.getSigningKey().getKeyPassword();
        if (signaturePassword == null) {
            LOG.debug("No signature password available");
            throw new ProcessingException("Failed to Sign Request");
        }
        PrivateKey privateKey = crypto.getPrivateKey(signatureUser, signaturePassword);
        if (privateKey == null) {
            LOG.debug("No private key available");
            throw new ProcessingException("Failed to Sign Request");
        }
        String sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String jceSigAlgo = "SHA1withRSA";
        LOG.debug("automatic sig algo detection: " + privateKey.getAlgorithm());
        if (privateKey.getAlgorithm().equalsIgnoreCase("DSA")) {
            sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            jceSigAlgo = "SHA1withDSA";
        }
        LOG.debug("Using Signature algorithm " + sigAlgo);
        Signature signature = Signature.getInstance(jceSigAlgo);
        signature.initSign(privateKey);
        sb.append("&SigAlg").append('=').append(URLEncoder.encode(sigAlgo, "UTF-8"));
        String requestToSign = sb.toString();
        signature.update(requestToSign.getBytes("UTF-8"));
        byte[] signBytes = signature.sign();
        String encodedSignature = Base64.encode((byte[])signBytes);
        return URLEncoder.encode(encodedSignature, "UTF-8");
    }

    protected String encodeAuthnRequest(Element authnRequest) throws IOException {
        String requestMessage = DOM2Writer.nodeToString((Node)authnRequest);
        byte[] deflatedBytes = CompressionUtils.deflate(requestMessage.getBytes("UTF-8"));
        return Base64.encode((byte[])deflatedBytes);
    }

    @Override
    public RedirectionResponse createSignOutRequest(HttpServletRequest request, SamlAssertionWrapper token, FedizContext config) throws ProcessingException {
        String redirectURL = null;
        try {
            if (!(config.getProtocol() instanceof SAMLProtocol)) {
                LOG.error("Unsupported protocol");
                throw new IllegalStateException("Unsupported protocol");
            }
            redirectURL = ((SAMLProtocol)config.getProtocol()).getIssuerLogoutURL();
            if (redirectURL == null) {
                String issuerURL = this.resolveIssuer(request, config);
                LOG.info("Issuer url: " + issuerURL);
                if (issuerURL != null && issuerURL.length() > 0) {
                    redirectURL = issuerURL;
                }
            }
            if (redirectURL == null) {
                LOG.debug("No issuerLogoutURL or issuer parameter specified for logout");
                throw new ProcessingException("Failed to create SignOutRequest");
            }
            SAMLPRequestBuilder samlpRequestBuilder = ((SAMLProtocol)config.getProtocol()).getSAMLPRequestBuilder();
            Document doc = DOMUtils.createDocument();
            doc.appendChild(doc.createElement("root"));
            String realm = this.resolveWTRealm(request, config);
            String reason = "urn:oasis:names:tc:SAML:2.0:logout:user";
            LogoutRequest logoutRequest = samlpRequestBuilder.createLogoutRequest(realm, reason, token);
            if (((SAMLProtocol)config.getProtocol()).isSignRequest()) {
                logoutRequest.setDestination(redirectURL);
            }
            Element logoutRequestElement = OpenSAMLUtil.toDom((XMLObject)logoutRequest, (Document)doc);
            String logoutRequestEncoded = this.encodeAuthnRequest(logoutRequestElement);
            String relayState = URLEncoder.encode(UUID.randomUUID().toString(), "UTF-8");
            String urlEncodedRequest = URLEncoder.encode(logoutRequestEncoded, "UTF-8");
            StringBuilder sb = new StringBuilder();
            sb.append("SAMLRequest").append('=').append(urlEncodedRequest);
            sb.append("&RelayState").append('=').append(relayState);
            if (((SAMLProtocol)config.getProtocol()).isSignRequest()) {
                String signature = this.signRequest(config, sb);
                sb.append("&Signature").append('=').append(signature);
            }
            RedirectionResponse response = new RedirectionResponse();
            response.addHeader("Cache-Control", "no-cache, no-store");
            response.addHeader("Pragma", "no-cache");
            redirectURL = redirectURL + "?" + sb.toString();
            response.setRedirectionURL(redirectURL);
            return response;
        }
        catch (Exception ex) {
            LOG.error("Failed to create SignOutRequest", (Throwable)ex);
            throw new ProcessingException("Failed to create SignOutRequest");
        }
    }

    static {
        OpenSAMLUtil.initSamlEngine();
    }
}

