/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.processor;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.spi.IDPCallback;
import org.apache.cxf.fediz.core.spi.RealmCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFedizProcessor
implements FedizProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFedizProcessor.class);

    protected String resolveIssuer(HttpServletRequest request, FedizContext config) throws IOException, UnsupportedCallbackException {
        Object issuerObj = config.getProtocol().getIssuer();
        String issuerURL = null;
        if (issuerObj instanceof String) {
            issuerURL = (String)issuerObj;
        } else if (issuerObj instanceof CallbackHandler) {
            CallbackHandler issuerCB = (CallbackHandler)issuerObj;
            IDPCallback callback = new IDPCallback(request);
            issuerCB.handle(new Callback[]{callback});
            issuerURL = callback.getIssuerUrl().toString();
        }
        return issuerURL;
    }

    protected String resolveWTRealm(HttpServletRequest request, FedizContext config) throws IOException, UnsupportedCallbackException {
        Object wtRealmObj = config.getProtocol().getRealm();
        String wtRealm = null;
        if (wtRealmObj != null) {
            if (wtRealmObj instanceof String) {
                wtRealm = (String)wtRealmObj;
            } else if (wtRealmObj instanceof CallbackHandler) {
                CallbackHandler hrCB = (CallbackHandler)wtRealmObj;
                RealmCallback callback = new RealmCallback(request);
                hrCB.handle(new Callback[]{callback});
                wtRealm = callback.getRealm();
            }
        } else {
            wtRealm = this.extractFullContextPath(request);
        }
        return wtRealm;
    }

    protected void testForReplayAttack(String tokenId, FedizContext config, Date expires) throws ProcessingException {
        if (tokenId != null && config.isDetectReplayedTokens()) {
            if (!config.getTokenReplayCache().contains(tokenId)) {
                if (expires != null) {
                    Date currentTime = new Date();
                    long ttl = expires.getTime() - currentTime.getTime();
                    config.getTokenReplayCache().add(tokenId, ttl / 1000L);
                } else {
                    config.getTokenReplayCache().add(tokenId);
                }
            } else {
                LOG.error("Replay attack with token id: " + tokenId);
                throw new ProcessingException("Replay attack with token id: " + tokenId, ProcessingException.TYPE.TOKEN_REPLAY);
            }
        }
    }

    protected String extractFullContextPath(HttpServletRequest request) throws MalformedURLException {
        String result = null;
        String contextPath = request.getContextPath();
        String requestUrl = request.getRequestURL().toString();
        String requestPath = new URL(requestUrl).getPath();
        if (requestPath != null && requestPath.length() > 0) {
            int lastIndex = requestUrl.lastIndexOf(requestPath);
            result = requestUrl.substring(0, lastIndex);
        } else {
            result = requestUrl;
        }
        result = contextPath != null && contextPath.length() > 0 ? result + contextPath + "/" : result + "/";
        return result;
    }
}

