/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.metadata;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.fediz.core.config.FederationProtocol;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.SAMLProtocol;
import org.apache.cxf.fediz.core.handler.RequestHandler;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.wss4j.common.util.DOM2Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MetadataDocumentHandler
implements RequestHandler<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataDocumentHandler.class);
    protected final FedizContext fedizConfig;

    public MetadataDocumentHandler(FedizContext fedConfig) {
        this.fedizConfig = fedConfig;
    }

    public static String getMetadataURI(FedizContext fedConfig) {
        if (fedConfig.getProtocol().getMetadataURI() != null) {
            return fedConfig.getProtocol().getMetadataURI();
        }
        if (fedConfig.getProtocol() instanceof FederationProtocol) {
            return "FederationMetadata/2007-06/FederationMetadata.xml";
        }
        if (fedConfig.getProtocol() instanceof SAMLProtocol) {
            return "SAML/Metadata.xml";
        }
        return "FederationMetadata/2007-06/FederationMetadata.xml";
    }

    @Override
    public boolean canHandleRequest(HttpServletRequest request) {
        return request.getRequestURL().indexOf(MetadataDocumentHandler.getMetadataURI(this.fedizConfig)) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean handleRequest(HttpServletRequest request, HttpServletResponse response) {
        LOG.debug("Metadata document requested");
        FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor(this.fedizConfig.getProtocol());
        try (PrintWriter out = null;){
            out = response.getWriter();
            Document metadata = wfProc.getMetaData(request, this.fedizConfig);
            out.write(DOM2Writer.nodeToString((Node)metadata));
            response.setContentType("text/xml");
            Boolean bl = true;
            return bl;
        }
    }
}

