/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.config;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.cxf.fediz.core.config.FederationProtocol;
import org.apache.cxf.fediz.core.config.KeyManager;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.config.SAMLProtocol;
import org.apache.cxf.fediz.core.config.TrustManager;
import org.apache.cxf.fediz.core.config.TrustedIssuer;
import org.apache.cxf.fediz.core.config.jaxb.CertificateStores;
import org.apache.cxf.fediz.core.config.jaxb.ContextConfig;
import org.apache.cxf.fediz.core.config.jaxb.FederationProtocolType;
import org.apache.cxf.fediz.core.config.jaxb.KeyManagersType;
import org.apache.cxf.fediz.core.config.jaxb.KeyStoreType;
import org.apache.cxf.fediz.core.config.jaxb.ProtocolType;
import org.apache.cxf.fediz.core.config.jaxb.SamlProtocolType;
import org.apache.cxf.fediz.core.config.jaxb.TrustManagersType;
import org.apache.cxf.fediz.core.config.jaxb.TrustedIssuerType;
import org.apache.cxf.fediz.core.config.jaxb.TrustedIssuers;
import org.apache.cxf.fediz.core.exception.IllegalConfigurationException;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.cache.ReplayCacheFactory;
import org.apache.wss4j.common.crypto.CertificateStore;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedizContext
implements Closeable {
    public static final String CACHE_KEY_PREFIX = "fediz.replay.cache";
    private static final Logger LOG = LoggerFactory.getLogger(FedizContext.class);
    private ContextConfig config;
    private boolean detectReplayedTokens = true;
    private String relativePath;
    private ReplayCache replayCache;
    private Protocol protocol;
    private List<TrustManager> certificateStores = new ArrayList<TrustManager>();
    private KeyManager keyManager;
    private KeyManager decryptionKeyManager;
    private ClassLoader classloader;
    private Pattern logoutRedirectToConstraint;

    public FedizContext(ContextConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("ContextConfig cannot be null!");
        }
        this.config = config;
    }

    public void init() {
        this.getProtocol();
    }

    public List<String> getAudienceUris() {
        if (this.config.getAudienceUris() == null) {
            return Collections.emptyList();
        }
        return this.config.getAudienceUris().getAudienceItem();
    }

    public List<TrustedIssuer> getTrustedIssuers() {
        TrustedIssuers issuers = this.config.getTrustedIssuers();
        List<TrustedIssuerType> trustManagers = issuers.getIssuer();
        ArrayList<TrustedIssuer> trustedIssuers = new ArrayList<TrustedIssuer>();
        for (TrustedIssuerType manager : trustManagers) {
            trustedIssuers.add(new TrustedIssuer(manager));
        }
        return trustedIssuers;
    }

    public List<TrustManager> getCertificateStores() {
        if (!this.certificateStores.isEmpty()) {
            return Collections.unmodifiableList(this.certificateStores);
        }
        CertificateStores certStores = this.config.getCertificateStores();
        List<TrustManagersType> trustManagers = certStores.getTrustManager();
        for (TrustManagersType manager : trustManagers) {
            TrustManager tm = new TrustManager(manager);
            Crypto crypto = null;
            try {
                if (manager.getKeyStore().getType().equalsIgnoreCase("PEM")) {
                    X509Certificate[] certificates = new X509Certificate[]{CertsUtils.getX509CertificateFromFile(tm.getName(), this.classloader)};
                    crypto = new CertificateStore(certificates);
                } else {
                    Properties sigProperties = this.createCryptoProperties(manager);
                    crypto = CryptoFactory.getInstance((Properties)sigProperties);
                }
                tm.setCrypto(crypto);
                this.certificateStores.add(tm);
            }
            catch (WSSecurityException e) {
                LOG.error("Failed to load keystore '" + tm.getName() + "'", (Throwable)e);
                throw new IllegalConfigurationException("Failed to load keystore '" + tm.getName() + "'");
            }
            catch (CertificateException ex) {
                LOG.error("Failed to read keystore", (Throwable)ex);
                throw new RuntimeException("Failed to read keystore");
            }
        }
        return Collections.unmodifiableList(this.certificateStores);
    }

    public BigInteger getMaximumClockSkew() {
        return this.config.getMaximumClockSkew();
    }

    public void setMaximumClockSkew(BigInteger maximumClockSkew) {
        this.config.setMaximumClockSkew(maximumClockSkew);
    }

    public Protocol getProtocol() {
        if (this.protocol != null) {
            return this.protocol;
        }
        ProtocolType type = this.config.getProtocol();
        if (type instanceof FederationProtocolType) {
            this.protocol = new FederationProtocol(type);
        } else if (type instanceof SamlProtocolType) {
            this.protocol = new SAMLProtocol(type);
        }
        if (this.protocol != null) {
            this.protocol.setClassloader(this.getClassloader());
        }
        return this.protocol;
    }

    public String getLogoutURL() {
        return this.config.getLogoutURL();
    }

    public String getLogoutRedirectTo() {
        return this.config.getLogoutRedirectTo();
    }

    public Pattern getLogoutRedirectToConstraint() {
        if (this.logoutRedirectToConstraint == null && this.config.getLogoutRedirectToConstraint() != null) {
            this.logoutRedirectToConstraint = Pattern.compile(this.config.getLogoutRedirectToConstraint());
        }
        return this.logoutRedirectToConstraint;
    }

    public KeyManager getSigningKey() {
        if (this.keyManager != null) {
            return this.keyManager;
        }
        if (this.config.getSigningKey() == null) {
            LOG.error("No signing key has been configured");
            throw new IllegalConfigurationException("No signing key has been configured");
        }
        this.keyManager = new KeyManager(this.config.getSigningKey());
        Properties sigProperties = this.createCryptoProperties(this.config.getSigningKey());
        try {
            Crypto crypto = CryptoFactory.getInstance((Properties)sigProperties);
            this.keyManager.setCrypto(crypto);
        }
        catch (WSSecurityException e) {
            String name = this.keyManager.getName();
            this.keyManager = null;
            LOG.error("Failed to load keystore '" + name + "'", (Throwable)e);
            throw new IllegalConfigurationException("Failed to load keystore '" + name + "'");
        }
        return this.keyManager;
    }

    public KeyManager getDecryptionKey() {
        if (this.decryptionKeyManager != null) {
            return this.decryptionKeyManager;
        }
        if (this.config.getTokenDecryptionKey() == null) {
            return null;
        }
        this.decryptionKeyManager = new KeyManager(this.config.getTokenDecryptionKey());
        Properties decProperties = this.createCryptoProperties(this.config.getTokenDecryptionKey());
        try {
            Crypto crypto = CryptoFactory.getInstance((Properties)decProperties);
            this.decryptionKeyManager.setCrypto(crypto);
        }
        catch (WSSecurityException e) {
            String name = this.decryptionKeyManager.getName();
            this.decryptionKeyManager = null;
            LOG.error("Failed to load keystore '" + name + "'", (Throwable)e);
            throw new IllegalConfigurationException("Failed to load keystore '" + name + "'");
        }
        return this.decryptionKeyManager;
    }

    public ReplayCache getTokenReplayCache() {
        if (this.replayCache != null) {
            return this.replayCache;
        }
        String replayCacheString = this.config.getTokenReplayCache();
        String cacheKey = "fediz.replay.cache-" + this.config.getName();
        ReplayCacheFactory replayCacheFactory = ReplayCacheFactory.newInstance();
        if (replayCacheString == null || "".equals(replayCacheString)) {
            this.replayCache = replayCacheFactory.newReplayCache(cacheKey, (Object)"/fediz-ehcache.xml");
        } else {
            try {
                Class replayCacheClass = Loader.loadClass((String)replayCacheString);
                this.replayCache = (ReplayCache)replayCacheClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                this.replayCache = replayCacheFactory.newReplayCache(cacheKey, (Object)"/fediz-ehcache.xml");
            }
            catch (InstantiationException e) {
                this.replayCache = replayCacheFactory.newReplayCache(cacheKey, (Object)"/fediz-ehcache.xml");
            }
            catch (IllegalAccessException e) {
                this.replayCache = replayCacheFactory.newReplayCache(cacheKey, (Object)"/fediz-ehcache.xml");
            }
        }
        return this.replayCache;
    }

    public String getName() {
        return this.config.getName();
    }

    public boolean isDetectExpiredTokens() {
        return this.config.isTokenExpirationValidation();
    }

    public void setDetectExpiredTokens(boolean detectExpiredTokens) {
        this.config.setTokenExpirationValidation(detectExpiredTokens);
    }

    public boolean isDetectReplayedTokens() {
        return this.detectReplayedTokens;
    }

    public void setDetectReplayedTokens(boolean detectReplayedTokens) {
        this.detectReplayedTokens = detectReplayedTokens;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public void close() throws IOException {
        if (this.replayCache != null) {
            this.replayCache.close();
        }
    }

    private Properties createCryptoProperties(TrustManagersType tm) {
        URL resource;
        String trustStoreFile = null;
        KeyStoreType ks = tm.getKeyStore();
        String trustStorePw = ks.getPassword();
        if (ks.getFile() != null && !ks.getFile().isEmpty()) {
            trustStoreFile = ks.getFile();
        } else if (ks.getResource() != null && !ks.getResource().isEmpty() && (resource = Loader.getResource((String)ks.getResource())) != null) {
            trustStoreFile = ks.getResource();
        }
        if (trustStoreFile == null) {
            throw new IllegalStateException("No certificate store configured");
        }
        File f = new File(trustStoreFile);
        if (!f.exists() && this.getRelativePath() != null && !this.getRelativePath().isEmpty()) {
            trustStoreFile = this.getRelativePath().concat(File.separator + trustStoreFile);
        }
        if (trustStoreFile == null || trustStoreFile.isEmpty()) {
            throw new IllegalConfigurationException("truststoreFile not configured");
        }
        if (trustStorePw == null || trustStorePw.isEmpty()) {
            throw new IllegalConfigurationException("trustStorePw not configured");
        }
        Properties p = new Properties();
        p.put("org.apache.ws.security.crypto.provider", "org.apache.ws.security.components.crypto.Merlin");
        p.put("org.apache.ws.security.crypto.merlin.keystore.type", "jks");
        p.put("org.apache.ws.security.crypto.merlin.keystore.password", trustStorePw);
        p.put("org.apache.ws.security.crypto.merlin.keystore.file", trustStoreFile);
        return p;
    }

    private Properties createCryptoProperties(KeyManagersType km) {
        URL resource;
        String keyStoreFile = null;
        String keyType = "jks";
        KeyStoreType ks = km.getKeyStore();
        String keyStorePw = ks.getPassword();
        if (ks.getFile() != null && !ks.getFile().isEmpty()) {
            keyStoreFile = ks.getFile();
        } else if (ks.getResource() != null && !ks.getResource().isEmpty() && (resource = Loader.getResource((String)ks.getResource())) != null) {
            keyStoreFile = ks.getResource();
        }
        if (keyStoreFile == null) {
            throw new IllegalStateException("No certificate store configured");
        }
        File f = new File(keyStoreFile);
        if (!f.exists() && this.getRelativePath() != null && !this.getRelativePath().isEmpty()) {
            keyStoreFile = this.getRelativePath().concat(File.separator + keyStoreFile);
        }
        if (keyStoreFile == null || keyStoreFile.isEmpty()) {
            throw new IllegalConfigurationException("truststoreFile not configured");
        }
        if (keyStorePw == null || keyStorePw.isEmpty()) {
            throw new IllegalConfigurationException("trustStorePw not configured");
        }
        if (ks.getType() != null) {
            keyType = ks.getType();
        }
        Properties p = new Properties();
        p.put("org.apache.ws.security.crypto.provider", "org.apache.ws.security.components.crypto.Merlin");
        p.put("org.apache.ws.security.crypto.merlin.keystore.type", keyType);
        p.put("org.apache.ws.security.crypto.merlin.keystore.password", keyStorePw);
        p.put("org.apache.ws.security.crypto.merlin.keystore.file", keyStoreFile);
        return p;
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public boolean isAddAuthenticatedRole() {
        return this.config.isAddAuthenticatedRole();
    }
}

