/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.samlsso;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cxf.fediz.core.config.CertificateValidationMethod;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.TrustManager;
import org.apache.cxf.fediz.core.config.TrustedIssuer;
import org.apache.cxf.fediz.core.saml.FedizSignatureTrustValidator;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.validate.Credential;
import org.opensaml.Configuration;
import org.opensaml.saml1.core.Response;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.ValidatorSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAMLProtocolResponseValidator {
    public static final String SAML2_STATUSCODE_SUCCESS = "urn:oasis:names:tc:SAML:2.0:status:Success";
    public static final String SAML1_STATUSCODE_SUCCESS = "Success";
    private static final Logger LOG = LoggerFactory.getLogger(SAMLProtocolResponseValidator.class);

    public void validateSamlResponse(org.opensaml.saml2.core.Response samlResponse, FedizContext config) throws WSSecurityException {
        if (samlResponse.getStatus() == null || samlResponse.getStatus().getStatusCode() == null) {
            LOG.debug("Either the SAML Response Status or StatusCode is null");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (!SAML2_STATUSCODE_SUCCESS.equals(samlResponse.getStatus().getStatusCode().getValue())) {
            LOG.debug("SAML Status code of " + samlResponse.getStatus().getStatusCode().getValue() + "does not equal " + SAML2_STATUSCODE_SUCCESS);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        this.validateResponseAgainstSchemas(samlResponse);
        this.validateResponseSignature(samlResponse, config);
    }

    public void validateSamlResponse(Response samlResponse, FedizContext config) throws WSSecurityException {
        if (samlResponse.getStatus() == null || samlResponse.getStatus().getStatusCode() == null || samlResponse.getStatus().getStatusCode().getValue() == null) {
            LOG.debug("Either the SAML Response Status or StatusCode is null");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        String statusValue = samlResponse.getStatus().getStatusCode().getValue().getLocalPart();
        if (!SAML1_STATUSCODE_SUCCESS.equals(statusValue)) {
            LOG.debug("SAML Status code of " + samlResponse.getStatus().getStatusCode().getValue() + "does not equal " + SAML1_STATUSCODE_SUCCESS);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        this.validateResponseAgainstSchemas(samlResponse);
        this.validateResponseSignature(samlResponse, config);
    }

    private void validateResponseAgainstSchemas(org.opensaml.saml2.core.Response samlResponse) throws WSSecurityException {
        ValidatorSuite schemaValidators = Configuration.getValidatorSuite((String)"saml2-core-schema-validator");
        try {
            schemaValidators.validate((XMLObject)samlResponse);
        }
        catch (ValidationException e) {
            LOG.debug("Saml Validation error: " + e.getMessage(), (Throwable)e);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
    }

    private void validateResponseAgainstSchemas(Response samlResponse) throws WSSecurityException {
        ValidatorSuite schemaValidators = Configuration.getValidatorSuite((String)"saml1-core-schema-validator");
        try {
            schemaValidators.validate((XMLObject)samlResponse);
        }
        catch (ValidationException e) {
            LOG.debug("Saml Validation error: " + e.getMessage(), (Throwable)e);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
    }

    private void validateResponseSignature(org.opensaml.saml2.core.Response samlResponse, FedizContext config) throws WSSecurityException {
        if (!samlResponse.isSigned()) {
            return;
        }
        this.validateResponseSignature(samlResponse.getSignature(), samlResponse.getDOM().getOwnerDocument(), config);
    }

    private void validateResponseSignature(Response samlResponse, FedizContext config) throws WSSecurityException {
        if (!samlResponse.isSigned()) {
            return;
        }
        this.validateResponseSignature(samlResponse.getSignature(), samlResponse.getDOM().getOwnerDocument(), config);
    }

    private void validateResponseSignature(Signature signature, Document doc, FedizContext config) throws WSSecurityException {
        RequestData requestData = new RequestData();
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        requestData.setWssConfig(wssConfig);
        SAMLKeyInfo samlKeyInfo = null;
        KeyInfo keyInfo = signature.getKeyInfo();
        if (keyInfo != null) {
            try {
                samlKeyInfo = SAMLUtil.getCredentialFromKeyInfo((Element)keyInfo.getDOM(), (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(requestData, new WSDocInfo(doc)), (Crypto)requestData.getSigVerCrypto());
            }
            catch (WSSecurityException ex) {
                LOG.debug("Error in getting KeyInfo from SAML Response: " + ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
        if (samlKeyInfo == null) {
            LOG.debug("No KeyInfo supplied in the SAMLResponse signature");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        this.validateSignatureAgainstProfiles(signature, samlKeyInfo);
        Credential trustCredential = new Credential();
        trustCredential.setPublicKey(samlKeyInfo.getPublicKey());
        trustCredential.setCertificates(samlKeyInfo.getCerts());
        FedizSignatureTrustValidator trustValidator = new FedizSignatureTrustValidator();
        boolean trusted = false;
        List<TrustedIssuer> trustedIssuers = config.getTrustedIssuers();
        for (TrustedIssuer ti : trustedIssuers) {
            Pattern subjectConstraint = ti.getCompiledSubject();
            ArrayList<Pattern> subjectConstraints = new ArrayList<Pattern>(1);
            if (subjectConstraint != null) {
                subjectConstraints.add(subjectConstraint);
            }
            if (ti.getCertificateValidationMethod().equals((Object)CertificateValidationMethod.CHAIN_TRUST)) {
                trustValidator.setSubjectConstraints(subjectConstraints);
                trustValidator.setSignatureTrustType(FedizSignatureTrustValidator.TRUST_TYPE.CHAIN_TRUST_CONSTRAINTS);
            } else if (ti.getCertificateValidationMethod().equals((Object)CertificateValidationMethod.PEER_TRUST)) {
                trustValidator.setSignatureTrustType(FedizSignatureTrustValidator.TRUST_TYPE.PEER_TRUST);
            } else {
                throw new IllegalStateException("Unsupported certificate validation method: " + (Object)((Object)ti.getCertificateValidationMethod()));
            }
            try {
                for (TrustManager tm : config.getCertificateStores()) {
                    try {
                        requestData.setSigVerCrypto(tm.getCrypto());
                        trustValidator.validate(trustCredential, requestData);
                        trusted = true;
                        break;
                    }
                    catch (Exception ex) {
                        LOG.debug("Issuer '{}' not validated in keystore '{}'", (Object)ti.getName(), (Object)tm.getName());
                    }
                }
                if (!trusted) continue;
                break;
            }
            catch (Exception ex) {
                LOG.info("Error in validating signature on SAML Response: " + ex.getMessage(), (Throwable)ex);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
        }
        if (!trusted) {
            LOG.warn("SAML Response is not trusted");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
    }

    private void validateSignatureAgainstProfiles(Signature signature, SAMLKeyInfo samlKeyInfo) throws WSSecurityException {
        SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
        try {
            validator.validate(signature);
        }
        catch (ValidationException ex) {
            LOG.debug("Error in validating the SAML Signature: " + ex.getMessage(), (Throwable)ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        BasicX509Credential credential = new BasicX509Credential();
        if (samlKeyInfo.getCerts() != null) {
            credential.setEntityCertificate(samlKeyInfo.getCerts()[0]);
        } else if (samlKeyInfo.getPublicKey() != null) {
            credential.setPublicKey(samlKeyInfo.getPublicKey());
        } else {
            LOG.debug("Can't get X509Certificate or PublicKey to verify signature");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        SignatureValidator sigValidator = new SignatureValidator((org.opensaml.xml.security.credential.Credential)credential);
        try {
            sigValidator.validate(signature);
        }
        catch (ValidationException ex) {
            LOG.debug("Error in validating the SAML Signature: " + ex.getMessage(), (Throwable)ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
    }
}

