/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.samlsso;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.fediz.core.samlsso.SAMLPRequestBuilder;
import org.apache.cxf.fediz.core.samlsso.SamlpRequestComponentBuilder;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml2.core.Subject;

public class DefaultSAMLPRequestBuilder
implements SAMLPRequestBuilder {
    private boolean forceAuthn;
    private boolean isPassive;
    private String protocolBinding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";

    @Override
    public AuthnRequest createAuthnRequest(String issuerId, String assertionConsumerServiceAddress) throws Exception {
        Issuer issuer = SamlpRequestComponentBuilder.createIssuer(issuerId);
        NameIDPolicy nameIDPolicy = SamlpRequestComponentBuilder.createNameIDPolicy(true, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", issuerId);
        AuthnContextClassRef authnCtxClassRef = SamlpRequestComponentBuilder.createAuthnCtxClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        RequestedAuthnContext authnCtx = SamlpRequestComponentBuilder.createRequestedAuthnCtxPolicy(AuthnContextComparisonTypeEnumeration.EXACT, Collections.singletonList(authnCtxClassRef), null);
        return SamlpRequestComponentBuilder.createAuthnRequest(assertionConsumerServiceAddress, this.forceAuthn, this.isPassive, this.protocolBinding, SAMLVersion.VERSION_20, issuer, nameIDPolicy, authnCtx);
    }

    public boolean isForceAuthn() {
        return this.forceAuthn;
    }

    public void setForceAuthn(boolean forceAuthn) {
        this.forceAuthn = forceAuthn;
    }

    public boolean isPassive() {
        return this.isPassive;
    }

    public void setPassive(boolean isPassive) {
        this.isPassive = isPassive;
    }

    public String getProtocolBinding() {
        return this.protocolBinding;
    }

    public void setProtocolBinding(String protocolBinding) {
        this.protocolBinding = protocolBinding;
    }

    @Override
    public LogoutRequest createLogoutRequest(String issuerId, String reason, SamlAssertionWrapper authenticatedAssertion) throws Exception {
        Issuer issuer = SamlpRequestComponentBuilder.createIssuer(issuerId);
        NameID nameID = null;
        ArrayList<String> sessionIndices = new ArrayList<String>();
        if (authenticatedAssertion != null) {
            List authnStatements;
            Subject subject;
            if (authenticatedAssertion.getSaml2() != null && (subject = authenticatedAssertion.getSaml2().getSubject()) != null && subject.getNameID() != null) {
                nameID = subject.getNameID();
            }
            if (nameID != null) {
                nameID.detach();
            }
            if ((authnStatements = authenticatedAssertion.getSaml2().getAuthnStatements()) != null && !authnStatements.isEmpty()) {
                for (AuthnStatement authnStatement : authnStatements) {
                    if (authnStatement.getSessionIndex() == null) continue;
                    sessionIndices.add(authnStatement.getSessionIndex());
                }
            }
        }
        return SamlpRequestComponentBuilder.createLogoutRequest(issuer, reason, nameID, sessionIndices);
    }
}

