/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.saml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.cxf.fediz.core.saml.FedizSignatureTrustValidator;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.validate.Credential;

public class SamlAssertionValidator
extends org.apache.wss4j.dom.validate.SamlAssertionValidator {
    private FedizSignatureTrustValidator.TRUST_TYPE signatureTrustType = FedizSignatureTrustValidator.TRUST_TYPE.CHAIN_TRUST;
    private Collection<Pattern> subjectDNPatterns = new ArrayList<Pattern>();

    public void setSubjectConstraints(Collection<Pattern> constraints) {
        if (constraints != null) {
            this.subjectDNPatterns.clear();
            this.subjectDNPatterns.addAll(constraints);
        }
    }

    public void setSignatureTrustType(FedizSignatureTrustValidator.TRUST_TYPE trustType) {
        this.signatureTrustType = trustType;
    }

    protected Credential verifySignedAssertion(SamlAssertionWrapper assertion, RequestData data) throws WSSecurityException {
        Credential credential = new Credential();
        SAMLKeyInfo samlKeyInfo = assertion.getSignatureKeyInfo();
        credential.setPublicKey(samlKeyInfo.getPublicKey());
        credential.setCertificates(samlKeyInfo.getCerts());
        FedizSignatureTrustValidator trustValidator = new FedizSignatureTrustValidator();
        trustValidator.setSignatureTrustType(this.signatureTrustType);
        trustValidator.setSubjectConstraints(this.subjectDNPatterns);
        return trustValidator.validate(credential, data);
    }
}

