/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.fediz.core.config.Claim;
import org.apache.cxf.fediz.core.config.FederationProtocol;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.config.SAMLProtocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.cxf.fediz.core.util.DOMUtils;
import org.apache.cxf.fediz.core.util.SignatureUtils;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class MetadataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataWriter.class);
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();

    public Document getMetaData(HttpServletRequest request, FedizContext config) throws ProcessingException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)bout, "UTF-8");
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(streamWriter);
            Protocol protocol = config.getProtocol();
            writer.writeStartDocument("UTF-8", "1.0");
            String referenceID = IDGenerator.generateID((String)"_");
            writer.writeStartElement("md", "EntityDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeAttribute("ID", referenceID);
            String serviceURL = protocol.getApplicationServiceURL();
            if (serviceURL == null) {
                serviceURL = this.extractFullContextPath(request);
            }
            writer.writeAttribute("entityID", serviceURL);
            writer.writeNamespace("md", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeNamespace("fed", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeNamespace("wsa", "http://www.w3.org/2005/08/addressing");
            writer.writeNamespace("auth", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (protocol instanceof FederationProtocol) {
                this.writeFederationMetadata(writer, config, serviceURL);
            } else if (protocol instanceof SAMLProtocol) {
                this.writeSAMLMetadata(writer, request, config, serviceURL);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            ((Writer)streamWriter).flush();
            bout.flush();
            if (LOG.isDebugEnabled()) {
                String out = new String(bout.toByteArray());
                LOG.debug("***************** unsigned ****************");
                LOG.debug(out);
                LOG.debug("***************** unsigned ****************");
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bout.toByteArray());
            boolean hasSigningKey = false;
            try {
                if (config.getSigningKey().getCrypto() != null) {
                    hasSigningKey = true;
                }
            }
            catch (Exception ex) {
                LOG.info("No signingKey element found in config: " + ex.getMessage());
            }
            if (hasSigningKey) {
                Document doc = DOMUtils.readXml(is);
                Document result = SignatureUtils.signMetaInfo(config.getSigningKey().getCrypto(), config.getSigningKey().getKeyAlias(), config.getSigningKey().getKeyPassword(), doc, referenceID);
                if (result != null) {
                    return result;
                }
                throw new ProcessingException("Failed to sign the metadata document: result=null");
            }
            return DOMUtils.readXml(is);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error creating service metadata information ", (Throwable)e);
            throw new ProcessingException("Error creating service metadata information: " + e.getMessage());
        }
    }

    private void writeFederationMetadata(XMLStreamWriter writer, FedizContext config, String serviceURL) throws XMLStreamException {
        writer.writeStartElement("md", "RoleDescriptor", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "fed:ApplicationServiceType");
        writer.writeAttribute("protocolSupportEnumeration", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeStartElement("fed", "ApplicationServiceEndpoint", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
        writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
        writer.writeCharacters(serviceURL);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("fed", "TargetScope", "http://docs.oasis-open.org/wsfed/federation/200706");
        List<String> audienceUris = config.getAudienceUris();
        if (audienceUris != null) {
            for (String uri : audienceUris) {
                writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
                writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
                writer.writeCharacters(uri);
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
        FederationProtocol protocol = (FederationProtocol)config.getProtocol();
        List<Claim> claims = protocol.getClaimTypesRequested();
        if (claims != null && claims.size() > 0) {
            writer.writeStartElement("fed", "ClaimTypesRequested", "http://docs.oasis-open.org/wsfed/federation/200706");
            for (Claim claim : claims) {
                writer.writeStartElement("auth", "ClaimType", "http://docs.oasis-open.org/wsfed/federation/200706");
                writer.writeAttribute("Uri", claim.getType());
                if (claim.isOptional()) {
                    writer.writeAttribute("Optional", "true");
                } else {
                    writer.writeAttribute("Optional", "false");
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeStartElement("fed", "PassiveRequestorEndpoint", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
        writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
        writer.writeCharacters(serviceURL);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void writeSAMLMetadata(XMLStreamWriter writer, HttpServletRequest request, FedizContext config, String serviceURL) throws Exception {
        SAMLProtocol protocol = (SAMLProtocol)config.getProtocol();
        writer.writeStartElement("md", "SPSSODescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
        writer.writeAttribute("AuthnRequestsSigned", Boolean.toString(protocol.isSignRequest()));
        writer.writeAttribute("WantAssertionsSigned", "true");
        writer.writeAttribute("protocolSupportEnumeration", "urn:oasis:names:tc:SAML:2.0:protocol");
        if (config.getLogoutURL() != null) {
            writer.writeStartElement("md", "SingleLogoutService", "urn:oasis:names:tc:SAML:2.0:metadata");
            String logoutURL = config.getLogoutURL();
            logoutURL = logoutURL.startsWith("/") ? this.extractFullContextPath(request).concat(logoutURL.substring(1)) : this.extractFullContextPath(request).concat(logoutURL);
            writer.writeAttribute("Location", logoutURL);
            writer.writeAttribute("Binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            writer.writeEndElement();
        }
        writer.writeStartElement("md", "AssertionConsumerService", "urn:oasis:names:tc:SAML:2.0:metadata");
        writer.writeAttribute("Location", serviceURL);
        writer.writeAttribute("index", "0");
        writer.writeAttribute("isDefault", "true");
        writer.writeAttribute("Binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        writer.writeEndElement();
        if (protocol.getClaimTypesRequested() != null && !protocol.getClaimTypesRequested().isEmpty()) {
            writer.writeStartElement("md", "AttributeConsumingService", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeAttribute("index", "0");
            writer.writeStartElement("md", "ServiceName", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeAttribute("xml:lang", "en");
            writer.writeCharacters(config.getName());
            writer.writeEndElement();
            for (Claim claim : protocol.getClaimTypesRequested()) {
                writer.writeStartElement("md", "RequestedAttribute", "urn:oasis:names:tc:SAML:2.0:metadata");
                writer.writeAttribute("isRequired", Boolean.toString(claim.isOptional()));
                writer.writeAttribute("Name", claim.getType());
                writer.writeAttribute("NameFormat", "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        boolean hasSigningKey = false;
        try {
            if (config.getSigningKey().getCrypto() != null) {
                hasSigningKey = true;
            }
        }
        catch (Exception ex) {
            LOG.info("No signingKey element found in config: " + ex.getMessage());
        }
        if (protocol.isSignRequest() && hasSigningKey) {
            X509Certificate cert;
            writer.writeStartElement("md", "KeyDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeAttribute("use", "signing");
            writer.writeStartElement("ds", "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
            writer.writeNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
            writer.writeStartElement("ds", "X509Data", "http://www.w3.org/2000/09/xmldsig#");
            writer.writeStartElement("ds", "X509Certificate", "http://www.w3.org/2000/09/xmldsig#");
            String keyAlias = config.getSigningKey().getKeyAlias();
            if (keyAlias == null || "".equals(keyAlias)) {
                keyAlias = config.getSigningKey().getCrypto().getDefaultX509Identifier();
            }
            if ((cert = CertsUtils.getX509Certificate(config.getSigningKey().getCrypto(), keyAlias)) == null) {
                throw new ProcessingException("No signing certs were found to insert into the metadata using name: " + keyAlias);
            }
            byte[] data = cert.getEncoded();
            String encodedCertificate = Base64.encode((byte[])data);
            writer.writeCharacters(encodedCertificate);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private String extractFullContextPath(HttpServletRequest request) throws MalformedURLException {
        String result = null;
        String contextPath = request.getContextPath();
        String requestUrl = request.getRequestURL().toString();
        String requestPath = new URL(requestUrl).getPath();
        if (requestPath != null && requestPath.length() > 0) {
            int lastIndex = requestUrl.lastIndexOf(requestPath);
            result = requestUrl.substring(0, lastIndex);
        } else {
            result = requestUrl;
        }
        result = contextPath != null && contextPath.length() > 0 ? result + contextPath + "/" : result + "/";
        return result;
    }
}

