/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.config;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.fediz.core.TokenValidator;
import org.apache.cxf.fediz.core.config.Claim;
import org.apache.cxf.fediz.core.config.jaxb.ArgumentType;
import org.apache.cxf.fediz.core.config.jaxb.CallbackType;
import org.apache.cxf.fediz.core.config.jaxb.ClaimType;
import org.apache.cxf.fediz.core.config.jaxb.ClaimTypesRequested;
import org.apache.cxf.fediz.core.config.jaxb.ProtocolType;
import org.apache.cxf.fediz.core.util.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Protocol {
    private static final Logger LOG = LoggerFactory.getLogger(Protocol.class);
    private ProtocolType protocolType;
    private ClassLoader classloader;
    private Object issuer;
    private Object realm;
    private List<TokenValidator> validators = new ArrayList<TokenValidator>();

    public Protocol(ProtocolType protocolType) {
        this.protocolType = protocolType;
        if (protocolType.getTokenValidators() != null && protocolType.getTokenValidators().getValidator() != null) {
            for (String validatorClassname : protocolType.getTokenValidators().getValidator()) {
                Object obj = null;
                try {
                    obj = ClassLoaderUtils.loadClass(validatorClassname, this.getClass()).newInstance();
                }
                catch (Exception ex) {
                    LOG.error("Failed to instantiate TokenValidator implementation class: '" + validatorClassname + "'\n" + ex.getClass().getCanonicalName() + ": " + ex.getMessage());
                }
                if (obj instanceof TokenValidator) {
                    this.validators.add(obj);
                    continue;
                }
                if (obj == null) continue;
                LOG.error("Invalid TokenValidator implementation class: '" + validatorClassname + "'");
            }
        }
    }

    protected ProtocolType getProtocolType() {
        return this.protocolType;
    }

    protected void setProtocolType(ProtocolType protocolType) {
        this.protocolType = protocolType;
    }

    public int hashCode() {
        return this.protocolType.hashCode();
    }

    public boolean equals(Object obj) {
        return this.protocolType.equals(obj);
    }

    public String toString() {
        return this.protocolType.toString();
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public String getRoleDelimiter() {
        return this.getProtocolType().getRoleDelimiter();
    }

    public void setRoleDelimiter(String value) {
        this.getProtocolType().setRoleDelimiter(value);
    }

    public String getRoleURI() {
        return this.getProtocolType().getRoleURI();
    }

    public void setRoleURI(String value) {
        this.getProtocolType().setRoleURI(value);
    }

    public String getMetadataURI() {
        return this.getProtocolType().getMetadataURI();
    }

    public void setMetadataURI(String value) {
        this.getProtocolType().setMetadataURI(value);
    }

    public Object getIssuer() {
        if (this.issuer != null) {
            return this.issuer;
        }
        CallbackType cbt = this.getProtocolType().getIssuer();
        this.issuer = this.loadCallbackType(cbt, "Issuer");
        return this.issuer;
    }

    public void setIssuer(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'Issuer' object");
            throw new IllegalArgumentException("Unsupported 'Issuer' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.issuer = value;
    }

    public Object getRealm() {
        if (this.realm != null) {
            return this.realm;
        }
        CallbackType cbt = this.getProtocolType().getRealm();
        this.realm = this.loadCallbackType(cbt, "Realm");
        return this.realm;
    }

    public void setRealm(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'Realm' object");
            throw new IllegalArgumentException("Unsupported 'Realm' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.realm = value;
    }

    public List<TokenValidator> getTokenValidators() {
        return this.validators;
    }

    protected Object loadCallbackType(CallbackType cbt, String name) {
        if (cbt == null || cbt.getValue() == null) {
            return null;
        }
        if (cbt.getType() == null || cbt.getType().equals((Object)ArgumentType.STRING)) {
            return new String(cbt.getValue());
        }
        if (cbt.getType().equals((Object)ArgumentType.CLASS)) {
            try {
                if (this.getClassloader() == null) {
                    return ClassLoaderUtils.loadClass(cbt.getValue(), this.getClass()).newInstance();
                }
                return this.getClassloader().loadClass(cbt.getValue()).newInstance();
            }
            catch (Exception e) {
                LOG.error("Failed to create instance of " + cbt.getValue(), (Throwable)e);
                throw new IllegalStateException("Failed to create instance of " + cbt.getValue());
            }
        }
        LOG.error("Only String and Class are supported for '" + name + "'");
        throw new IllegalStateException("Only String and Class are supported for '" + name + "'");
    }

    public List<Claim> getClaimTypesRequested() {
        ClaimTypesRequested claimsRequested = this.getProtocolType().getClaimTypesRequested();
        ArrayList<Claim> claims = new ArrayList<Claim>();
        if (claimsRequested != null) {
            for (ClaimType c : claimsRequested.getClaimType()) {
                claims.add(new Claim(c));
            }
        }
        return claims;
    }

    public void setClaimTypesRequested(ClaimTypesRequested value) {
        this.getProtocolType().setClaimTypesRequested(value);
    }

    public String getApplicationServiceURL() {
        return this.getProtocolType().getApplicationServiceURL();
    }

    public void setApplicationServiceURL(String value) {
        this.getProtocolType().setApplicationServiceURL(value);
    }
}

