/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.str;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.CustomTokenPrincipal;
import org.apache.wss4j.common.principal.SAMLTokenPrincipalImpl;
import org.apache.wss4j.common.principal.WSDerivedKeyTokenPrincipal;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.message.token.DerivedKeyToken;
import org.apache.wss4j.dom.message.token.Reference;
import org.apache.wss4j.dom.message.token.SecurityContextToken;
import org.apache.wss4j.dom.message.token.SecurityTokenReference;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.str.STRParser;
import org.apache.wss4j.dom.str.STRParserUtil;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Element;

public class SignatureSTRParser
implements STRParser {
    public static final String SIGNATURE_METHOD = "signature_method";
    private X509Certificate[] certs;
    private byte[] secretKey;
    private PublicKey publicKey;
    private Principal principal;
    private boolean trustedCredential;
    private STRParser.REFERENCE_TYPE referenceType;

    @Override
    public void parseSecurityTokenReference(Element strElement, RequestData data, WSDocInfo wsDocInfo, Map<String, Object> parameters) throws WSSecurityException {
        Crypto crypto = data.getSigVerCrypto();
        SecurityTokenReference secRef = new SecurityTokenReference(strElement, data.getBSPEnforcer());
        String uri = null;
        if (secRef.containsReference()) {
            uri = secRef.getReference().getURI();
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1);
            }
            this.referenceType = STRParser.REFERENCE_TYPE.DIRECT_REF;
        } else if (secRef.containsKeyIdentifier()) {
            uri = secRef.getKeyIdentifierValue();
            this.referenceType = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(secRef.getKeyIdentifierValueType()) ? STRParser.REFERENCE_TYPE.THUMBPRINT_SHA1 : STRParser.REFERENCE_TYPE.KEY_IDENTIFIER;
        }
        WSSecurityEngineResult result = wsDocInfo.getResult(uri);
        if (result != null) {
            this.processPreviousResult(result, secRef, data, parameters);
        } else if (secRef.containsReference()) {
            Reference reference = secRef.getReference();
            this.secretKey = this.getSecretKeyFromToken(uri, reference.getValueType(), data);
            this.principal = new CustomTokenPrincipal(uri);
            if (this.secretKey == null) {
                Element token = secRef.getTokenElement(strElement.getOwnerDocument(), wsDocInfo, data.getCallbackHandler());
                QName el = new QName(token.getNamespaceURI(), token.getLocalName());
                if (el.equals(WSSecurityEngine.BINARY_TOKEN)) {
                    Processor proc = data.getWssConfig().getProcessor(WSSecurityEngine.BINARY_TOKEN);
                    List<WSSecurityEngineResult> bstResult = proc.handleToken(token, data, wsDocInfo);
                    BinarySecurity bstToken = (BinarySecurity)bstResult.get(0).get("binary-security-token");
                    STRParserUtil.checkBinarySecurityBSPCompliance(secRef, bstToken, data.getBSPEnforcer());
                    this.certs = (X509Certificate[])bstResult.get(0).get("x509-certificates");
                    this.secretKey = (byte[])bstResult.get(0).get("secret");
                    this.principal = (Principal)bstResult.get(0).get("principal");
                } else if (el.equals(WSSecurityEngine.SAML_TOKEN) || el.equals(WSSecurityEngine.SAML2_TOKEN)) {
                    Processor proc = data.getWssConfig().getProcessor(WSSecurityEngine.SAML_TOKEN);
                    Element processedToken = secRef.findProcessedTokenElement(strElement.getOwnerDocument(), wsDocInfo, data.getCallbackHandler(), uri, secRef.getReference().getValueType());
                    SamlAssertionWrapper samlAssertion = null;
                    if (processedToken == null) {
                        List<WSSecurityEngineResult> samlResult = proc.handleToken(token, data, wsDocInfo);
                        samlAssertion = (SamlAssertionWrapper)samlResult.get(0).get("saml-assertion");
                    } else {
                        samlAssertion = new SamlAssertionWrapper(processedToken);
                        samlAssertion.parseSubject((SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data, wsDocInfo), data.getSigVerCrypto(), data.getCallbackHandler());
                    }
                    STRParserUtil.checkSamlTokenBSPCompliance(secRef, samlAssertion, data.getBSPEnforcer());
                    SAMLKeyInfo keyInfo = samlAssertion.getSubjectKeyInfo();
                    X509Certificate[] foundCerts = keyInfo.getCerts();
                    if (foundCerts != null && foundCerts.length > 0) {
                        this.certs = new X509Certificate[]{foundCerts[0]};
                    }
                    this.secretKey = keyInfo.getSecret();
                    this.principal = this.createPrincipalFromSAML(samlAssertion);
                } else if (el.equals(WSSecurityEngine.ENCRYPTED_KEY)) {
                    STRParserUtil.checkEncryptedKeyBSPCompliance(secRef, data.getBSPEnforcer());
                    Processor proc = data.getWssConfig().getProcessor(WSSecurityEngine.ENCRYPTED_KEY);
                    List<WSSecurityEngineResult> encrResult = proc.handleToken(token, data, wsDocInfo);
                    this.secretKey = (byte[])encrResult.get(0).get("secret");
                    this.principal = new CustomTokenPrincipal(token.getAttributeNS(null, "Id"));
                }
            }
        } else if (secRef.containsX509Data() || secRef.containsX509IssuerSerial()) {
            this.referenceType = STRParser.REFERENCE_TYPE.ISSUER_SERIAL;
            X509Certificate[] foundCerts = secRef.getX509IssuerSerial(crypto);
            if (foundCerts != null && foundCerts.length > 0) {
                this.certs = new X509Certificate[]{foundCerts[0]};
            }
        } else if (secRef.containsKeyIdentifier()) {
            if (secRef.getKeyIdentifierValueType().equals("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1")) {
                STRParserUtil.checkEncryptedKeyBSPCompliance(secRef, data.getBSPEnforcer());
                String id = secRef.getKeyIdentifierValue();
                this.secretKey = this.getSecretKeyFromToken(id, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1", data);
                this.principal = new CustomTokenPrincipal(id);
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(secRef.getKeyIdentifierValueType()) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(secRef.getKeyIdentifierValueType())) {
                this.parseSAMLKeyIdentifier(secRef, wsDocInfo, data);
            } else {
                this.parseBSTKeyIdentifier(secRef, crypto, wsDocInfo, data);
            }
        } else {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "unsupportedKeyInfo", new Object[]{strElement.toString()});
        }
        if (this.certs != null && this.certs.length > 0 && this.principal == null) {
            this.principal = this.certs[0].getSubjectX500Principal();
        }
    }

    @Override
    public X509Certificate[] getCertificates() {
        return this.certs;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public byte[] getSecretKey() {
        return this.secretKey;
    }

    @Override
    public boolean isTrustedCredential() {
        return this.trustedCredential;
    }

    @Override
    public STRParser.REFERENCE_TYPE getCertificatesReferenceType() {
        return this.referenceType;
    }

    private Principal createPrincipalFromSAML(SamlAssertionWrapper samlAssertion) {
        SAMLTokenPrincipalImpl samlPrincipal = new SAMLTokenPrincipalImpl(samlAssertion);
        String confirmMethod = null;
        List methods = samlAssertion.getConfirmationMethods();
        if (methods != null && methods.size() > 0) {
            confirmMethod = (String)methods.get(0);
        }
        if (OpenSAMLUtil.isMethodHolderOfKey(confirmMethod) && samlAssertion.isSigned()) {
            this.trustedCredential = true;
        }
        return samlPrincipal;
    }

    private byte[] getSecretKeyFromToken(String id, String type, RequestData data) throws WSSecurityException {
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        WSPasswordCallback pwcb = new WSPasswordCallback(id, null, type, 9);
        try {
            Callback[] callbacks = new Callback[]{pwcb};
            if (data.getCallbackHandler() != null) {
                data.getCallbackHandler().handle(callbacks);
                return pwcb.getKey();
            }
        }
        catch (Exception e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "noPassword", new Object[]{id});
        }
        return null;
    }

    private void parseSAMLKeyIdentifier(SecurityTokenReference secRef, WSDocInfo wsDocInfo, RequestData data) throws WSSecurityException {
        String valueType = secRef.getKeyIdentifierValueType();
        this.secretKey = this.getSecretKeyFromToken(secRef.getKeyIdentifierValue(), valueType, data);
        if (this.secretKey == null) {
            SamlAssertionWrapper samlAssertion = STRParserUtil.getAssertionFromKeyIdentifier(secRef, secRef.getElement(), data, wsDocInfo);
            STRParserUtil.checkSamlTokenBSPCompliance(secRef, samlAssertion, data.getBSPEnforcer());
            SAMLKeyInfo samlKi = SAMLUtil.getCredentialFromSubject((SamlAssertionWrapper)samlAssertion, (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data, wsDocInfo), (Crypto)data.getSigVerCrypto(), (CallbackHandler)data.getCallbackHandler());
            X509Certificate[] foundCerts = samlKi.getCerts();
            if (foundCerts != null && foundCerts.length > 0) {
                this.certs = new X509Certificate[]{foundCerts[0]};
            }
            this.secretKey = samlKi.getSecret();
            this.publicKey = samlKi.getPublicKey();
            this.principal = this.createPrincipalFromSAML(samlAssertion);
        }
    }

    private void parseBSTKeyIdentifier(SecurityTokenReference secRef, Crypto crypto, WSDocInfo wsDocInfo, RequestData data) throws WSSecurityException {
        STRParserUtil.checkBinarySecurityBSPCompliance(secRef, null, data.getBSPEnforcer());
        String valueType = secRef.getKeyIdentifierValueType();
        if ("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1".equals(valueType)) {
            this.secretKey = this.getSecretKeyFromToken(secRef.getKeyIdentifierValue(), valueType, data);
            if (this.secretKey == null) {
                byte[] keyBytes = secRef.getSKIBytes();
                List<WSSecurityEngineResult> resultsList = wsDocInfo.getResultsByTag(4096);
                for (WSSecurityEngineResult bstResult : resultsList) {
                    BinarySecurity bstToken = (BinarySecurity)bstResult.get("binary-security-token");
                    byte[] tokenDigest = WSSecurityUtil.generateDigest(bstToken.getToken());
                    if (!Arrays.equals(tokenDigest, keyBytes)) continue;
                    this.secretKey = (byte[])bstResult.get("secret");
                    this.principal = (Principal)bstResult.get("principal");
                    break;
                }
            } else {
                this.principal = new CustomTokenPrincipal(secRef.getKeyIdentifierValue());
            }
        } else {
            X509Certificate[] foundCerts = secRef.getKeyIdentifier(crypto);
            if (foundCerts == null) {
                if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(valueType)) {
                    byte[] skiBytes = secRef.getSKIBytes();
                    List<WSSecurityEngineResult> resultsList = wsDocInfo.getResultsByTag(4096);
                    for (WSSecurityEngineResult bstResult : resultsList) {
                        X509Certificate[] certs = (X509Certificate[])bstResult.get("x509-certificates");
                        if (certs == null || !Arrays.equals(skiBytes, crypto.getSKIBytesFromCert(certs[0]))) continue;
                        this.principal = (Principal)bstResult.get("principal");
                        foundCerts = certs;
                        break;
                    }
                } else if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(valueType)) {
                    String kiValue = secRef.getKeyIdentifierValue();
                    List<WSSecurityEngineResult> resultsList = wsDocInfo.getResultsByTag(4096);
                    for (WSSecurityEngineResult bstResult : resultsList) {
                        X509Certificate[] certs = (X509Certificate[])bstResult.get("x509-certificates");
                        if (certs == null) continue;
                        try {
                            byte[] digest = WSSecurityUtil.generateDigest(certs[0].getEncoded());
                            try {
                                if (!Arrays.equals(Base64.decode((String)kiValue), digest)) continue;
                                this.principal = (Principal)bstResult.get("principal");
                                foundCerts = certs;
                                break;
                            }
                            catch (Base64DecodingException e) {
                                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e), "decoding.general");
                            }
                        }
                        catch (CertificateEncodingException ex) {
                            throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_TOKEN_UNAVAILABLE, (Exception)ex, "encodeError");
                        }
                    }
                }
            }
            if (foundCerts != null) {
                this.certs = new X509Certificate[]{foundCerts[0]};
            }
        }
    }

    private void processPreviousResult(WSSecurityEngineResult result, SecurityTokenReference secRef, RequestData data, Map<String, Object> parameters) throws WSSecurityException {
        int action = (Integer)result.get("action");
        if (8192 == action || 1 == action) {
            STRParserUtil.checkUsernameTokenBSPCompliance(secRef, data.getBSPEnforcer());
            UsernameToken usernameToken = (UsernameToken)result.get("username-token");
            usernameToken.setRawPassword(data);
            this.secretKey = (byte[])result.get("secret");
            this.principal = usernameToken.createPrincipal();
        } else if (4096 == action) {
            BinarySecurity token = (BinarySecurity)result.get("binary-security-token");
            STRParserUtil.checkBinarySecurityBSPCompliance(secRef, token, data.getBSPEnforcer());
            this.certs = (X509Certificate[])result.get("x509-certificates");
            this.secretKey = (byte[])result.get("secret");
            Boolean validatedToken = (Boolean)result.get("validated-token");
            if (validatedToken.booleanValue()) {
                this.trustedCredential = true;
            }
        } else if (4 == action) {
            STRParserUtil.checkEncryptedKeyBSPCompliance(secRef, data.getBSPEnforcer());
            this.secretKey = (byte[])result.get("secret");
            String id = (String)result.get("id");
            this.principal = new CustomTokenPrincipal(id);
        } else if (1024 == action) {
            this.secretKey = (byte[])result.get("secret");
            SecurityContextToken sct = (SecurityContextToken)result.get("security-context-token");
            this.principal = new CustomTokenPrincipal(sct.getIdentifier());
        } else if (2048 == action) {
            DerivedKeyToken dkt = (DerivedKeyToken)result.get("derived-key-token");
            int keyLength = dkt.getLength();
            if (keyLength <= 0) {
                String algorithm = (String)parameters.get(SIGNATURE_METHOD);
                keyLength = KeyUtils.getKeyLength((String)algorithm);
            }
            byte[] secret = (byte[])result.get("secret");
            this.secretKey = dkt.deriveKey(keyLength, secret);
            this.principal = dkt.createPrincipal();
            ((WSDerivedKeyTokenPrincipal)this.principal).setSecret(secret);
        } else if (8 == action || 16 == action) {
            SamlAssertionWrapper samlAssertion = (SamlAssertionWrapper)result.get("saml-assertion");
            STRParserUtil.checkSamlTokenBSPCompliance(secRef, samlAssertion, data.getBSPEnforcer());
            SAMLKeyInfo keyInfo = samlAssertion.getSubjectKeyInfo();
            if (keyInfo == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
            X509Certificate[] foundCerts = keyInfo.getCerts();
            if (foundCerts != null) {
                this.certs = new X509Certificate[]{foundCerts[0]};
            }
            this.secretKey = keyInfo.getSecret();
            this.publicKey = keyInfo.getPublicKey();
            this.principal = this.createPrincipalFromSAML(samlAssertion);
        }
    }
}

