/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message.token;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.UUID;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.ext.AttachmentResultCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.wss4j.dom.bsp.BSPEnforcer;
import org.apache.wss4j.dom.message.token.TokenElementCallback;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BinarySecurity {
    public static final QName TOKEN_BST = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken");
    public static final QName TOKEN_KI = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier");
    public static final String BASE64_ENCODING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private static final Logger LOG = LoggerFactory.getLogger(BinarySecurity.class);
    private Element element;
    private byte[] data;
    private boolean storeBytesInAttachment;
    private CallbackHandler attachmentCallbackHandler;

    public CallbackHandler getAttachmentCallbackHandler() {
        return this.attachmentCallbackHandler;
    }

    public void setAttachmentCallbackHandler(CallbackHandler attachmentCallbackHandler) {
        this.attachmentCallbackHandler = attachmentCallbackHandler;
    }

    public BinarySecurity(Element elem, BSPEnforcer bspEnforcer) throws WSSecurityException {
        String valueType;
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN_BST) && !el.equals(TOKEN_KI)) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "unhandledToken", new Object[]{el});
        }
        String encoding = this.getEncodingType();
        if (encoding == null || "".equals(encoding)) {
            bspEnforcer.handleBSPRule(BSPRule.R3029);
        }
        if (!BASE64_ENCODING.equals(encoding)) {
            bspEnforcer.handleBSPRule(BSPRule.R3030);
        }
        if ((valueType = this.getValueType()) == null || "".equals(valueType)) {
            bspEnforcer.handleBSPRule(BSPRule.R3031);
        }
    }

    public BinarySecurity(Document doc) {
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken");
        this.setEncodingType(BASE64_ENCODING);
    }

    public BinarySecurity(CallbackHandler callbackHandler) throws WSSecurityException {
        if (callbackHandler == null) {
            LOG.debug("Trying to create a BinarySecurityToken via a null CallbackHandler");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE);
        }
        Callback[] callback = new TokenElementCallback[]{new TokenElementCallback()};
        try {
            callbackHandler.handle(callback);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException while creating a token element", e);
        }
        catch (UnsupportedCallbackException e) {
            throw new IllegalStateException("UnsupportedCallbackException while creating a token element", e);
        }
        this.element = ((TokenElementCallback)callback[0]).getTokenElement();
        if (this.element == null) {
            LOG.debug("CallbackHandler did not return a token element");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE);
        }
    }

    public void addWSSENamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
    }

    public void addWSUNamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
    }

    public String getValueType() {
        return this.element.getAttributeNS(null, "ValueType");
    }

    public void setValueType(String type) {
        if (type != null) {
            this.element.setAttributeNS(null, "ValueType", type);
        }
    }

    public String getEncodingType() {
        return this.element.getAttributeNS(null, "EncodingType");
    }

    public void setEncodingType(String encoding) {
        if (encoding != null) {
            this.element.setAttributeNS(null, "EncodingType", encoding);
        }
    }

    public byte[] getToken() {
        if (this.data != null) {
            return this.data;
        }
        StringBuilder builder = new StringBuilder();
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (3 != node.getNodeType()) continue;
            builder.append(((Text)node).getData());
        }
        try {
            return Base64.decode((String)builder.toString());
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }

    public void setToken(byte[] data) throws WSSecurityException {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        if (this.storeBytesInAttachment && this.attachmentCallbackHandler != null) {
            Document document = this.element.getOwnerDocument();
            String attachmentId = "_" + UUID.randomUUID().toString();
            this.element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xop", "http://www.w3.org/2004/08/xop/include");
            Element xopInclude = document.createElementNS("http://www.w3.org/2004/08/xop/include", "xop:Include");
            xopInclude.setAttributeNS(null, "href", "cid:" + attachmentId);
            this.element.appendChild(xopInclude);
            Attachment resultAttachment = new Attachment();
            resultAttachment.setId(attachmentId);
            resultAttachment.setMimeType("application/ciphervalue");
            resultAttachment.setSourceStream((InputStream)new ByteArrayInputStream(data));
            AttachmentResultCallback attachmentResultCallback = new AttachmentResultCallback();
            attachmentResultCallback.setAttachmentId(attachmentId);
            attachmentResultCallback.setAttachment(resultAttachment);
            try {
                this.attachmentCallbackHandler.handle(new Callback[]{attachmentResultCallback});
            }
            catch (Exception e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e);
            }
        } else {
            Text node = this.getFirstNode();
            node.setData(Base64.encode((byte[])data));
            this.setRawToken(data);
        }
    }

    public void setRawToken(byte[] data) {
        this.data = Arrays.copyOf(data, data.length);
    }

    public void encodeRawToken() {
        if (this.data == null) {
            throw new IllegalArgumentException("data == null");
        }
        Text node = this.getFirstNode();
        node.setData(Base64.encode((byte[])this.data));
    }

    private Text getFirstNode() {
        Node node;
        for (node = this.element.getFirstChild(); node != null && 3 != node.getNodeType(); node = node.getNextSibling()) {
        }
        if (node instanceof Text) {
            return (Text)node;
        }
        node = this.element.getFirstChild();
        while (node != null) {
            Node nextNode = node.getNextSibling();
            this.element.removeChild(node);
            node = nextNode;
        }
        Text textNode = this.element.getOwnerDocument().createTextNode("");
        return (Text)this.element.appendChild(textNode);
    }

    public Element getElement() {
        return this.element;
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public void setID(String id) {
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
    }

    public String toString() {
        return DOM2Writer.nodeToString((Node)this.element);
    }

    public int hashCode() {
        int result = 17;
        byte[] token = this.getToken();
        if (token != null) {
            result = 31 * result + Arrays.hashCode(token);
        }
        result = 31 * result + this.getValueType().hashCode();
        result = 31 * result + this.getEncodingType().hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BinarySecurity)) {
            return false;
        }
        BinarySecurity binarySecurity = (BinarySecurity)object;
        byte[] token = binarySecurity.getToken();
        if (!Arrays.equals(token, this.getToken())) {
            return false;
        }
        String valueType = binarySecurity.getValueType();
        if (!valueType.equals(this.getValueType())) {
            return false;
        }
        String encodingType = binarySecurity.getEncodingType();
        return encodingType.equals(this.getEncodingType());
    }

    public boolean isStoreBytesInAttachment() {
        return this.storeBytesInAttachment;
    }

    public void setStoreBytesInAttachment(boolean storeBytesInAttachment) {
        this.storeBytesInAttachment = storeBytesInAttachment;
    }
}

