/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collections;
import java.util.Properties;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.wss4j.common.crypto.CertificateStore;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CertsUtils.class);

    private CertsUtils() {
    }

    public static X509Certificate getX509CertificateFromFile(String filename) throws CertificateException {
        return CertsUtils.getX509CertificateFromFile(filename, Thread.currentThread().getContextClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate getX509CertificateFromFile(String filename, ClassLoader classLoader) throws CertificateException {
        if (filename == null) {
            return null;
        }
        ClassLoader cl = classLoader;
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        try (InputStream is = Merlin.loadInputStream((ClassLoader)cl, (String)filename);){
            Throwable throwable;
            BufferedInputStream bis;
            block19: {
                bis = new BufferedInputStream(is);
                throwable = null;
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                if (bis.available() <= 0) break block19;
                Certificate cert = cf.generateCertificate(bis);
                if (!(cert instanceof X509Certificate)) {
                    LOG.error("Certificate " + filename + " is not of type X509Certificate");
                    throw new RuntimeException("Certificate " + filename + " is not of type X509Certificate");
                }
                if (bis.available() > 0) {
                    LOG.warn("There are more certificates configured in " + filename + ". Only first is parsed");
                }
                X509Certificate x509Certificate = (X509Certificate)cert;
                CertsUtils.$closeResource(throwable, bis);
                return x509Certificate;
            }
            try {
                try {
                    LOG.error("No bytes can be read in certificate file " + filename);
                    throw new RuntimeException("No bytes can be read in certificate file " + filename);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                CertsUtils.$closeResource(throwable, bis);
                throw throwable3;
            }
        }
        catch (WSSecurityException ex) {
            LOG.error("Failed to read certificate file " + filename, (Throwable)ex);
            throw new RuntimeException("Failed to read certificate file " + filename, ex);
        }
        catch (IOException ex) {
            LOG.error("Failed to read keystore", (Throwable)ex);
            throw new RuntimeException("Failed to read keystore");
        }
    }

    public static X509Certificate getX509CertificateFromCrypto(Crypto crypto, String keyAlias) throws WSSecurityException {
        if (keyAlias == null || "".equals(keyAlias)) {
            keyAlias = crypto.getDefaultX509Identifier();
        }
        if (keyAlias == null) {
            throw new RuntimeException("No keystore alias was specified to sign the metadata");
        }
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias(keyAlias);
        X509Certificate[] issuerCerts = crypto.getX509Certificates(cryptoType);
        if (issuerCerts == null || issuerCerts.length == 0) {
            throw new RuntimeException("No issuer certs were found to sign the metadata using issuer name: " + keyAlias);
        }
        return issuerCerts[0];
    }

    public static X509Certificate parseX509Certificate(String certificate) throws CertificateException, WSSecurityException, ProcessingException, IOException {
        block6: {
            boolean isCertificateLocation;
            if (certificate == null) {
                return null;
            }
            boolean bl = isCertificateLocation = !certificate.startsWith("-----BEGIN CERTIFICATE");
            if (isCertificateLocation) {
                try {
                    return CertsUtils.getX509CertificateFromFile(certificate);
                }
                catch (CertificateException ex) {
                    Crypto crypto = CertsUtils.getCryptoFromFile(certificate);
                    if (crypto == null) break block6;
                    return CertsUtils.getX509CertificateFromCrypto(crypto, null);
                }
            }
        }
        try {
            return CertsUtils.parseCertificate(certificate);
        }
        catch (Exception ex) {
            LOG.error("Failed to parse trusted certificate", (Throwable)ex);
            throw new ProcessingException("Failed to parse trusted certificate");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Crypto getCryptoFromFile(String filename) {
        Properties prop = new Properties();
        try (InputStream is = Merlin.loadInputStream((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)filename);){
            prop.load(is);
            Crypto crypto = CryptoFactory.getInstance((Properties)prop);
            return crypto;
        }
        catch (WSSecurityException ex) {
            LOG.error("Failed to load keystore " + prop.toString(), (Throwable)ex);
            throw new RuntimeException("Failed to load keystore " + prop.toString());
        }
        catch (IOException ex) {
            LOG.error("Failed to read signing metadata key", (Throwable)ex);
            throw new RuntimeException("Failed to read signing metadata key");
        }
    }

    public static Crypto getCryptoFromCertificate(String certificate) throws ProcessingException {
        X509Certificate cert;
        boolean isCertificateLocation;
        if (certificate == null) {
            return null;
        }
        boolean bl = isCertificateLocation = !certificate.startsWith("-----BEGIN CERTIFICATE");
        if (isCertificateLocation) {
            try {
                X509Certificate cert2 = CertsUtils.getX509CertificateFromFile(certificate);
                if (cert2 == null) {
                    return null;
                }
                return new CertificateStore(new X509Certificate[]{cert2});
            }
            catch (CertificateException ex) {
                return CertsUtils.getCryptoFromFile(certificate);
            }
        }
        try {
            cert = CertsUtils.parseCertificate(certificate);
        }
        catch (Exception ex) {
            LOG.error("Failed to parse trusted certificate", (Throwable)ex);
            throw new ProcessingException("Failed to parse trusted certificate");
        }
        return new CertificateStore(Collections.singletonList(cert).toArray(new X509Certificate[0]));
    }

    private static X509Certificate parseCertificate(String certificate) throws CertificateException, IOException {
        byte[] decoded = Base64.getDecoder().decode(certificate.replaceAll("-----BEGIN CERTIFICATE-----", "").replaceAll("-----END CERTIFICATE-----", ""));
        try (ByteArrayInputStream is = new ByteArrayInputStream(decoded);){
            X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(is);
            return x509Certificate;
        }
    }
}

