/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.processor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.Signature;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.zip.DataFormatException;
import javax.security.auth.DestroyFailedException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.fediz.core.Claim;
import org.apache.cxf.fediz.core.RequestState;
import org.apache.cxf.fediz.core.TokenValidator;
import org.apache.cxf.fediz.core.TokenValidatorRequest;
import org.apache.cxf.fediz.core.TokenValidatorResponse;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.KeyManager;
import org.apache.cxf.fediz.core.config.SAMLProtocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.metadata.MetadataWriter;
import org.apache.cxf.fediz.core.processor.AbstractFedizProcessor;
import org.apache.cxf.fediz.core.processor.ClaimsProcessor;
import org.apache.cxf.fediz.core.processor.FedizRequest;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.apache.cxf.fediz.core.processor.RedirectionResponse;
import org.apache.cxf.fediz.core.samlsso.CompressionUtils;
import org.apache.cxf.fediz.core.samlsso.SAMLPRequestBuilder;
import org.apache.cxf.fediz.core.samlsso.SAMLProtocolResponseValidator;
import org.apache.cxf.fediz.core.samlsso.SAMLSSOResponseValidator;
import org.apache.cxf.fediz.core.samlsso.SSOValidatorResponse;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.cxf.fediz.core.util.DOMUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.DOM2Writer;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleKeyInfoReferenceEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLProcessorImpl
extends AbstractFedizProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLProcessorImpl.class);

    @Override
    public FedizResponse processRequest(FedizRequest request, FedizContext config) throws ProcessingException {
        if (!(config.getProtocol() instanceof SAMLProtocol)) {
            LOG.error("Unsupported protocol");
            throw new IllegalStateException("Unsupported protocol");
        }
        if (request.getResponseToken() == null) {
            LOG.error("Missing response token parameter");
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        if (request.isSignOutResponse()) {
            return this.processSignOutResponse(request, config);
        }
        if (request.getState() == null && config.isRequestStateValidation()) {
            LOG.error("Missing RelayState parameter");
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        return this.processSignInRequest(request, config);
    }

    @Override
    public Document getMetaData(HttpServletRequest request, FedizContext config) throws ProcessingException {
        return new MetadataWriter().getMetaData(request, config);
    }

    private RequestState processRelayState(String relayState, RequestState requestState, FedizContext config) throws ProcessingException {
        if (config.isRequestStateValidation() && (relayState.getBytes().length <= 0 || relayState.getBytes().length > 80)) {
            LOG.error("Invalid RelayState");
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        return requestState;
    }

    protected FedizResponse processSignInRequest(FedizRequest request, FedizContext config) throws ProcessingException {
        List<ClaimsProcessor> processors;
        SAMLProtocol protocol = (SAMLProtocol)config.getProtocol();
        RequestState requestState = this.processRelayState(request.getState(), request.getRequestState(), config);
        XMLObject responseObject = SAMLProcessorImpl.getXMLObjectFromToken(request.getResponseToken(), protocol.isDisableDeflateEncoding());
        if (!(responseObject instanceof Response)) {
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        this.decryptEncryptedAssertions((Response)responseObject, config);
        this.validateSamlResponseProtocol((StatusResponseType)((Response)responseObject), config);
        SSOValidatorResponse ssoValidatorResponse = this.validateSamlSSOResponse((Response)responseObject, request.getRequest(), requestState, config);
        TokenValidatorResponse validatorResponse = null;
        List assertions = ((Response)responseObject).getAssertions();
        if (assertions.isEmpty()) {
            LOG.debug("No Assertion extracted from SAML Response");
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        Element token = ((Assertion)assertions.get(0)).getDOM();
        List<TokenValidator> validators = protocol.getTokenValidators();
        Iterator<TokenValidator> iterator = validators.iterator();
        if (iterator.hasNext()) {
            TokenValidator validator = iterator.next();
            boolean canHandle = validator.canHandleToken(token);
            if (canHandle) {
                try {
                    TokenValidatorRequest validatorRequest = new TokenValidatorRequest(token, request.getCerts());
                    boolean doNotEnforceAssertionsSigned = ((SAMLProtocol)config.getProtocol()).isDoNotEnforceEncryptedAssertionsSigned() && !((Response)responseObject).getEncryptedAssertions().isEmpty();
                    validatorRequest.setEnforceTokenSigned(!doNotEnforceAssertionsSigned);
                    validatorResponse = validator.validateAndProcessToken(validatorRequest, config);
                }
                catch (ProcessingException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    LOG.warn("Failed to validate token", (Throwable)ex);
                    throw new ProcessingException(ProcessingException.TYPE.TOKEN_INVALID);
                }
            } else {
                LOG.warn("No security token validator found for '" + token.getLocalName() + "'");
                throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
            }
        }
        if (validatorResponse == null) {
            LOG.warn("No token validation response was available");
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        Instant expires = validatorResponse.getExpires();
        if (expires == null) {
            expires = ssoValidatorResponse.getSessionNotOnOrAfter();
        }
        this.testForReplayAttack(validatorResponse.getUniqueTokenId(), config, expires);
        List<Claim> claims = validatorResponse.getClaims();
        this.testForMandatoryClaims(config.getProtocol().getRoleURI(), config.getProtocol().getClaimTypesRequested(), claims);
        if (config.getClaimsProcessor() != null && (processors = config.getClaimsProcessor()) != null) {
            for (ClaimsProcessor cp : processors) {
                LOG.debug("invoking ClaimsProcessor {}", (Object)cp);
                claims = cp.processClaims(claims);
            }
        }
        List<String> roles = this.getRoles(claims, config.getProtocol().getRoleURI());
        FedizResponse fedResponse = new FedizResponse(validatorResponse.getUsername(), validatorResponse.getIssuer(), roles, claims, validatorResponse.getAudience(), validatorResponse.getCreated(), expires, token, validatorResponse.getUniqueTokenId());
        return fedResponse;
    }

    private void decryptEncryptedAssertions(Response responseObject, FedizContext config) throws ProcessingException {
        if (responseObject.getEncryptedAssertions() != null && !responseObject.getEncryptedAssertions().isEmpty()) {
            KeyManager decryptionKeyManager = config.getDecryptionKey();
            if (decryptionKeyManager == null || decryptionKeyManager.getCrypto() == null) {
                LOG.debug("We must have a decryption Crypto instance configured to decrypt encrypted tokens");
                throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
            }
            String keyPassword = decryptionKeyManager.getKeyPassword();
            if (keyPassword == null) {
                LOG.debug("We must have a decryption key password to decrypt encrypted tokens");
                throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
            }
            String keyAlias = decryptionKeyManager.getKeyAlias();
            if (keyAlias == null) {
                LOG.debug("No alias configured for decrypt");
                throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
            }
            try {
                PrivateKey privateKey = decryptionKeyManager.getCrypto().getPrivateKey(keyAlias, keyPassword);
                if (privateKey == null) {
                    LOG.debug("No private key available");
                    throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
                }
                BasicX509Credential cred = new BasicX509Credential(CertsUtils.getX509CertificateFromCrypto(decryptionKeyManager.getCrypto(), keyAlias));
                cred.setPrivateKey(privateKey);
                StaticKeyInfoCredentialResolver resolver = new StaticKeyInfoCredentialResolver((Credential)cred);
                ChainingEncryptedKeyResolver keyResolver = new ChainingEncryptedKeyResolver(Arrays.asList(new InlineEncryptedKeyResolver(), new EncryptedElementTypeEncryptedKeyResolver(), new SimpleRetrievalMethodEncryptedKeyResolver(), new SimpleKeyInfoReferenceEncryptedKeyResolver()));
                Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)resolver, (EncryptedKeyResolver)keyResolver);
                for (EncryptedAssertion encryptedAssertion : responseObject.getEncryptedAssertions()) {
                    Assertion decrypted = decrypter.decrypt(encryptedAssertion);
                    Element decryptedToken = decrypted.getDOM();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Decrypted assertion: {}", (Object)DOM2Writer.nodeToString((Node)decryptedToken));
                    }
                    responseObject.getAssertions().add(decrypted);
                    decryptedToken.getOwnerDocument().getDocumentElement().appendChild(decryptedToken);
                }
            }
            catch (Exception e) {
                LOG.debug("Cannot decrypt assertions", (Throwable)e);
                throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
            }
        }
    }

    private FedizResponse processSignOutResponse(FedizRequest request, FedizContext config) throws ProcessingException {
        SAMLProtocol protocol = (SAMLProtocol)config.getProtocol();
        XMLObject responseObject = SAMLProcessorImpl.getXMLObjectFromToken(request.getResponseToken(), protocol.isDisableDeflateEncoding());
        if (!(responseObject instanceof LogoutResponse)) {
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        LogoutResponse logoutResponse = (LogoutResponse)responseObject;
        this.validateSamlResponseProtocol((StatusResponseType)logoutResponse, config);
        if (!logoutResponse.isSigned()) {
            LOG.debug("The LogoutResponse is not signed");
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        Instant issueInstant = logoutResponse.getIssueInstant().toDate().toInstant();
        FedizResponse fedResponse = new FedizResponse(null, logoutResponse.getIssuer().getValue(), Collections.emptyList(), Collections.emptyList(), null, issueInstant, null, null, logoutResponse.getID());
        return fedResponse;
    }

    private static XMLObject getXMLObjectFromToken(String token, boolean isDisableDeflateEncoding) throws ProcessingException {
        Element el;
        InputStream tokenStream;
        try {
            byte[] deflatedToken = Base64.getDecoder().decode(token);
            tokenStream = isDisableDeflateEncoding ? new ByteArrayInputStream(deflatedToken) : CompressionUtils.inflate(deflatedToken);
        }
        catch (IllegalArgumentException | DataFormatException ex) {
            LOG.warn("Invalid data format", (Throwable)ex);
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        try (InputStream is = tokenStream;){
            el = DOMUtils.readXml(is).getDocumentElement();
        }
        catch (Exception e) {
            LOG.warn("Failed to parse token", (Throwable)e);
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received response: " + DOM2Writer.nodeToString((Node)el));
        }
        try {
            return OpenSAMLUtil.fromDom((Element)el);
        }
        catch (WSSecurityException ex) {
            LOG.debug(ex.getMessage(), (Throwable)ex);
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
    }

    protected void validateSamlResponseProtocol(StatusResponseType samlResponse, FedizContext config) throws ProcessingException {
        try {
            SAMLProtocolResponseValidator protocolValidator = new SAMLProtocolResponseValidator();
            protocolValidator.validateSamlResponse(samlResponse, config);
        }
        catch (WSSecurityException ex) {
            LOG.debug(ex.getMessage(), (Throwable)ex);
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
    }

    protected SSOValidatorResponse validateSamlSSOResponse(Response samlResponse, HttpServletRequest request, RequestState requestState, FedizContext config) throws ProcessingException {
        try {
            boolean doNotEnforceKnownIssuer;
            SAMLSSOResponseValidator ssoResponseValidator = new SAMLSSOResponseValidator();
            String requestURL = request.getRequestURL().toString();
            ssoResponseValidator.setAssertionConsumerURL(requestURL);
            boolean disableClientAddressCheck = ((SAMLProtocol)config.getProtocol()).isDisableClientAddressCheck();
            if (!disableClientAddressCheck) {
                ssoResponseValidator.setClientAddress(request.getRemoteAddr());
            }
            ssoResponseValidator.setEnforceKnownIssuer(!(doNotEnforceKnownIssuer = ((SAMLProtocol)config.getProtocol()).isDoNotEnforceKnownIssuer()));
            ssoResponseValidator.setIssuerIDP(requestState != null ? requestState.getIdpServiceAddress() : null);
            ssoResponseValidator.setRequestId(requestState != null ? requestState.getRequestId() : null);
            ssoResponseValidator.setSpIdentifier(requestState != null ? requestState.getIssuerId() : null);
            boolean doNotEnforceAssertionsSigned = ((SAMLProtocol)config.getProtocol()).isDoNotEnforceEncryptedAssertionsSigned() && !samlResponse.getEncryptedAssertions().isEmpty();
            ssoResponseValidator.setEnforceAssertionsSigned(!doNotEnforceAssertionsSigned);
            ssoResponseValidator.setReplayCache(config.getTokenReplayCache());
            return ssoResponseValidator.validateSamlResponse(samlResponse, false);
        }
        catch (WSSecurityException ex) {
            LOG.debug(ex.getMessage(), (Throwable)ex);
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
    }

    @Override
    public RedirectionResponse createSignInRequest(HttpServletRequest request, FedizContext config) throws ProcessingException {
        try {
            if (!(config.getProtocol() instanceof SAMLProtocol)) {
                LOG.error("Unsupported protocol");
                throw new IllegalStateException("Unsupported protocol");
            }
            String redirectURL = null;
            String issuerURL = this.resolveIssuer(request, config);
            LOG.info("Issuer url: " + issuerURL);
            if (issuerURL != null && !issuerURL.isEmpty()) {
                redirectURL = issuerURL;
            }
            SAMLPRequestBuilder samlpRequestBuilder = ((SAMLProtocol)config.getProtocol()).getSAMLPRequestBuilder();
            Document doc = DOMUtils.createDocument();
            doc.appendChild(doc.createElement("root"));
            String reply = this.resolveReply(request, config);
            if (reply == null || reply.isEmpty()) {
                reply = request.getRequestURL().toString();
            } else {
                try {
                    new URL(reply);
                }
                catch (MalformedURLException ex) {
                    reply = reply.startsWith("/") ? this.extractFullContextPath(request).concat(reply.substring(1)) : this.extractFullContextPath(request).concat(reply);
                }
            }
            String realm = this.resolveWTRealm(request, config);
            AuthnRequest authnRequest = samlpRequestBuilder.createAuthnRequest(realm, reply);
            if (((SAMLProtocol)config.getProtocol()).isSignRequest()) {
                authnRequest.setDestination(redirectURL);
            }
            Element authnRequestElement = OpenSAMLUtil.toDom((XMLObject)authnRequest, (Document)doc);
            String authnRequestEncoded = this.encodeAuthnRequest(authnRequestElement);
            String relayState = URLEncoder.encode(UUID.randomUUID().toString(), "UTF-8");
            RequestState requestState = new RequestState();
            requestState.setTargetAddress(reply);
            requestState.setIdpServiceAddress(redirectURL);
            requestState.setRequestId(authnRequest.getID());
            requestState.setIssuerId(realm);
            requestState.setWebAppContext(authnRequest.getIssuer().getValue());
            requestState.setState(relayState);
            requestState.setCreatedAt(System.currentTimeMillis());
            String urlEncodedRequest = URLEncoder.encode(authnRequestEncoded, "UTF-8");
            String signInQuery = this.resolveSignInQuery(request, config);
            StringBuilder sb = new StringBuilder("SAMLRequest").append('=').append(urlEncodedRequest).append('&').append("RelayState").append('=').append(relayState);
            if (((SAMLProtocol)config.getProtocol()).isSignRequest()) {
                String signature = this.signRequest(config, sb);
                sb.append('&').append("Signature").append('=').append(signature);
            }
            if (signInQuery != null && signInQuery.length() > 0) {
                sb.append('&').append(signInQuery);
            }
            RedirectionResponse response = new RedirectionResponse();
            response.addHeader("Cache-Control", "no-cache, no-store");
            response.addHeader("Pragma", "no-cache");
            response.setRequestState(requestState);
            response.setRedirectionURL(redirectURL + '?' + sb.toString());
            return response;
        }
        catch (Exception ex) {
            LOG.error("Failed to create SignInRequest", (Throwable)ex);
            throw new ProcessingException("Failed to create SignInRequest");
        }
    }

    private String signRequest(FedizContext config, StringBuilder sb) throws Exception {
        Crypto crypto = config.getSigningKey().getCrypto();
        if (crypto == null) {
            LOG.debug("No crypto instance of properties file configured for signature");
            throw new ProcessingException("Failed to Sign Request");
        }
        String signatureUser = config.getSigningKey().getKeyAlias();
        if (signatureUser == null) {
            LOG.debug("No user configured for signature");
            throw new ProcessingException("Failed to Sign Request");
        }
        String signaturePassword = config.getSigningKey().getKeyPassword();
        if (signaturePassword == null) {
            LOG.debug("No signature password available");
            throw new ProcessingException("Failed to Sign Request");
        }
        PrivateKey privateKey = crypto.getPrivateKey(signatureUser, signaturePassword);
        if (privateKey == null) {
            LOG.debug("No private key available");
            throw new ProcessingException("Failed to Sign Request");
        }
        String sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String jceSigAlgo = "SHA1withRSA";
        LOG.debug("automatic sig algo detection: " + privateKey.getAlgorithm());
        if ("DSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            jceSigAlgo = "SHA1withDSA";
        } else {
            switch (((SAMLProtocol)config.getProtocol()).getSignRequestAlgorithm()) {
                case RSA_SHA1: {
                    sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                    jceSigAlgo = "SHA1withRSA";
                    break;
                }
                case RSA_SHA256: {
                    sigAlgo = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
                    jceSigAlgo = "SHA256withRSA";
                    break;
                }
                default: {
                    throw new ProcessingException("Unknown sign algorithm");
                }
            }
        }
        LOG.debug("Using Signature algorithm " + sigAlgo);
        Signature signature = Signature.getInstance(jceSigAlgo);
        signature.initSign(privateKey);
        sb.append('&').append("SigAlg").append('=').append(URLEncoder.encode(sigAlgo, "UTF-8"));
        String requestToSign = sb.toString();
        signature.update(requestToSign.getBytes(StandardCharsets.UTF_8));
        byte[] signBytes = signature.sign();
        String encodedSignature = Base64.getEncoder().encodeToString(signBytes);
        try {
            privateKey.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
        return URLEncoder.encode(encodedSignature, "UTF-8");
    }

    protected String encodeAuthnRequest(Element authnRequest) {
        String requestMessage = DOM2Writer.nodeToString((Node)authnRequest);
        byte[] deflatedBytes = CompressionUtils.deflate(requestMessage.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(deflatedBytes);
    }

    @Override
    public RedirectionResponse createSignOutRequest(HttpServletRequest request, SamlAssertionWrapper token, FedizContext config) throws ProcessingException {
        try {
            if (!(config.getProtocol() instanceof SAMLProtocol)) {
                LOG.error("Unsupported protocol");
                throw new IllegalStateException("Unsupported protocol");
            }
            String redirectURL = ((SAMLProtocol)config.getProtocol()).getIssuerLogoutURL();
            if (redirectURL == null) {
                String issuerURL = this.resolveIssuer(request, config);
                LOG.info("Issuer url: " + issuerURL);
                if (issuerURL != null && !issuerURL.isEmpty()) {
                    redirectURL = issuerURL;
                }
            }
            if (redirectURL == null) {
                LOG.debug("No issuerLogoutURL or issuer parameter specified for logout");
                throw new ProcessingException("Failed to create SignOutRequest");
            }
            SAMLPRequestBuilder samlpRequestBuilder = ((SAMLProtocol)config.getProtocol()).getSAMLPRequestBuilder();
            Document doc = DOMUtils.createDocument();
            doc.appendChild(doc.createElement("root"));
            String realm = this.resolveWTRealm(request, config);
            String reason = "urn:oasis:names:tc:SAML:2.0:logout:user";
            LogoutRequest logoutRequest = samlpRequestBuilder.createLogoutRequest(realm, reason, token);
            if (((SAMLProtocol)config.getProtocol()).isSignRequest()) {
                logoutRequest.setDestination(redirectURL);
            }
            Element logoutRequestElement = OpenSAMLUtil.toDom((XMLObject)logoutRequest, (Document)doc);
            String logoutRequestEncoded = this.encodeAuthnRequest(logoutRequestElement);
            String relayState = URLEncoder.encode(UUID.randomUUID().toString(), "UTF-8");
            String urlEncodedRequest = URLEncoder.encode(logoutRequestEncoded, "UTF-8");
            StringBuilder sb = new StringBuilder("SAMLRequest").append('=').append(urlEncodedRequest).append('&').append("RelayState").append('=').append(relayState);
            if (((SAMLProtocol)config.getProtocol()).isSignRequest()) {
                String signature = this.signRequest(config, sb);
                sb.append('&').append("Signature").append('=').append(signature);
            }
            RedirectionResponse response = new RedirectionResponse();
            response.addHeader("Cache-Control", "no-cache, no-store");
            response.addHeader("Pragma", "no-cache");
            response.setState(relayState);
            response.setRedirectionURL(redirectURL + '?' + sb.toString());
            return response;
        }
        catch (Exception ex) {
            LOG.error("Failed to create SignOutRequest", (Throwable)ex);
            throw new ProcessingException("Failed to create SignOutRequest");
        }
    }

    static {
        OpenSAMLUtil.initSamlEngine();
    }
}

