/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.util;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.ws.security.components.crypto.Crypto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class SignatureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureUtils.class);
    private static final XMLSignatureFactory XML_SIGNATURE_FACTORY = XMLSignatureFactory.getInstance("DOM");

    private SignatureUtils() {
    }

    public static Document signMetaInfo(Crypto crypto, String keyAlias, String keyPassword, Document doc, String referenceID) throws Exception {
        if (keyAlias == null || "".equals(keyAlias)) {
            keyAlias = crypto.getDefaultX509Identifier();
        }
        X509Certificate cert = CertsUtils.getX509Certificate(crypto, keyAlias);
        String signatureMethod = null;
        if ("SHA1withDSA".equals(cert.getSigAlgName())) {
            signatureMethod = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        } else if ("SHA1withRSA".equals(cert.getSigAlgName())) {
            signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else if ("SHA256withRSA".equals(cert.getSigAlgName())) {
            signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else {
            LOG.error("Unsupported signature method: " + cert.getSigAlgName());
            throw new RuntimeException("Unsupported signature method: " + cert.getSigAlgName());
        }
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        transformList.add(XML_SIGNATURE_FACTORY.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        transformList.add(XML_SIGNATURE_FACTORY.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null));
        Reference ref = XML_SIGNATURE_FACTORY.newReference("#" + referenceID, XML_SIGNATURE_FACTORY.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null);
        SignedInfo si = XML_SIGNATURE_FACTORY.newSignedInfo(XML_SIGNATURE_FACTORY.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null), XML_SIGNATURE_FACTORY.newSignatureMethod(signatureMethod, null), Collections.singletonList(ref));
        PrivateKey keyEntry = crypto.getPrivateKey(keyAlias, keyPassword);
        KeyInfoFactory kif = XML_SIGNATURE_FACTORY.getKeyInfoFactory();
        ArrayList<Object> x509Content = new ArrayList<Object>();
        x509Content.add(cert.getSubjectX500Principal().getName());
        x509Content.add(cert);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        DOMSignContext dsc = new DOMSignContext(keyEntry, (Node)doc.getDocumentElement());
        dsc.setIdAttributeNS(doc.getDocumentElement(), null, "ID");
        dsc.setNextSibling(doc.getDocumentElement().getFirstChild());
        XMLSignature signature = XML_SIGNATURE_FACTORY.newXMLSignature(si, ki);
        signature.sign(dsc);
        return doc;
    }
}

