/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.components.crypto.Merlin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CertsUtils.class);

    private CertsUtils() {
    }

    public static X509Certificate getX509Certificate(String filename) {
        Certificate cert = null;
        BufferedInputStream bis = null;
        try {
            InputStream is = Merlin.loadInputStream((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)filename);
            bis = new BufferedInputStream(is);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            if (bis.available() > 0) {
                cert = cf.generateCertificate(bis);
                if (!(cert instanceof X509Certificate)) {
                    LOG.error("Certificate " + filename + " is not of type X509Certificate");
                    throw new RuntimeException("Certificate " + filename + " is not of type X509Certificate");
                }
                if (bis.available() > 0) {
                    LOG.warn("There are more certificates configured in " + filename + ". Only first is parsed");
                }
                X509Certificate x509Certificate = (X509Certificate)cert;
                return x509Certificate;
            }
            try {
                LOG.error("No bytes can be read in certificate file " + filename);
                throw new RuntimeException("No bytes can be read in certificate file " + filename);
            }
            catch (Exception ex) {
                LOG.error("Failed to read certificate file " + filename, (Throwable)ex);
                throw new RuntimeException("Failed to read certificate file " + filename, ex);
            }
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException ex) {
                LOG.error("Failed to close certificate file " + filename, (Throwable)ex);
            }
        }
    }

    public static Crypto createCrypto(String filename) {
        Crypto crypto = null;
        Properties prop = new Properties();
        try {
            InputStream is = Merlin.loadInputStream((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)filename);
            prop.load(is);
            crypto = CryptoFactory.getInstance((Properties)prop);
        }
        catch (WSSecurityException ex) {
            LOG.error("Failed to load keystore " + prop.toString(), (Throwable)ex);
            throw new RuntimeException("Failed to load keystore " + prop.toString());
        }
        catch (IOException ex) {
            LOG.error("Failed to read signing metadata key", (Throwable)ex);
            throw new RuntimeException("Failed to read signing metadata key");
        }
        catch (CredentialException ex) {
            LOG.error("Failed to read signing metadata key", (Throwable)ex);
            throw new RuntimeException("Failed to read signing metadata key");
        }
        return crypto;
    }

    public static X509Certificate getX509Certificate(Crypto crypto, String keyAlias) throws WSSecurityException {
        if (keyAlias == null || "".equals(keyAlias)) {
            keyAlias = crypto.getDefaultX509Identifier();
        }
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias(keyAlias);
        X509Certificate[] issuerCerts = crypto.getX509Certificates(cryptoType);
        if (issuerCerts == null || issuerCerts.length == 0) {
            throw new RuntimeException("No issuer certs were found to sign the metadata using issuer name: " + keyAlias);
        }
        return issuerCerts[0];
    }
}

