/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.saml;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.validate.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlAssertionValidator
extends org.apache.ws.security.validate.SamlAssertionValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SamlAssertionValidator.class);
    private TRUST_TYPE signatureTrustType = TRUST_TYPE.CHAIN_TRUST;
    private Collection<Pattern> subjectDNPatterns = new ArrayList<Pattern>();

    public void setSignatureTrustType(TRUST_TYPE trustType) {
        this.signatureTrustType = trustType;
    }

    public void setSubjectConstraints(List<String> constraints) {
        if (constraints != null) {
            this.subjectDNPatterns = new ArrayList<Pattern>();
            for (String constraint : constraints) {
                this.subjectDNPatterns.add(Pattern.compile(constraint.trim()));
            }
        }
    }

    protected Credential verifySignedAssertion(AssertionWrapper assertion, RequestData data) throws WSSecurityException {
        boolean trust;
        Credential credential = new Credential();
        SAMLKeyInfo samlKeyInfo = assertion.getSignatureKeyInfo();
        credential.setPublicKey(samlKeyInfo.getPublicKey());
        credential.setCertificates(samlKeyInfo.getCerts());
        X509Certificate[] certs = credential.getCertificates();
        PublicKey publicKey = credential.getPublicKey();
        Crypto crypto = this.getCrypto(data);
        if (crypto == null) {
            throw new WSSecurityException(0, "noSigCryptoFile");
        }
        if (certs != null && certs.length > 0) {
            this.validateCertificates(certs);
            trust = false;
            boolean enableRevocation = data.isRevocationEnabled();
            trust = certs.length == 1 ? this.verifyTrustInCert(certs[0], crypto, enableRevocation) : this.verifyTrustInCerts(certs, crypto, enableRevocation);
            if (trust) {
                if (this.signatureTrustType.equals((Object)TRUST_TYPE.CHAIN_TRUST_CONSTRAINTS)) {
                    if (this.matches(certs[0])) {
                        return credential;
                    }
                    throw new WSSecurityException(5);
                }
                return credential;
            }
        }
        if (publicKey != null && (trust = this.validatePublicKey(publicKey, crypto))) {
            return credential;
        }
        throw new WSSecurityException(5);
    }

    protected Crypto getCrypto(RequestData data) {
        return data.getSigCrypto();
    }

    protected void validateCertificates(X509Certificate[] certificates) throws WSSecurityException {
        try {
            for (int i = 0; i < certificates.length; ++i) {
                certificates[i].checkValidity();
            }
        }
        catch (CertificateExpiredException e) {
            throw new WSSecurityException(6, "invalidCert", null, (Throwable)e);
        }
        catch (CertificateNotYetValidException e) {
            throw new WSSecurityException(6, "invalidCert", null, (Throwable)e);
        }
    }

    protected boolean verifyTrustInCert(X509Certificate cert, Crypto crypto, boolean enableRevocation) throws WSSecurityException {
        String subjectString = cert.getSubjectX500Principal().getName();
        String issuerString = cert.getIssuerX500Principal().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transmitted certificate has subject " + subjectString);
            LOG.debug("Transmitted certificate has issuer " + issuerString + " (serial " + issuerSerial + ")");
        }
        boolean isInKeystore = this.isCertificateInKeyStore(crypto, cert);
        if (!enableRevocation && isInKeystore) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Certificate " + subjectString + " found in keystore");
            }
            return true;
        }
        if (!isInKeystore && this.signatureTrustType.equals((Object)TRUST_TYPE.PEER_TRUST)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Certificate " + subjectString + " not found in keystore");
            }
            return false;
        }
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.SUBJECT_DN);
        cryptoType.setSubjectDN(issuerString);
        X509Certificate[] foundCerts = crypto.getX509Certificates(cryptoType);
        if (foundCerts == null || foundCerts.length < 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No certs found in keystore for issuer " + issuerString + " of certificate for " + subjectString);
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Preparing to validate certificate path for issuer " + issuerString);
        }
        X509Certificate[] x509certs = new X509Certificate[foundCerts.length + 1];
        x509certs[0] = cert;
        for (int j = 0; j < foundCerts.length; ++j) {
            x509certs[j + 1] = foundCerts[j];
        }
        if (crypto.verifyTrust(x509certs, enableRevocation)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Certificate path has been verified for certificate with subject " + subjectString);
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Certificate path could not be verified for certificate with subject " + subjectString);
        }
        return false;
    }

    protected boolean isCertificateInKeyStore(Crypto crypto, X509Certificate cert) throws WSSecurityException {
        String issuerString = cert.getIssuerX500Principal().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ISSUER_SERIAL);
        cryptoType.setIssuerSerial(issuerString, issuerSerial);
        X509Certificate[] foundCerts = crypto.getX509Certificates(cryptoType);
        if (foundCerts != null && foundCerts[0] != null && foundCerts[0].equals(cert)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Direct trust for certificate with " + cert.getSubjectX500Principal().getName());
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No certificate found for subject from issuer with " + issuerString + " (serial " + issuerSerial + ")");
        }
        return false;
    }

    protected boolean verifyTrustInCerts(X509Certificate[] certificates, Crypto crypto, boolean enableRevocation) throws WSSecurityException {
        if (certificates == null || certificates.length < 2) {
            return false;
        }
        String subjectString = certificates[0].getSubjectX500Principal().getName();
        if (crypto.verifyTrust(certificates, enableRevocation)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Certificate path has been verified for certificate with subject " + subjectString);
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Certificate path could not be verified for certificate with subject " + subjectString);
        }
        return false;
    }

    protected boolean validatePublicKey(PublicKey publicKey, Crypto crypto) throws WSSecurityException {
        return crypto.verifyTrust(publicKey);
    }

    public boolean matches(X509Certificate cert) {
        if (!this.subjectDNPatterns.isEmpty()) {
            if (cert == null) {
                return false;
            }
            String subjectName = cert.getSubjectX500Principal().getName();
            boolean subjectMatch = false;
            for (Pattern subjectDNPattern : this.subjectDNPatterns) {
                Matcher matcher = subjectDNPattern.matcher(subjectName);
                if (!matcher.matches()) continue;
                subjectMatch = true;
                break;
            }
            if (!subjectMatch) {
                return false;
            }
        }
        return true;
    }

    public static enum TRUST_TYPE {
        CHAIN_TRUST,
        CHAIN_TRUST_CONSTRAINTS,
        PEER_TRUST;

    }
}

