/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.handler;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.fediz.core.spi.HomeRealmCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeRealmCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HomeRealmCallbackHandler.class);

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof HomeRealmCallback) {
                HomeRealmCallback callback = (HomeRealmCallback)callbacks[i];
                String homeRealm = (String)callback.getRequest().getAttribute("whr");
                if (homeRealm == null || homeRealm.length() == 0) {
                    LOG.debug("No home realm found in request");
                    continue;
                }
                LOG.info("Home realm '" + homeRealm + "' found in request");
                callback.setHomeRealm(homeRealm);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

