/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.config;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.cxf.fediz.core.EHCacheTokenReplayCache;
import org.apache.cxf.fediz.core.TokenReplayCache;
import org.apache.cxf.fediz.core.config.FederationProtocol;
import org.apache.cxf.fediz.core.config.KeyManager;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.config.TrustManager;
import org.apache.cxf.fediz.core.config.TrustedIssuer;
import org.apache.cxf.fediz.core.config.jaxb.CertificateStores;
import org.apache.cxf.fediz.core.config.jaxb.ContextConfig;
import org.apache.cxf.fediz.core.config.jaxb.FederationProtocolType;
import org.apache.cxf.fediz.core.config.jaxb.KeyManagersType;
import org.apache.cxf.fediz.core.config.jaxb.KeyStoreType;
import org.apache.cxf.fediz.core.config.jaxb.ProtocolType;
import org.apache.cxf.fediz.core.config.jaxb.TrustManagersType;
import org.apache.cxf.fediz.core.config.jaxb.TrustedIssuerType;
import org.apache.cxf.fediz.core.config.jaxb.TrustedIssuers;
import org.apache.cxf.fediz.core.exception.IllegalConfigurationException;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CertificateStore;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.components.crypto.Merlin;
import org.apache.ws.security.util.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationContext
implements Closeable {
    public static final String CACHE_KEY_PREFIX = "fediz.replay.cache";
    private static final Logger LOG = LoggerFactory.getLogger(FederationContext.class);
    private ContextConfig config;
    private boolean detectExpiredTokens = true;
    private boolean detectReplayedTokens = true;
    private String relativePath;
    private TokenReplayCache<String> replayCache;
    private FederationProtocol protocol;
    private List<TrustManager> certificateStores;
    private KeyManager keyManager;
    private KeyManager decryptionKeyManager;
    private ClassLoader classloader;

    public FederationContext(ContextConfig config) {
        this.config = config;
    }

    public void init() {
        this.getProtocol();
    }

    public List<String> getAudienceUris() {
        return this.config.getAudienceUris().getAudienceItem();
    }

    public List<TrustedIssuer> getTrustedIssuers() {
        TrustedIssuers issuers = this.config.getTrustedIssuers();
        List<TrustedIssuerType> trustManagers = issuers.getIssuer();
        ArrayList<TrustedIssuer> trustedIssuers = new ArrayList<TrustedIssuer>();
        for (TrustedIssuerType manager : trustManagers) {
            trustedIssuers.add(new TrustedIssuer(manager));
        }
        return trustedIssuers;
    }

    public List<TrustManager> getCertificateStores() {
        if (this.certificateStores != null) {
            return this.certificateStores;
        }
        this.certificateStores = new ArrayList<TrustManager>();
        CertificateStores certStores = this.config.getCertificateStores();
        List<TrustManagersType> trustManagers = certStores.getTrustManager();
        for (TrustManagersType manager : trustManagers) {
            TrustManager tm = new TrustManager(manager);
            Crypto crypto = null;
            try {
                if (manager.getKeyStore().getType().equalsIgnoreCase("PEM")) {
                    X509Certificate[] certificates = new X509Certificate[]{this.readX509Certificate(tm.getName())};
                    crypto = new CertificateStore(certificates);
                } else {
                    Properties sigProperties = this.createCryptoProperties(manager);
                    crypto = CryptoFactory.getInstance((Properties)sigProperties);
                }
                tm.setCrypto(crypto);
                this.certificateStores.add(tm);
            }
            catch (WSSecurityException e) {
                LOG.error("Failed to load keystore '" + tm.getName() + "'", (Throwable)e);
                throw new IllegalConfigurationException("Failed to load keystore '" + tm.getName() + "'");
            }
        }
        return this.certificateStores;
    }

    public BigInteger getMaximumClockSkew() {
        if (this.config.getMaximumClockSkew() == null) {
            return BigInteger.valueOf(5L);
        }
        return this.config.getMaximumClockSkew();
    }

    public void setMaximumClockSkew(BigInteger maximumClockSkew) {
        this.config.setMaximumClockSkew(maximumClockSkew);
    }

    public Protocol getProtocol() {
        if (this.protocol != null) {
            return this.protocol;
        }
        ProtocolType type = this.config.getProtocol();
        if (type instanceof FederationProtocolType) {
            this.protocol = new FederationProtocol(type);
            this.protocol.setClassloader(this.getClassloader());
        }
        return this.protocol;
    }

    public KeyManager getSigningKey() {
        if (this.keyManager != null) {
            return this.keyManager;
        }
        if (this.config.getSigningKey() == null) {
            LOG.error("No signing key has been configured");
            throw new IllegalConfigurationException("No signing key has been configured");
        }
        this.keyManager = new KeyManager(this.config.getSigningKey());
        Properties sigProperties = this.createCryptoProperties(this.config.getSigningKey());
        try {
            Crypto crypto = CryptoFactory.getInstance((Properties)sigProperties);
            this.keyManager.setCrypto(crypto);
        }
        catch (WSSecurityException e) {
            String name = this.keyManager.getName();
            this.keyManager = null;
            LOG.error("Failed to load keystore '" + name + "'", (Throwable)e);
            throw new IllegalConfigurationException("Failed to load keystore '" + name + "'");
        }
        return this.keyManager;
    }

    public KeyManager getDecryptionKey() {
        if (this.decryptionKeyManager != null) {
            return this.decryptionKeyManager;
        }
        if (this.config.getTokenDecryptionKey() == null) {
            return null;
        }
        this.decryptionKeyManager = new KeyManager(this.config.getTokenDecryptionKey());
        Properties decProperties = this.createCryptoProperties(this.config.getTokenDecryptionKey());
        try {
            Crypto crypto = CryptoFactory.getInstance((Properties)decProperties);
            this.decryptionKeyManager.setCrypto(crypto);
        }
        catch (WSSecurityException e) {
            String name = this.decryptionKeyManager.getName();
            this.decryptionKeyManager = null;
            LOG.error("Failed to load keystore '" + name + "'", (Throwable)e);
            throw new IllegalConfigurationException("Failed to load keystore '" + name + "'");
        }
        return this.decryptionKeyManager;
    }

    public TokenReplayCache<String> getTokenReplayCache() {
        if (this.replayCache != null) {
            return this.replayCache;
        }
        String replayCacheString = this.config.getTokenReplayCache();
        String cacheKey = "fediz.replay.cache-" + this.config.getName();
        if (replayCacheString == null || "".equals(replayCacheString)) {
            this.replayCache = new EHCacheTokenReplayCache(cacheKey);
        } else {
            try {
                Class replayCacheClass = Loader.loadClass((String)replayCacheString);
                this.replayCache = (TokenReplayCache)replayCacheClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                this.replayCache = new EHCacheTokenReplayCache(cacheKey);
            }
            catch (InstantiationException e) {
                this.replayCache = new EHCacheTokenReplayCache(cacheKey);
            }
            catch (IllegalAccessException e) {
                this.replayCache = new EHCacheTokenReplayCache(cacheKey);
            }
        }
        return this.replayCache;
    }

    public String getName() {
        return this.config.getName();
    }

    public boolean isDetectExpiredTokens() {
        return this.detectExpiredTokens;
    }

    public void setDetectExpiredTokens(boolean detectExpiredTokens) {
        this.detectExpiredTokens = detectExpiredTokens;
    }

    public boolean isDetectReplayedTokens() {
        return this.detectReplayedTokens;
    }

    public void setDetectReplayedTokens(boolean detectReplayedTokens) {
        this.detectReplayedTokens = detectReplayedTokens;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public void close() throws IOException {
        if (this.replayCache != null) {
            this.replayCache.close();
        }
    }

    private Properties createCryptoProperties(TrustManagersType tm) {
        String trustStoreFile = null;
        String trustStorePw = null;
        KeyStoreType ks = tm.getKeyStore();
        if (ks.getFile() == null || ks.getFile().isEmpty()) {
            throw new IllegalStateException("No certificate store configured");
        }
        trustStoreFile = ks.getFile();
        trustStorePw = ks.getPassword();
        File f = new File(trustStoreFile);
        if (!f.exists() && this.getRelativePath() != null && !this.getRelativePath().isEmpty()) {
            trustStoreFile = this.getRelativePath().concat(File.separator + trustStoreFile);
        }
        if (trustStoreFile == null || trustStoreFile.isEmpty()) {
            throw new IllegalConfigurationException("truststoreFile not configured");
        }
        if (trustStorePw == null || trustStorePw.isEmpty()) {
            throw new IllegalConfigurationException("trustStorePw not configured");
        }
        Properties p = new Properties();
        p.put("org.apache.ws.security.crypto.provider", "org.apache.ws.security.components.crypto.Merlin");
        p.put("org.apache.ws.security.crypto.merlin.keystore.type", "jks");
        p.put("org.apache.ws.security.crypto.merlin.keystore.password", trustStorePw);
        p.put("org.apache.ws.security.crypto.merlin.keystore.file", trustStoreFile);
        return p;
    }

    private Properties createCryptoProperties(KeyManagersType km) {
        String keyStoreFile = null;
        String keyStorePw = null;
        String keyType = "jks";
        KeyStoreType ks = km.getKeyStore();
        if (ks.getFile() == null || ks.getFile().isEmpty()) {
            throw new IllegalStateException("No certificate store configured");
        }
        keyStoreFile = ks.getFile();
        keyStorePw = ks.getPassword();
        File f = new File(keyStoreFile);
        if (!f.exists() && this.getRelativePath() != null && !this.getRelativePath().isEmpty()) {
            keyStoreFile = this.getRelativePath().concat(File.separator + keyStoreFile);
        }
        if (keyStoreFile == null || keyStoreFile.isEmpty()) {
            throw new IllegalConfigurationException("truststoreFile not configured");
        }
        if (keyStorePw == null || keyStorePw.isEmpty()) {
            throw new IllegalConfigurationException("trustStorePw not configured");
        }
        if (ks.getType() != null) {
            keyType = ks.getType();
        }
        Properties p = new Properties();
        p.put("org.apache.ws.security.crypto.provider", "org.apache.ws.security.components.crypto.Merlin");
        p.put("org.apache.ws.security.crypto.merlin.keystore.type", keyType);
        p.put("org.apache.ws.security.crypto.merlin.keystore.password", keyStorePw);
        p.put("org.apache.ws.security.crypto.merlin.keystore.file", keyStoreFile);
        return p;
    }

    private X509Certificate readX509Certificate(String filename) {
        Certificate cert = null;
        BufferedInputStream bis = null;
        try {
            ClassLoader cl = this.getClassloader();
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            InputStream is = Merlin.loadInputStream((ClassLoader)cl, (String)filename);
            bis = new BufferedInputStream(is);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            if (bis.available() > 0) {
                cert = cf.generateCertificate(bis);
                if (!(cert instanceof X509Certificate)) {
                    LOG.error("Certificate " + filename + " is not of type X509Certificate");
                    throw new IllegalConfigurationException("Certificate " + filename + " is not of type X509Certificate");
                }
                if (bis.available() > 0) {
                    LOG.warn("There are more certificates configured in " + filename + ". Only first is parsed");
                }
                X509Certificate x509Certificate = (X509Certificate)cert;
                return x509Certificate;
            }
            try {
                LOG.error("No bytes can be read in certificate file " + filename);
                throw new IllegalConfigurationException("No bytes can be read in certificate file " + filename);
            }
            catch (IllegalConfigurationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOG.error("Failed to read certificate file " + filename, (Throwable)ex);
                throw new IllegalConfigurationException("Failed to read certificate file " + filename, ex);
            }
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException ex) {
                LOG.error("Failed to close certificate file " + filename, (Throwable)ex);
            }
        }
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }
}

