/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.config;

import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.cxf.fediz.core.config.FederationContext;
import org.apache.cxf.fediz.core.config.jaxb.ContextConfig;
import org.apache.cxf.fediz.core.config.jaxb.FedizConfig;

public class FederationConfigurator {
    private FedizConfig rootConfig;
    private JAXBContext jaxbContext;
    private List<FederationContext> federationContextList;

    public FedizConfig loadConfig(File f) throws JAXBException {
        this.rootConfig = (FedizConfig)this.getJaxbContext().createUnmarshaller().unmarshal(f);
        this.parseFederationContextList();
        return this.rootConfig;
    }

    public FedizConfig loadConfig(Reader reader) throws JAXBException {
        this.rootConfig = (FedizConfig)this.getJaxbContext().createUnmarshaller().unmarshal(reader);
        this.parseFederationContextList();
        return this.rootConfig;
    }

    private void parseFederationContextList() {
        this.federationContextList = new ArrayList<FederationContext>();
        for (ContextConfig config : this.rootConfig.getContextConfig()) {
            this.federationContextList.add(new FederationContext(config));
        }
    }

    public void saveConfiguration(File f) throws JAXBException {
        if (f.canWrite()) {
            this.jaxbContext.createMarshaller().marshal((Object)this.rootConfig, f);
        }
    }

    public void saveConfiguration(Writer writer) throws JAXBException {
        this.jaxbContext.createMarshaller().marshal((Object)this.rootConfig, writer);
    }

    private JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FedizConfig.class});
        }
        return this.jaxbContext;
    }

    public List<FederationContext> getFederationContextList() {
        return this.federationContextList;
    }

    public FederationContext getFederationContext(String contextName) {
        if (contextName == null || contextName.isEmpty()) {
            throw new IllegalArgumentException("Invalid Context Name '" + contextName + "'");
        }
        if (this.rootConfig == null) {
            throw new IllegalArgumentException("No configuration loaded");
        }
        for (FederationContext fedContext : this.federationContextList) {
            if (!fedContext.getName().equals(contextName)) continue;
            fedContext.init();
            return fedContext;
        }
        return null;
    }

    public ContextConfig getContextConfig(String contextName) throws IllegalArgumentException {
        if (contextName == null || contextName.isEmpty()) {
            throw new IllegalArgumentException("Invalid Context Name '" + contextName + "'");
        }
        if (this.rootConfig == null) {
            throw new IllegalArgumentException("No configuration loaded");
        }
        for (ContextConfig config : this.rootConfig.getContextConfig()) {
            if (!contextName.equals(config.getName())) continue;
            return config;
        }
        return null;
    }
}

