/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.fediz.core.TokenReplayCache;

public final class InMemoryTokenReplayCache<T>
implements TokenReplayCache<T> {
    private List<T> cache = Collections.synchronizedList(new ArrayList());

    @Override
    public T getId(T id) {
        int index = this.cache.indexOf(id);
        if (index == -1) {
            return null;
        }
        return this.cache.get(index);
    }

    @Override
    public void putId(T id) {
        this.cache.add(id);
    }

    @Override
    public void putId(T id, long timeToLive) {
        this.cache.add(id);
    }

    @Override
    public void close() throws IOException {
        if (this.cache != null) {
            this.cache.clear();
            this.cache = null;
        }
    }
}

