/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.fediz.core.FederationProcessor;
import org.apache.cxf.fediz.core.FederationRequest;
import org.apache.cxf.fediz.core.FederationResponse;
import org.apache.cxf.fediz.core.TokenValidator;
import org.apache.cxf.fediz.core.TokenValidatorRequest;
import org.apache.cxf.fediz.core.TokenValidatorResponse;
import org.apache.cxf.fediz.core.config.FederationContext;
import org.apache.cxf.fediz.core.config.FederationProtocol;
import org.apache.cxf.fediz.core.config.KeyManager;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.metadata.MetadataWriter;
import org.apache.cxf.fediz.core.spi.FreshnessCallback;
import org.apache.cxf.fediz.core.spi.HomeRealmCallback;
import org.apache.cxf.fediz.core.spi.IDPCallback;
import org.apache.cxf.fediz.core.spi.RealmCallback;
import org.apache.cxf.fediz.core.spi.SignInQueryCallback;
import org.apache.cxf.fediz.core.spi.WAuthCallback;
import org.apache.cxf.fediz.core.spi.WReqCallback;
import org.apache.cxf.fediz.core.util.DOMUtils;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.processor.EncryptedDataProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FederationProcessorImpl
implements FederationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FederationProcessorImpl.class);

    @Override
    public FederationResponse processRequest(FederationRequest request, FederationContext config) throws ProcessingException {
        if (!(config.getProtocol() instanceof FederationProtocol)) {
            LOG.error("Unsupported protocol");
            throw new IllegalStateException("Unsupported protocol");
        }
        FederationResponse response = null;
        if (!"wsignin1.0".equals(request.getWa())) {
            LOG.error("Invalid action '" + request.getWa() + "'");
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        response = this.processSignInRequest(request, config);
        return response;
    }

    @Override
    public Document getMetaData(FederationContext config) throws ProcessingException {
        return new MetadataWriter().getMetaData(config);
    }

    protected FederationResponse processSignInRequest(FederationRequest request, FederationContext config) throws ProcessingException {
        Element decryptedRST;
        byte[] wresult = request.getWresult().getBytes();
        Document doc = null;
        Element el = null;
        try {
            doc = DOMUtils.readXml(new ByteArrayInputStream(wresult));
            el = doc.getDocumentElement();
        }
        catch (Exception e) {
            LOG.warn("Failed to parse wresult: " + e.getMessage());
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        if ("RequestSecurityTokenResponseCollection".equals(el.getLocalName())) {
            el = DOMUtils.getFirstElement(el);
        }
        if (!"RequestSecurityTokenResponse".equals(el.getLocalName())) {
            LOG.warn("Unexpected root element of wresult: '" + el.getLocalName() + "'");
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        el = DOMUtils.getFirstElement(el);
        Object rst = null;
        Element lifetimeElem = null;
        String tt = null;
        while (el != null) {
            String ln = el.getLocalName();
            if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(el.getNamespaceURI()) || "http://schemas.xmlsoap.org/ws/2005/02/trust".equals(el.getNamespaceURI())) {
                if ("Lifetime".equals(ln)) {
                    lifetimeElem = el;
                } else if ("RequestedSecurityToken".equals(ln)) {
                    rst = DOMUtils.getFirstElement(el);
                } else if ("TokenType".equals(ln)) {
                    tt = DOMUtils.getContent(el);
                }
            }
            el = DOMUtils.getNextElement(el);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RST: " + (rst != null ? rst.toString() : "null"));
            LOG.debug("Lifetime: " + (lifetimeElem != null ? lifetimeElem.toString() : "null"));
            LOG.debug("Tokentype: " + (tt != null ? tt.toString() : "null"));
        }
        if (rst == null) {
            LOG.warn("RequestedSecurityToken element not found in wresult");
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        LifeTime lifeTime = null;
        if (lifetimeElem != null) {
            lifeTime = this.processLifeTime(lifetimeElem);
        }
        if (config.isDetectExpiredTokens() && lifeTime != null) {
            Date currentDate = new Date();
            if (currentDate.after(lifeTime.getExpires())) {
                LOG.warn("RSTR Lifetime expired");
                throw new ProcessingException(ProcessingException.TYPE.TOKEN_EXPIRED);
            }
            DateTime currentTime = new DateTime();
            DateTime validFrom = new DateTime((Object)lifeTime.created);
            if (validFrom.isAfter((ReadableInstant)(currentTime = currentTime.plusSeconds(config.getMaximumClockSkew().intValue())))) {
                LOG.debug("RSTR Lifetime not yet valid");
                throw new ProcessingException(ProcessingException.TYPE.TOKEN_INVALID);
            }
        }
        if ("EncryptedData".equals(rst.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(rst.getNamespaceURI()) && (decryptedRST = this.decryptEncryptedRST((Element)rst, config)) != null) {
            rst = decryptedRST;
        }
        TokenValidatorResponse validatorResponse = null;
        List<TokenValidator> validators = ((FederationProtocol)config.getProtocol()).getTokenValidators();
        Iterator<TokenValidator> i$ = validators.iterator();
        if (i$.hasNext()) {
            TokenValidator validator = i$.next();
            boolean canHandle = false;
            canHandle = tt != null ? validator.canHandleTokenType(tt) : validator.canHandleToken((Element)rst);
            if (canHandle) {
                try {
                    TokenValidatorRequest validatorRequest = new TokenValidatorRequest((Element)rst, request.getCerts());
                    validatorResponse = validator.validateAndProcessToken(validatorRequest, config);
                }
                catch (ProcessingException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    LOG.warn("Failed to validate token", (Throwable)ex);
                    throw new ProcessingException(ProcessingException.TYPE.TOKEN_INVALID);
                }
            } else {
                LOG.warn("No security token validator found for '" + tt + "'");
                throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
            }
        }
        if (validatorResponse.getUniqueTokenId() != null && config.isDetectReplayedTokens()) {
            if (config.getTokenReplayCache().getId(validatorResponse.getUniqueTokenId()) == null) {
                Date expires = null;
                expires = lifeTime != null && lifeTime.getExpires() != null ? lifeTime.getExpires() : validatorResponse.getExpires();
                if (expires != null) {
                    Date currentTime = new Date();
                    long ttl = expires.getTime() - currentTime.getTime();
                    config.getTokenReplayCache().putId(validatorResponse.getUniqueTokenId(), ttl / 1000L);
                } else {
                    config.getTokenReplayCache().putId(validatorResponse.getUniqueTokenId());
                }
            } else {
                LOG.error("Replay attack with token id: " + validatorResponse.getUniqueTokenId());
                throw new ProcessingException("Replay attack with token id: " + validatorResponse.getUniqueTokenId(), ProcessingException.TYPE.TOKEN_REPLAY);
            }
        }
        FederationResponse fedResponse = new FederationResponse(validatorResponse.getUsername(), validatorResponse.getIssuer(), validatorResponse.getRoles(), validatorResponse.getClaims(), validatorResponse.getAudience(), lifeTime != null ? lifeTime.getCreated() : null, lifeTime != null ? lifeTime.getExpires() : null, (Element)rst, validatorResponse.getUniqueTokenId());
        return fedResponse;
    }

    private Element decryptEncryptedRST(Element encryptedRST, FederationContext config) throws ProcessingException {
        KeyManager decryptionKeyManager = config.getDecryptionKey();
        if (decryptionKeyManager == null || decryptionKeyManager.getCrypto() == null) {
            LOG.debug("We must have a decryption Crypto instance configured to decrypt encrypted tokens");
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        String keyPassword = decryptionKeyManager.getKeyPassword();
        if (keyPassword == null) {
            LOG.debug("We must have a decryption key password to decrypt encrypted tokens");
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        EncryptedDataProcessor proc = new EncryptedDataProcessor();
        WSDocInfo docInfo = new WSDocInfo(encryptedRST.getOwnerDocument());
        RequestData data = new RequestData();
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setProcessor(WSSecurityEngine.SAML_TOKEN, (Processor)new NOOpProcessor());
        wssConfig.setProcessor(WSSecurityEngine.SAML2_TOKEN, (Processor)new NOOpProcessor());
        data.setWssConfig(wssConfig);
        data.setDecCrypto(decryptionKeyManager.getCrypto());
        data.setCallbackHandler((CallbackHandler)new DecryptionCallbackHandler(keyPassword));
        try {
            List dataRefs;
            List result = proc.handleToken(encryptedRST, data, docInfo);
            if (result.size() > 0 && (dataRefs = (List)((WSSecurityEngineResult)result.get(result.size() - 1)).get((Object)"data-ref-uris")) != null && dataRefs.size() > 0) {
                return ((WSDataRef)dataRefs.get(0)).getProtectedElement();
            }
        }
        catch (WSSecurityException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new ProcessingException(ProcessingException.TYPE.TOKEN_INVALID);
        }
        return null;
    }

    private LifeTime processLifeTime(Element lifetimeElem) throws ProcessingException {
        try {
            Element createdElem = DOMUtils.getFirstChildWithName(lifetimeElem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            Date created = zulu.parse(DOMUtils.getContent(createdElem));
            Element expiresElem = DOMUtils.getFirstChildWithName(lifetimeElem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires");
            Date expires = zulu.parse(DOMUtils.getContent(expiresElem));
            return new LifeTime(created, expires);
        }
        catch (ParseException e) {
            LOG.error("Failed to parse lifetime element in wresult: " + e.getMessage());
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
    }

    @Override
    public String createSignInRequest(HttpServletRequest request, FederationContext config) throws ProcessingException {
        String redirectURL = null;
        try {
            if (!(config.getProtocol() instanceof FederationProtocol)) {
                LOG.error("Unsupported protocol");
                throw new IllegalStateException("Unsupported protocol");
            }
            String issuerURL = this.resolveIssuer(request, config);
            LOG.info("Issuer url: " + issuerURL);
            if (issuerURL != null && issuerURL.length() > 0) {
                redirectURL = issuerURL;
            }
            String wAuth = this.resolveAuthenticationType(request, config);
            LOG.info("WAuth: " + wAuth);
            String wReq = this.resolveRequest(request, config);
            LOG.info("WReq: " + wReq);
            String homeRealm = this.resolveHomeRealm(request, config);
            LOG.info("HomeRealm: " + homeRealm);
            String freshness = this.resolveFreshness(request, config);
            LOG.info("Freshness: " + freshness);
            String signInQuery = this.resolveSignInQuery(request, config);
            LOG.info("SignIn Query: " + signInQuery);
            StringBuilder sb = new StringBuilder();
            sb.append("wa").append('=').append("wsignin1.0");
            String reply = ((FederationProtocol)config.getProtocol()).getReply();
            if (reply == null || reply.length() == 0) {
                reply = request.getRequestURL().toString();
            } else {
                try {
                    new URL(reply);
                }
                catch (MalformedURLException ex) {
                    reply = reply.startsWith("/") ? this.extractFullContextPath(request).concat(reply.substring(1)) : this.extractFullContextPath(request).concat(reply);
                }
            }
            LOG.debug("wreply=" + reply);
            sb.append('&').append("wreply").append('=');
            sb.append(URLEncoder.encode(reply, "UTF-8"));
            String realm = this.resolveWTRealm(request, config);
            LOG.debug("wtrealm=" + realm);
            sb.append('&').append("wtrealm").append('=').append(URLEncoder.encode(realm, "UTF-8"));
            if (wAuth != null && wAuth.length() > 0) {
                sb.append('&').append("wauth").append('=').append(URLEncoder.encode(wAuth, "UTF-8"));
            }
            if (wReq != null && wReq.length() > 0) {
                sb.append('&').append("wreq").append('=').append(URLEncoder.encode(wReq, "UTF-8"));
            }
            if (homeRealm != null && homeRealm.length() > 0) {
                sb.append('&').append("whr").append('=').append(URLEncoder.encode(homeRealm, "UTF-8"));
            }
            if (freshness != null && freshness.length() > 0) {
                sb.append('&').append("wfresh").append('=').append(URLEncoder.encode(freshness, "UTF-8"));
            }
            Date creationTime = new Date();
            XmlSchemaDateFormat fmt = new XmlSchemaDateFormat();
            String wct = fmt.format(creationTime);
            sb.append('&').append("wct").append('=').append(URLEncoder.encode(wct, "UTF-8"));
            if (signInQuery != null && signInQuery.length() > 0) {
                sb.append('&').append(signInQuery);
            }
            redirectURL = redirectURL + "?" + sb.toString();
        }
        catch (Exception ex) {
            LOG.error("Failed to create SignInRequest", (Throwable)ex);
            throw new ProcessingException("Failed to create SignInRequest");
        }
        return redirectURL;
    }

    private String resolveSignInQuery(HttpServletRequest request, FederationContext config) throws IOException, UnsupportedCallbackException, UnsupportedEncodingException {
        Object signInQueryObj = ((FederationProtocol)config.getProtocol()).getSignInQuery();
        String signInQuery = null;
        if (signInQueryObj != null) {
            if (signInQueryObj instanceof String) {
                signInQuery = (String)signInQueryObj;
            } else if (signInQueryObj instanceof CallbackHandler) {
                CallbackHandler frCB = (CallbackHandler)signInQueryObj;
                SignInQueryCallback callback = new SignInQueryCallback(request);
                frCB.handle(new Callback[]{callback});
                Map<String, String> signInQueryMap = callback.getSignInQueryParamMap();
                StringBuilder sbQuery = new StringBuilder();
                for (String key : signInQueryMap.keySet()) {
                    if (sbQuery.length() > 0) {
                        sbQuery.append("&");
                    }
                    sbQuery.append(key).append('=').append(URLEncoder.encode(signInQueryMap.get(key), "UTF-8"));
                }
                signInQuery = sbQuery.toString();
            }
        }
        return signInQuery;
    }

    private String resolveFreshness(HttpServletRequest request, FederationContext config) throws IOException, UnsupportedCallbackException {
        Object freshnessObj = ((FederationProtocol)config.getProtocol()).getFreshness();
        String freshness = null;
        if (freshnessObj != null) {
            if (freshnessObj instanceof String) {
                freshness = (String)freshnessObj;
            } else if (freshnessObj instanceof CallbackHandler) {
                CallbackHandler frCB = (CallbackHandler)freshnessObj;
                FreshnessCallback callback = new FreshnessCallback(request);
                frCB.handle(new Callback[]{callback});
                freshness = callback.getFreshness();
            }
        }
        return freshness;
    }

    private String resolveHomeRealm(HttpServletRequest request, FederationContext config) throws IOException, UnsupportedCallbackException {
        Object homeRealmObj = ((FederationProtocol)config.getProtocol()).getHomeRealm();
        String homeRealm = null;
        if (homeRealmObj != null) {
            if (homeRealmObj instanceof String) {
                homeRealm = (String)homeRealmObj;
            } else if (homeRealmObj instanceof CallbackHandler) {
                CallbackHandler hrCB = (CallbackHandler)homeRealmObj;
                HomeRealmCallback callback = new HomeRealmCallback(request);
                hrCB.handle(new Callback[]{callback});
                homeRealm = callback.getHomeRealm();
            }
        }
        return homeRealm;
    }

    private String resolveAuthenticationType(HttpServletRequest request, FederationContext config) throws IOException, UnsupportedCallbackException {
        Object wAuthObj = ((FederationProtocol)config.getProtocol()).getAuthenticationType();
        String wAuth = null;
        if (wAuthObj != null) {
            if (wAuthObj instanceof String) {
                wAuth = (String)wAuthObj;
            } else if (wAuthObj instanceof CallbackHandler) {
                CallbackHandler wauthCB = (CallbackHandler)wAuthObj;
                WAuthCallback callback = new WAuthCallback(request);
                wauthCB.handle(new Callback[]{callback});
                wAuth = callback.getWauth();
            }
        }
        return wAuth;
    }

    private String resolveRequest(HttpServletRequest request, FederationContext config) throws IOException, UnsupportedCallbackException {
        Object wReqObj = ((FederationProtocol)config.getProtocol()).getRequest();
        String wReq = null;
        if (wReqObj != null) {
            if (wReqObj instanceof String) {
                wReq = (String)wReqObj;
            } else if (wReqObj instanceof CallbackHandler) {
                CallbackHandler wauthCB = (CallbackHandler)wReqObj;
                WReqCallback callback = new WReqCallback(request);
                wauthCB.handle(new Callback[]{callback});
                wReq = callback.getWreq();
            }
        }
        return wReq;
    }

    private String resolveIssuer(HttpServletRequest request, FederationContext config) throws IOException, UnsupportedCallbackException {
        Object issuerObj = ((FederationProtocol)config.getProtocol()).getIssuer();
        String issuerURL = null;
        if (issuerObj instanceof String) {
            issuerURL = (String)issuerObj;
        } else if (issuerObj instanceof CallbackHandler) {
            CallbackHandler issuerCB = (CallbackHandler)issuerObj;
            IDPCallback callback = new IDPCallback(request);
            issuerCB.handle(new Callback[]{callback});
            issuerURL = callback.getIssuerUrl().toString();
        }
        return issuerURL;
    }

    private String resolveWTRealm(HttpServletRequest request, FederationContext config) throws IOException, UnsupportedCallbackException {
        Object wtRealmObj = ((FederationProtocol)config.getProtocol()).getRealm();
        String wtRealm = null;
        if (wtRealmObj != null) {
            if (wtRealmObj instanceof String) {
                wtRealm = (String)wtRealmObj;
            } else if (wtRealmObj instanceof CallbackHandler) {
                CallbackHandler hrCB = (CallbackHandler)wtRealmObj;
                RealmCallback callback = new RealmCallback(request);
                hrCB.handle(new Callback[]{callback});
                wtRealm = callback.getRealm();
            }
        } else {
            wtRealm = this.extractFullContextPath(request);
        }
        return wtRealm;
    }

    private String extractFullContextPath(HttpServletRequest request) throws MalformedURLException {
        String result = null;
        String contextPath = request.getContextPath();
        String requestUrl = request.getRequestURL().toString();
        String requestPath = new URL(requestUrl).getPath();
        if (requestPath != null && requestPath.length() > 0) {
            int lastIndex = requestUrl.lastIndexOf(requestPath);
            result = requestUrl.substring(0, lastIndex);
        } else {
            result = requestUrl;
        }
        result = contextPath != null && contextPath.length() > 0 ? result + contextPath + "/" : result + "/";
        return result;
    }

    static {
        WSSConfig.init();
    }

    private static class NOOpProcessor
    implements Processor {
        private NOOpProcessor() {
        }

        public List<WSSecurityEngineResult> handleToken(Element arg0, RequestData arg1, WSDocInfo arg2) throws WSSecurityException {
            return new ArrayList<WSSecurityEngineResult>();
        }
    }

    private static class DecryptionCallbackHandler
    implements CallbackHandler {
        private final String password;

        public DecryptionCallbackHandler(String password) {
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof WSPasswordCallback)) {
                    throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
                }
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                pc.setPassword(this.password);
            }
        }
    }

    public class LifeTime {
        private Date created;
        private Date expires;

        public LifeTime(Date created, Date expires) {
            this.created = created;
            this.expires = expires;
        }

        public Date getCreated() {
            return this.created;
        }

        public Date getExpires() {
            return this.expires;
        }
    }
}

