/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.apache.cxf.fediz.core.EHCacheUtil;
import org.apache.cxf.fediz.core.TokenReplayCache;
import org.apache.ws.security.util.Loader;

public class EHCacheTokenReplayCache
implements TokenReplayCache<String> {
    public static final long DEFAULT_TTL = 3600L;
    public static final long MAX_TTL = 43200L;
    private Ehcache cache;
    private CacheManager cacheManager;
    private long ttl = 3600L;

    public EHCacheTokenReplayCache(String key) {
        String defaultConfigFile = "/fediz-ehcache.xml";
        URL configFileURL = Loader.getResource((String)defaultConfigFile);
        this.createCache(key, configFileURL);
    }

    public EHCacheTokenReplayCache(String key, URL configFileURL) {
        this.createCache(key, configFileURL);
    }

    private void createCache(String key, URL configFileURL) {
        if (configFileURL == null) {
            this.cacheManager = CacheManager.create();
        } else {
            Configuration conf = ConfigurationFactory.parseConfiguration((URL)configFileURL);
            this.cacheManager = CacheManager.create((Configuration)conf);
        }
        CacheConfiguration cc = EHCacheUtil.getCacheConfiguration(key, this.cacheManager);
        Cache newCache = new Cache(cc);
        this.cache = this.cacheManager.addCacheIfAbsent((Ehcache)newCache);
        this.ttl = cc.getTimeToLiveSeconds();
    }

    public void setTTL(long newTtl) {
        this.ttl = newTtl;
    }

    public long getTTL() {
        return this.ttl;
    }

    @Override
    public void putId(String id) {
        this.putId(id, this.ttl);
    }

    @Override
    public void putId(String id, long timeToLive) {
        if (id == null || "".equals(id)) {
            return;
        }
        int parsedTTL = (int)timeToLive;
        if ((timeToLive != (long)parsedTTL || parsedTTL < 0 || (long)parsedTTL > 43200L) && this.ttl != (long)(parsedTTL = (int)this.ttl)) {
            parsedTTL = 3600;
        }
        Element cacheElement = new Element((Object)id, (Object)id, Boolean.valueOf(false), Integer.valueOf(parsedTTL), Integer.valueOf(parsedTTL));
        cacheElement.resetAccessStatistics();
        this.cache.put(cacheElement);
    }

    @Override
    public String getId(String id) {
        Element element = this.cache.get((Serializable)((Object)id));
        if (element != null) {
            if (this.cache.isExpired(element)) {
                this.cache.remove((Serializable)((Object)id));
                return null;
            }
            return (String)element.getObjectValue();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
            this.cacheManager = null;
            this.cache = null;
        }
    }
}

