/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public final class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static ClassLoaderHolder setThreadContextClassloader(final ClassLoader newLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoaderHolder>(){

            @Override
            public ClassLoaderHolder run() {
                ClassLoader l = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(newLoader);
                return new ClassLoaderHolder(l);
            }
        });
    }

    public static ClassLoader getURLClassLoader(final URL[] urls, final ClassLoader parent) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(urls, parent);
            }
        });
    }

    public static ClassLoader getURLClassLoader(List<URL> urlList, ClassLoader parent) {
        return ClassLoaderUtils.getURLClassLoader(urlList.toArray(new URL[urlList.size()]), parent);
    }

    public static URL getResource(String resourceName, Class<?> callingClass) {
        ClassLoader cl;
        ClassLoader cluClassloader;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null && resourceName.startsWith("/")) {
            url = Thread.currentThread().getContextClassLoader().getResource(resourceName.substring(1));
        }
        if ((cluClassloader = ClassLoaderUtils.class.getClassLoader()) == null) {
            cluClassloader = ClassLoader.getSystemClassLoader();
        }
        if (url == null) {
            url = cluClassloader.getResource(resourceName);
        }
        if (url == null && resourceName.startsWith("/")) {
            url = cluClassloader.getResource(resourceName.substring(1));
        }
        if (url == null && (cl = callingClass.getClassLoader()) != null) {
            url = cl.getResource(resourceName);
        }
        if (url == null) {
            url = callingClass.getResource(resourceName);
        }
        if (url == null && resourceName != null && resourceName.charAt(0) != '/') {
            return ClassLoaderUtils.getResource('/' + resourceName, callingClass);
        }
        return url;
    }

    public static List<URL> getResources(String resourceName, Class<?> callingClass) {
        URL url;
        ClassLoader cl;
        ClassLoader cluClassloader;
        ArrayList<URL> ret = new ArrayList<URL>();
        Enumeration<URL> urls = new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                return null;
            }
        };
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources(resourceName);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!urls.hasMoreElements() && resourceName.startsWith("/")) {
            try {
                urls = Thread.currentThread().getContextClassLoader().getResources(resourceName.substring(1));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if ((cluClassloader = ClassLoaderUtils.class.getClassLoader()) == null) {
            cluClassloader = ClassLoader.getSystemClassLoader();
        }
        if (!urls.hasMoreElements()) {
            try {
                urls = cluClassloader.getResources(resourceName);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!urls.hasMoreElements() && resourceName.startsWith("/")) {
            try {
                urls = cluClassloader.getResources(resourceName.substring(1));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!urls.hasMoreElements() && (cl = callingClass.getClassLoader()) != null) {
            try {
                urls = cl.getResources(resourceName);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!urls.hasMoreElements() && (url = callingClass.getResource(resourceName)) != null) {
            ret.add(url);
        }
        while (urls.hasMoreElements()) {
            ret.add(urls.nextElement());
        }
        if (ret.isEmpty() && resourceName != null && resourceName.charAt(0) != '/') {
            return ClassLoaderUtils.getResources('/' + resourceName, callingClass);
        }
        return ret;
    }

    public static InputStream getResourceAsStream(String resourceName, Class<?> callingClass) {
        URL url = ClassLoaderUtils.getResource(resourceName, callingClass);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Class<?> loadClass(String className, Class<?> callingClass) throws ClassNotFoundException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return ClassLoaderUtils.loadClass2(className, callingClass);
    }

    public static <T> Class<? extends T> loadClass(String className, Class<?> callingClass, Class<T> type) throws ClassNotFoundException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(className).asSubclass(type);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return ClassLoaderUtils.loadClass2(className, callingClass).asSubclass(type);
    }

    private static Class<?> loadClass2(String className, Class<?> callingClass) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            block5: {
                try {
                    if (ClassLoaderUtils.class.getClassLoader() != null) {
                        return ClassLoaderUtils.class.getClassLoader().loadClass(className);
                    }
                }
                catch (ClassNotFoundException exc) {
                    if (callingClass == null || callingClass.getClassLoader() == null) break block5;
                    return callingClass.getClassLoader().loadClass(className);
                }
            }
            throw ex;
        }
    }

    public static class ClassLoaderHolder {
        ClassLoader loader;

        ClassLoaderHolder(ClassLoader c) {
            this.loader = c;
        }

        public void reset() {
            ClassLoaderUtils.setThreadContextClassloader(this.loader);
        }
    }
}

