/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.saml;

import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;

public final class SAMLUtil {
    private SAMLUtil() {
    }

    public static boolean checkHolderOfKey(AssertionWrapper assertionWrapper, Certificate[] tlsCerts) {
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            if (!OpenSAMLUtil.isMethodHolderOfKey((String)confirmationMethod)) continue;
            if (tlsCerts == null || tlsCerts.length == 0) {
                return false;
            }
            SAMLKeyInfo subjectKeyInfo = assertionWrapper.getSubjectKeyInfo();
            if (SAMLUtil.compareCredentials(subjectKeyInfo, tlsCerts)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareCredentials(SAMLKeyInfo subjectKeyInfo, Certificate[] tlsCerts) {
        X509Certificate[] subjectCerts = subjectKeyInfo.getCerts();
        PublicKey subjectPublicKey = subjectKeyInfo.getPublicKey();
        if (subjectCerts != null && subjectCerts.length > 0 && tlsCerts[0].equals(subjectCerts[0])) {
            return true;
        }
        return subjectPublicKey != null && tlsCerts[0].getPublicKey().equals(subjectPublicKey);
    }
}

