/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.saml;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cxf.fediz.core.Claim;
import org.apache.cxf.fediz.core.ClaimCollection;
import org.apache.cxf.fediz.core.ClaimTypes;
import org.apache.cxf.fediz.core.TokenValidator;
import org.apache.cxf.fediz.core.TokenValidatorRequest;
import org.apache.cxf.fediz.core.TokenValidatorResponse;
import org.apache.cxf.fediz.core.config.CertificateValidationMethod;
import org.apache.cxf.fediz.core.config.FederationContext;
import org.apache.cxf.fediz.core.config.FederationProtocol;
import org.apache.cxf.fediz.core.config.TrustManager;
import org.apache.cxf.fediz.core.config.TrustedIssuer;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.saml.SAMLUtil;
import org.apache.cxf.fediz.core.saml.SamlAssertionValidator;
import org.apache.ws.security.SAMLTokenPrincipal;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.validate.Credential;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml1.core.Attribute;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SAMLTokenValidator
implements TokenValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLTokenValidator.class);

    @Override
    public boolean canHandleTokenType(String tokenType) {
        return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType);
    }

    @Override
    public boolean canHandleToken(Element token) {
        String ns = token.getNamespaceURI();
        return "urn:oasis:names:tc:SAML:2.0:assertion".equals(ns) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(ns);
    }

    @Override
    public TokenValidatorResponse validateAndProcessToken(TokenValidatorRequest request, FederationContext config) throws ProcessingException {
        Element token = request.getToken();
        try {
            RequestData requestData = new RequestData();
            WSSConfig wssConfig = WSSConfig.getNewInstance();
            requestData.setWssConfig(wssConfig);
            AssertionWrapper assertion = new AssertionWrapper(token);
            if (!assertion.isSigned()) {
                LOG.warn("Assertion is not signed");
                throw new ProcessingException(ProcessingException.TYPE.TOKEN_NO_SIGNATURE);
            }
            WSDocInfo docInfo = new WSDocInfo(token.getOwnerDocument());
            assertion.verifySignature(requestData, docInfo);
            assertion.parseHOKSubject(requestData, docInfo);
            Credential trustCredential = new Credential();
            SAMLKeyInfo samlKeyInfo = assertion.getSignatureKeyInfo();
            trustCredential.setPublicKey(samlKeyInfo.getPublicKey());
            trustCredential.setCertificates(samlKeyInfo.getCerts());
            trustCredential.setAssertion(assertion);
            SamlAssertionValidator trustValidator = new SamlAssertionValidator();
            trustValidator.setFutureTTL(config.getMaximumClockSkew().intValue());
            boolean trusted = false;
            String assertionIssuer = assertion.getIssuerString();
            List<TrustedIssuer> trustedIssuers = config.getTrustedIssuers();
            for (TrustedIssuer ti : trustedIssuers) {
                List<String> subjectConstraints = Collections.singletonList(ti.getSubject());
                if (ti.getCertificateValidationMethod().equals((Object)CertificateValidationMethod.CHAIN_TRUST)) {
                    trustValidator.setSubjectConstraints(subjectConstraints);
                    trustValidator.setSignatureTrustType(SamlAssertionValidator.TRUST_TYPE.CHAIN_TRUST_CONSTRAINTS);
                } else if (ti.getCertificateValidationMethod().equals((Object)CertificateValidationMethod.PEER_TRUST)) {
                    trustValidator.setSignatureTrustType(SamlAssertionValidator.TRUST_TYPE.PEER_TRUST);
                } else {
                    throw new IllegalStateException("Unsupported certificate validation method: " + (Object)((Object)ti.getCertificateValidationMethod()));
                }
                try {
                    for (TrustManager tm : config.getCertificateStores()) {
                        try {
                            requestData.setSigCrypto(tm.getCrypto());
                            trustValidator.validate(trustCredential, requestData);
                            trusted = true;
                            break;
                        }
                        catch (Exception ex) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("Issuer '" + ti.getName() + "' not validated in keystore '" + tm.getName() + "'");
                        }
                    }
                    if (!trusted) continue;
                    break;
                }
                catch (Exception ex) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info("Issuer '" + assertionIssuer + "' doesn't match trusted issuer '" + ti.getName() + "': " + ex.getMessage());
                }
            }
            if (!trusted) {
                if (!this.isConditionValid(assertion, config.getMaximumClockSkew().intValue())) {
                    LOG.warn("Security token expired");
                    throw new ProcessingException(ProcessingException.TYPE.TOKEN_EXPIRED);
                }
                LOG.warn("Issuer '" + assertionIssuer + "' not trusted");
                throw new ProcessingException(ProcessingException.TYPE.ISSUER_NOT_TRUSTED);
            }
            if (!SAMLUtil.checkHolderOfKey(assertion, request.getCerts())) {
                LOG.warn("Assertion fails holder-of-key requirements");
                throw new ProcessingException(ProcessingException.TYPE.ISSUER_NOT_TRUSTED);
            }
            String audience = null;
            List<Claim> claims = null;
            if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20)) {
                claims = this.parseClaimsInAssertion(assertion.getSaml2());
                audience = this.getAudienceRestriction(assertion.getSaml2());
            } else if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_11)) {
                claims = this.parseClaimsInAssertion(assertion.getSaml1());
                audience = this.getAudienceRestriction(assertion.getSaml1());
            }
            List<String> roles = this.parseRoles(config, claims);
            SAMLTokenPrincipal p = new SAMLTokenPrincipal(assertion);
            TokenValidatorResponse response = new TokenValidatorResponse(assertion.getId(), p.getName(), assertionIssuer, roles, new ClaimCollection((Collection<? extends Claim>)claims), audience);
            response.setExpires(this.getExpires(assertion));
            return response;
        }
        catch (WSSecurityException ex) {
            LOG.error("Security token validation failed", (Throwable)ex);
            throw new ProcessingException(ProcessingException.TYPE.TOKEN_INVALID);
        }
    }

    protected List<String> parseRoles(FederationContext config, List<Claim> claims) {
        List<String> roles = null;
        FederationProtocol fp = (FederationProtocol)config.getProtocol();
        if (fp.getRoleURI() != null) {
            URI roleURI = URI.create(fp.getRoleURI());
            String delim = fp.getRoleDelimiter();
            for (Claim c : claims) {
                if (!roleURI.equals(c.getClaimType())) continue;
                Object oValue = c.getValue();
                if (oValue instanceof String && !"".equals((String)oValue)) {
                    roles = delim == null ? Collections.singletonList((String)oValue) : this.parseRoles((String)oValue, delim);
                } else if (oValue instanceof List && !((List)oValue).isEmpty()) {
                    List values = (List)oValue;
                    roles = Collections.unmodifiableList(values);
                } else if (!(oValue instanceof String) && !(oValue instanceof List)) {
                    LOG.error("Unsupported value type of Claim value");
                    throw new IllegalStateException("Unsupported value type of Claim value");
                }
                claims.remove(c);
                break;
            }
        }
        return roles;
    }

    protected List<Claim> parseClaimsInAssertion(org.opensaml.saml1.core.Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No attribute statements found");
            }
            return Collections.emptyList();
        }
        ArrayList<Claim> collection = new ArrayList<Claim>();
        HashMap<String, Claim> claimsMap = new HashMap<String, Claim>();
        for (AttributeStatement statement : attributeStatements) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("parsing statement: " + statement.getElementQName());
            }
            List attributes = statement.getAttributes();
            for (Attribute attribute : attributes) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("parsing attribute: " + attribute.getAttributeName());
                }
                Claim c = new Claim();
                c.setIssuer(assertion.getIssuer());
                if (attribute.getAttributeNamespace() != null) {
                    URI attrName = URI.create(attribute.getAttributeName());
                    if (attrName.isAbsolute()) {
                        c.setClaimType(attrName);
                        if (attribute.getAttributeName().startsWith(attribute.getAttributeNamespace())) {
                            LOG.info("AttributeName fully qualified '" + attribute.getAttributeName() + "' but does match with AttributeNamespace '" + attribute.getAttributeNamespace() + "'");
                        } else {
                            LOG.warn("AttributeName fully qualified '" + attribute.getAttributeName() + "' but does NOT match with AttributeNamespace (ignored) '" + attribute.getAttributeNamespace() + "'");
                        }
                    } else if (attribute.getAttributeNamespace().endsWith("/")) {
                        c.setClaimType(URI.create(attribute.getAttributeNamespace() + attribute.getAttributeName()));
                    } else {
                        c.setClaimType(URI.create(attribute.getAttributeNamespace() + "/" + attribute.getAttributeName()));
                    }
                } else {
                    c.setClaimType(URI.create(attribute.getAttributeName()));
                }
                ArrayList<String> valueList = new ArrayList<String>();
                for (XMLObject attributeValue : attribute.getAttributeValues()) {
                    Element attributeValueElement = attributeValue.getDOM();
                    String value = attributeValueElement.getTextContent();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(" [" + value + "]");
                    }
                    valueList.add(value);
                }
                this.mergeClaimToMap(claimsMap, c, valueList);
            }
        }
        collection.addAll(claimsMap.values());
        return collection;
    }

    protected List<Claim> parseClaimsInAssertion(Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No attribute statements found");
            }
            return Collections.emptyList();
        }
        ArrayList<Claim> collection = new ArrayList<Claim>();
        HashMap<String, Claim> claimsMap = new HashMap<String, Claim>();
        for (org.opensaml.saml2.core.AttributeStatement statement : attributeStatements) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("parsing statement: " + statement.getElementQName());
            }
            List attributes = statement.getAttributes();
            for (org.opensaml.saml2.core.Attribute attribute : attributes) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("parsing attribute: " + attribute.getName());
                }
                Claim c = new Claim();
                URI attrName = URI.create(attribute.getName());
                if (ClaimTypes.URI_BASE.toString().equals(attribute.getNameFormat()) && !attrName.isAbsolute()) {
                    c.setClaimType(URI.create(ClaimTypes.URI_BASE + "/" + attribute.getName()));
                } else {
                    c.setClaimType(URI.create(attribute.getName()));
                }
                c.setIssuer(assertion.getIssuer().getNameQualifier());
                ArrayList<String> valueList = new ArrayList<String>();
                for (XMLObject attributeValue : attribute.getAttributeValues()) {
                    Element attributeValueElement = attributeValue.getDOM();
                    String value = attributeValueElement.getTextContent();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(" [" + value + "]");
                    }
                    valueList.add(value);
                }
                this.mergeClaimToMap(claimsMap, c, valueList);
            }
        }
        collection.addAll(claimsMap.values());
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void mergeClaimToMap(Map<String, Claim> claimsMap, Claim c, List<String> valueList) {
        Claim t = claimsMap.get(c.getClaimType().toString());
        if (t != null) {
            Object oValue = t.getValue();
            if (oValue instanceof String) {
                ArrayList<String> values = new ArrayList<String>();
                values.add((String)oValue);
                values.addAll(valueList);
                t.setValue(values);
                return;
            }
            if (oValue instanceof List) {
                List values = (List)oValue;
                values.addAll(valueList);
                t.setValue(values);
                return;
            }
            LOG.error("Unsupported value type of Claim value");
            throw new IllegalStateException("Unsupported value type of Claim value");
        }
        if (valueList.size() == 1) {
            c.setValue(valueList.get(0));
        } else {
            c.setValue(valueList);
        }
        claimsMap.put(c.getClaimType().toString(), c);
    }

    protected List<String> parseRoles(String value, String delim) {
        ArrayList<String> roles = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, delim);
        while (st.hasMoreTokens()) {
            String role = st.nextToken();
            roles.add(role);
        }
        return roles;
    }

    protected String getAudienceRestriction(org.opensaml.saml1.core.Assertion assertion) {
        String audience = null;
        try {
            audience = ((org.opensaml.saml1.core.Audience)((AudienceRestrictionCondition)assertion.getConditions().getAudienceRestrictionConditions().get(0)).getAudiences().get(0)).getUri();
        }
        catch (Exception ex) {
            LOG.warn("Failed to read audience" + ex.getMessage());
        }
        return audience;
    }

    protected String getAudienceRestriction(Assertion assertion) {
        String audience = null;
        try {
            audience = ((Audience)((AudienceRestriction)assertion.getConditions().getAudienceRestrictions().get(0)).getAudiences().get(0)).getAudienceURI();
        }
        catch (Exception ex) {
            LOG.warn("Failed to read audience" + ex.getMessage());
        }
        return audience;
    }

    private Date getExpires(AssertionWrapper assertion) {
        DateTime validTill = null;
        validTill = assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) ? assertion.getSaml2().getConditions().getNotOnOrAfter() : assertion.getSaml1().getConditions().getNotOnOrAfter();
        if (validTill == null) {
            return null;
        }
        return validTill.toDate();
    }

    protected boolean isConditionValid(AssertionWrapper assertion, int maxClockSkew) throws WSSecurityException {
        DateTime validFrom = null;
        DateTime validTill = null;
        if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) && assertion.getSaml2().getConditions() != null) {
            validFrom = assertion.getSaml2().getConditions().getNotBefore();
            validTill = assertion.getSaml2().getConditions().getNotOnOrAfter();
        } else if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_11) && assertion.getSaml1().getConditions() != null) {
            validFrom = assertion.getSaml1().getConditions().getNotBefore();
            validTill = assertion.getSaml1().getConditions().getNotOnOrAfter();
        }
        if (validFrom != null) {
            DateTime currentTime = new DateTime();
            if (validFrom.isAfter((ReadableInstant)(currentTime = currentTime.plusSeconds(maxClockSkew)))) {
                LOG.debug("SAML Token condition (Not Before) not met");
                return false;
            }
        }
        if (validTill != null && validTill.isBeforeNow()) {
            LOG.debug("SAML Token condition (Not On Or After) not met");
            return false;
        }
        return true;
    }
}

